topic "Draw Colors";
[i448;a25;kKO9;2 $$1,0#37138531426314131252341829483380:class]
[l288;2 $$2,2#27521748481378242620020725143825:desc]
[0 $$3,0#96390100711032703541132217272105:end]
[H6;0 $$4,0#05600065144404261032431302351956:begin]
[i448;a25;kKO9;2 $$5,0#37138531426314131252341829483370:item]
[l288;a4;*@5;1 $$6,6#70004532496200323422659154056402:requirement]
[l288;i1121;b17;O9;~~~.1408;2 $$7,0#10431211400427159095818037425705:param]
[i448;b42;O9;2 $$8,8#61672508125594000341940100500538:tparam]
[b42;2 $$9,9#13035079074754324216151401829390:normal]
[2 $$0,0#00000000000000000000000000000000:Default]
[{_} 
[ {{10000@(113.42.0) [s0;%% [*@7;4 Draw Colors]]}}&]
[s0;%% &]
[s0;%% U`+`+ provides a set of colors that are adjusted according 
to current settings of host platform. Using these colors makes 
it easier to adapt the application to host platform settings.&]
[s0;%% &]
[s0;%% Following table shows colors that represent certain hue. When 
transformed to dark theme, hue is maintained while brightness 
of color changes.&]
[s0;3 &]
[ {{3044:3508:1778:1670@7 [s0; Color]
:: [s0; Description]
:: [s0;= Light theme]
:: [s0;= Dark theme]
::@2 [s0;:SBlack`(`): Color [* SBlack]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAj0lEQVR4nO3SMQEAIAzAsIF/zyBjRxMFPXpm5g1ZdzuAXQaIM0CcAeIMEGeAOAPEGSDOAHEGiDNAnAHiDBBngDgDxBkgzgBxBogzQJwB4gwQZ4A4A8QZIM4AcQaIM0CcAeIMEGeAOAPEGSDOAHEGiDNAnAHiDBBngDgDxBkgzgBxBogzQJwB4gwQZ4A4A8R9O7IBXz2gPQkAAAAASUVORK5CYII=)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAo0lEQVR4nO3cMQ4DIQwAQfuU/3+Z1JcPIGVnOqhcrCwqdmbOkPXcHoC7BBAngLjP78U5ngT/bHdfZxsgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAuB1/BafZAHECiBNA3Bc0ZQVfjRhi4wAAAABJRU5ErkJggg==)
]
:: [s0;:SGray`(`): Color [* SGray]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAoklEQVR4nO3csQ2AMAwAQYMYPJtDnwFI8XdlKkt+ucw1M++QdZ8egLMEECeAuGd/WGsdGIO/7Pt1AeIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAoi7xl/BaS5AnADiBBD3AWnYBV9ILIgyAAAAAElFTkSuQmCC)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApklEQVR4nO3csRHDMAwAMTqXETWmdozreACreKCjKhZ/LHXNzG/I+pxegLMEECeAuO/zYe99Yg9estb6m12AOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4q7xV3CaCxAngDgBxN1hZwVf7qeJGgAAAABJRU5ErkJggg==)
]
:: [s0;:SLtGray`(`): Color [* SLtGray]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApklEQVR4nO3csRHDMAwAMTqXwTS6NovreACreKCjKhZ/LHXNzG/I+pxegLMEECeAuO/zYe99YA3estb6m12AOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4q7xV3CaCxAngDgBxN3R5wVfdD2WnwAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApklEQVR4nO3csRHDMAwAMTqXSTWYVo3reACreKCjKhZ/LHXNzG/I+pxegLMEECeAuO/zYa11Yg9esvf+m12AOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4q7xV3CaCxAngDgBxN3BCQVfcbpN1QAAAABJRU5ErkJggg==)
]
:: [s0;:SWhiteGray`(`): Color [* SWhiteGray]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAqElEQVR4nO3csRHDMAwAMTqXQbT/VNokruMBrOKBjqpY/LHUNTO/IetzegHOEkCcAOK+z4e994E1eMta6292AeIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAoi7xl/BaS5AnADiBBB3A4X2BV9yW5SEAAAAAElFTkSuQmCC)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAqElEQVR4nO3csRHDMAwAMTqXhbT/EBopruMBrOKBjqpY/LHUNTO/IetzegHOEkCcAOK+z4e11ok9eMne+292AeIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAoi7xl/BaS5AnADiBBB3A61aBV8zkBY7AAAAAElFTkSuQmCC)
]
:: [s0;:SWhite`(`): Color [* SWhite]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAo0lEQVR4nO3cMQ4DIQwAQfuU/3+Z1JcPIGVnOqhcrCwqdmbOkPXcHoC7BBAngLjP78U5ngT/bHdfZxsgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAuB1/BafZAHECiBNA3Bc0ZQVfjRhi4wAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApElEQVR4nO3coREDMQwAQSnz/bfsx0kBMbhdKCRwozHyzswZsj63F+AuAcQJIO75HezujT34k3O+n3wuQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHE7/gpOcwHiBBAngLgXn0sFX43/O6IAAAAASUVORK5CYII=)
]
:: [s0;:SRed`(`): Color [* SRed]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAoElEQVR4nO3cIRKAMAwAwZTh4fwcfB9Axe26VEXcRHbNzDtkXacX4CwBxAkg7t4fngNL8J9nm12AOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4tb4KzjNBYgTQJwA4j4MpgNfMrF/PgAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAqElEQVR4nO3csRHDMAwAMSqXUbT/RN7Frp0BouKBjqpY/LHUmpl7yPqcXoCzBBAngLjv78N9XSf24E/W3q/ZBYgTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBujb+C01yAOAHECSDuAbEWBV+8P7mcAAAAAElFTkSuQmCC)
]
:: [s0;:SGreen`(`): Color [* SGreen]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAoUlEQVR4nO3cIRKAMAwAwcDw8P4cNIOn4nZdqiJuInvMzD1knbsXYC8BxAkg7vq8rP+X4EfrPboAcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxB3jr+A0FyBOAHECiHsAC6YDXwH4CugAAAAASUVORK5CYII=)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAp0lEQVR4nO3csRHDMAwAMSqXDTWnZ7RrZ4CoeKCjKhZ/LLVm5h6yPqcX4CwBxAkg7vv7cN3XiT34k732a3YB4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiFvjr+A0FyBOAHECiHsAANYFXxK83xwAAAAASUVORK5CYII=)
]
:: [s0;:SBrown`(`): Color [* SBrown]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAoUlEQVR4nO3csQ2AMAwAQQcxOJtDnwFI8XdlKkt+ucyamXfIuk4PwFkCiBNA3L0/PM+BKfjNvl8XIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngLg1/gpOcwHiBBAngLgPO78EX7brwjQAAAAASUVORK5CYII=)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAqklEQVR4nO3csRGDQAwAQcG4GgqiSAqiHRzbBfDB7Wb6SMGNwt9m5hmy9tULsJYA4gQQ9/l/uO9zxR685Diun9kFiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIG4bfwWnuQBxAogTQNwXXacFX4C/jK8AAAAASUVORK5CYII=)
]
:: [s0;:SBlue`(`): Color [* SBlue]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAoUlEQVR4nO3cIRKAMAwAwcDw8P4cNIOn4nZdqiJuInvMzD1knbsXYC8BxAkg7vo+rd+X4E/rNbkAcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxB3jr+A0FyBOAHECiHsACqYDX9hfCz0AAAAASUVORK5CYII=)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApklEQVR4nO3csQ2AMAwAQQexAvsPyBBQwwJI/F2XVC5eVqqsmbmGrO3rAfiWAOIEELe/L87Tk+DPjmM9zjZAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcWv8FZxmA8QJIE4AcTfpVgVfg/LKywAAAABJRU5ErkJggg==)
]
:: [s0;:SMagenta`(`): Color [* SMagenta]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAoklEQVR4nO3csQ2AMAwAQQcxOJtDDQtE4u+6pHLxslJlzcw9ZB27B2AvAcQJIO78XlyeBL92zXqdbYA4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADi1vgrOM0GiBNAnADiHijuBF9hjWTmAAAAAElFTkSuQmCC)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApUlEQVR4nO3csQ2AMAwAQQexLfMwL9SwABJ/1yWVi5eVKmtmriFr+3oAviWAOAHE7e+L6/Qk+LN1rMfZBogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBujb+C02yAOAHECSDuBm2WBV8Zr/+9AAAAAElFTkSuQmCC)
]
:: [s0;:SCyan`(`): Color [* SCyan]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAoUlEQVR4nO3csQ2AMAwAQYMYPJtDDz0p/q5MZckvlzlm5h6yzt0DsJcA4gQQd31e1vp/Cv7z2q8LECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQNwx/gpOcwHiBBAngLgHOb8EX7rNM+IAAAAASUVORK5CYII=)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAqklEQVR4nO3csRGDQAwAQcG4BMqkHMqkBxzbBfDB7Wb6SMGNwt9m5hmy9tULsJYA4gQQ9/l/OO97xR685DqOn9kFiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIG4bfwWnuQBxAogTQNwX2WcFX1nz1MIAAAAASUVORK5CYII=)
]
:: [s0;:SYellow`(`): Color [* SYellow]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAoUlEQVR4nO3csQ3AIAwAQRNl/5VJnSyAlL/roHLxsqhYM7OHrOv0AJwlgDgBxN3fi+1F8Gtrvc82QJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHFr/BWcZgPECSBOAHEPGB0EX/Jjm8UAAAAASUVORK5CYII=)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApElEQVR4nO3coRGAQAwAwcDQKXVRK2gogBe36/Iq4ibyt5m5h6x99QKsJYA4AcQd34fzXLEGf7mu9+wCxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEELeNv4LTXIA4AcQJIO4BzvAEXzth/+cAAAAASUVORK5CYII=)
]
:: [s0;:SLtRed`(`): Color [* SLtRed]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAn0lEQVR4nO3csQ3AIAwAQRNl/5WTngWQ+LsOKhcvi4o1M9+Q9ZwegLMEECeAuHe/8CC429rONkCcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxa3wNmGYDxAkgTgBxP/rGA1806Pp9AAAAAElFTkSuQmCC)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAp0lEQVR4nO3csRHDMAwAMSqX3TSzp7NrZ4CoeKCjKhZ/LLVm5h6yPqcX4CwBxAkg7vv7cF/XiT34k7X3a3YB4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiFvjr+A0FyBOAHECiHsALdYFX+WNht8AAAAASUVORK5CYII=)
]
:: [s0;:SLtGreen`(`): Color [* SLtGreen]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAoElEQVR4nO3csQ3AIAwAQRNl/5WTOmIApPxdB5WLl0XFmplnyLpOD8BZAogTQNy93XgR/Nv6Hm2AOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4tb4GTDNBogTQJwA4l75xgNfANzOAQAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAp0lEQVR4nO3csRHDMAwAMSqXKTWg17RrZ4CoeKCjKhZ/LLVm5h6yPqcX4CwBxAkg7vv7sO99Yg/+5FrXa3YB4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiFvjr+A0FyBOAHECiHsAyXgFX6RnSpkAAAAASUVORK5CYII=)
]
:: [s0;:SLtYellow`(`): Color [* SLtYellow]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApklEQVR4nO3csRHDMAwAMcqXwTK6N5NrZ4CoeKCjKhZ/LLVmZg9Z1+kFOEsAcQKI+/w+7H0fWIN/Wev7ml2AOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4tb4KzjNBYgTQJwA4h6+NgVf86PGywAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApUlEQVR4nO3coRGAQAwAwcBQBf3XRhugoQBe3K7Lq4ibyN9m5h6y9tULsJYA4gQQd3wfznPFGvzlut6zCxAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0DcNv4KTnMB4gQQJ4C4B70hBF/vQFr5AAAAAElFTkSuQmCC)
]
:: [s0;:SLtBlue`(`): Color [* SLtBlue]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAoElEQVR4nO3csQ3AIAwAQRNl/5WTOmIApPxdB5WLl0XFmplnyLpOD8BZAogTQNy9X3kS/Nv6nGyAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4tb4GDDNBogTQJwA4l74xgNfWe9guAAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApklEQVR4nO3csQ2AMAwAQQcxDfvPwjpQwwJI/F2XVC5eVqqsmbmGrO3rAfiWAOIEELe/L87Tk+DPjmM9zjZAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcWv8FZxmA8QJIE4AcTealgVfodX7qgAAAABJRU5ErkJggg==)
]
:: [s0;:SLtMagenta`(`): Color [* SLtMagenta]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAoklEQVR4nO3csQ3AIAwAQRNl/5VJnSyAlL/roHLxsqhYM7OHrOv0AJwlgDgBxN3fi+1J8Gtr1utsA8QJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBC3xl/BaTZAnADiBBD3ABcdBF+vmvxNAAAAAElFTkSuQmCC)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApUlEQVR4nO3csQ2AMAwAQQexLBMxLtSwABJ/1yWVi5eVKmtmriFr+3oAviWAOAHE7e+L6/Qk+LN1rMfZBogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBujb+C02yAOAHECSDuBnFWBV+glOj/AAAAAElFTkSuQmCC)
]
:: [s0;:SLtCyan`(`): Color [* SLtCyan]()]
:: [s0; Possibly theme adjusted color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAoklEQVR4nO3csQ3AIAwAQRNl/5VJHWUApPxdB5WLl0XFmpk9ZF2nB+AsAcQJIO7+3GxPgl9b63W0AeIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAohb46/gNBsgTgBxAoh7ABYdBF8AAu2iAAAAAElFTkSuQmCC)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApElEQVR4nO3coRGAQAwAwcDQIzVSJWgGz4vbdXkVcRP528zcQ9a+egHWEkCcAOKOz8t1LViD35zna3QB4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiNvGX8FpLkCcAOIEEPcA038EXwIEgSEAAAAASUVORK5CYII=)
]}}&]
[s0;%% &]
[s0;%% Following colors provide host platform provided information 
about colors of GUI element parts:&]
[s0; &]
[ {{3044:3508:1778:1670@7 [s0; Color]
:: [s0; Description]
:: [s0;= Win 10 light]
:: [s0;= Win 10 dark]
::@2 [s0;:SColorPaper`(`): Color [* SColorPaper]()]
:: [s0; Normal background.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAo0lEQVR4nO3cMQ4DIQwAQfuU/3+Z1JcPIGVnOqhcrCwqdmbOkPXcHoC7BBAngLjP78U5ngT/bHdfZxsgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAuB1/BafZAHECiBNA3Bc0ZQVfjRhi4wAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApElEQVR4nO3coREDMQwAQSnz/bfsx0kBMbhdKCRwozHyzswZsj63F+AuAcQJIO75HezujT34k3O+n3wuQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHE7/gpOcwHiBBAngLgXn0sFX43/O6IAAAAASUVORK5CYII=)
]
:: [s0;:SColorText`(`): Color [* SColorText]()]
:: [s0; Normal text.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAj0lEQVR4nO3SMQEAIAzAsIF/zyBjRxMFPXpm5g1ZdzuAXQaIM0CcAeIMEGeAOAPEGSDOAHEGiDNAnAHiDBBngDgDxBkgzgBxBogzQJwB4gwQZ4A4A8QZIM4AcQaIM0CcAeIMEGeAOAPEGSDOAHEGiDNAnAHiDBBngDgDxBkgzgBxBogzQJwB4gwQZ4A4A8R9O7IBXz2gPQkAAAAASUVORK5CYII=)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAo0lEQVR4nO3cMQ4DIQwAQfuU/3+Z1JcPIGVnOqhcrCwqdmbOkPXcHoC7BBAngLjP78U5ngT/bHdfZxsgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAuB1/BafZAHECiBNA3Bc0ZQVfjRhi4wAAAABJRU5ErkJggg==)
]
:: [s0;:SColorFace`(`): Color [* SColorFace]()]
:: [s0; Dialog background.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAqElEQVR4nO3csRHDMAwAMTqXAbT/lNogruMBrOKBjqpY/LHUNTO/IetzegHOEkCcAOK+z4e994k9eMla6292AeIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAoi7xl/BaS5AnADiBBB3A9/2BV/DZ4jVAAAAAElFTkSuQmCC)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAqElEQVR4nO3csRHDMAwAMTqXIbT/dNoiruMBrOKBjqpY/LHUNTO/IetzegHOEkCcAOK+z4e11ok9eMne+292AeIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAoi7xl/BaS5AnADiBBB3AyC6BV9Rcj7oAAAAAElFTkSuQmCC)
]
:: [s0;:SColorHighlight`(`): Color [* SColorHighlight]()]
:: [s0; Background of selected item.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAqUlEQVR4nO3csRGDQAwAQcG4GXdICXRIOSZmnPPB7Wb6SMGNwt9m5jdk7asXYC0BxAkg7vP3clwL1uA15/cxugBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHEbeOv4DQXIE4AcQKIuwHN3wRfLntksgAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAqklEQVR4nO3csQ2EMBAAwfOLXr4uKvu6qAZivgEkdiazowtWJ0deM3MOWZ+nB+BZAogTQNz2f7EfngRv9vuu29kGiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIG6Nv4LTbIA4AcQJIO4CxMcFX0RFMYMAAAAASUVORK5CYII=)
]
:: [s0;:SColorHighlightText`(`): Color [* SColorHighlightText]()]
:: [s0; Text of selected item.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAo0lEQVR4nO3cMQ4DIQwAQfuU/3+Z1JcPIGVnOqhcrCwqdmbOkPXcHoC7BBAngLjP78U5ngT/bHdfZxsgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAuB1/BafZAHECiBNA3Bc0ZQVfjRhi4wAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApElEQVR4nO3coREDMQwAQSnz/bfsx0kBMbhdKCRwozHyzswZsj63F+AuAcQJIO75HezujT34k3O+n3wuQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHE7/gpOcwHiBBAngLgXn0sFX43/O6IAAAAASUVORK5CYII=)
]
:: [s0;:SColorMenu`(`): Color [* SColorMenu]()]
:: [s0; Normal menu background.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAqElEQVR4nO3csRHDMAwAMTqXAbT/lNogruMBrOKBjqpY/LHUNTO/IetzegHOEkCcAOK+z4e994k9eMla6292AeIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAoi7xl/BaS5AnADiBBB3A9/2BV/DZ4jVAAAAAElFTkSuQmCC)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAqElEQVR4nO3csRHDMAwAMTqXIbT/dNoiruMBrOKBjqpY/LHUNTO/IetzegHOEkCcAOK+z4e11ok9eMne+292AeIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAoi7xl/BaS5AnADiBBB3AyC6BV9Rcj7oAAAAAElFTkSuQmCC)
]
:: [s0;:SColorMenuText`(`): Color [* SColorMenuText]()]
:: [s0; Normal text background.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAj0lEQVR4nO3SMQEAIAzAsIF/zyBjRxMFPXpm5g1ZdzuAXQaIM0CcAeIMEGeAOAPEGSDOAHEGiDNAnAHiDBBngDgDxBkgzgBxBogzQJwB4gwQZ4A4A8QZIM4AcQaIM0CcAeIMEGeAOAPEGSDOAHEGiDNAnAHiDBBngDgDxBkgzgBxBogzQJwB4gwQZ4A4A8R9O7IBXz2gPQkAAAAASUVORK5CYII=)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAo0lEQVR4nO3cMQ4DIQwAQfuU/3+Z1JcPIGVnOqhcrCwqdmbOkPXcHoC7BBAngLjP78U5ngT/bHdfZxsgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAuB1/BafZAHECiBNA3Bc0ZQVfjRhi4wAAAABJRU5ErkJggg==)
]
:: [s0;:SColorInfo`(`): Color [* SColorInfo]()]
:: [s0; Tooltip background.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAqElEQVR4nO3csRHDMAwAMcqXPbL/WJ5Erp0BouKBjqpY/LHUmpk9ZF2nF+AsAcQJIO7z+7D3fWIP/mSt72t2AeIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAohb46/gNBcgTgBxAoh7APwWBV/vrz2yAAAAAElFTkSuQmCC)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApElEQVR4nO3coRGAQAwAwcBg6b9QCgANBfDidl1eRdxE/jYz95C1r16AtQQQJ4C44/twnivW4C/X9Z5dgDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOK28VdwmgsQJ4A4AcQ9jGEEX8ofrxUAAAAASUVORK5CYII=)
]
:: [s0;:SColorInfoText`(`): Color [* SColorInfoText]()]
:: [s0; Tooltip text.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAj0lEQVR4nO3SMQEAIAzAsIF/zyBjRxMFPXpm5g1ZdzuAXQaIM0CcAeIMEGeAOAPEGSDOAHEGiDNAnAHiDBBngDgDxBkgzgBxBogzQJwB4gwQZ4A4A8QZIM4AcQaIM0CcAeIMEGeAOAPEGSDOAHEGiDNAnAHiDBBngDgDxBkgzgBxBogzQJwB4gwQZ4A4A8R9O7IBXz2gPQkAAAAASUVORK5CYII=)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAo0lEQVR4nO3cMQ4DIQwAQfuU/3+Z1JcPIGVnOqhcrCwqdmbOkPXcHoC7BBAngLjP78U5ngT/bHdfZxsgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAuB1/BafZAHECiBNA3Bc0ZQVfjRhi4wAAAABJRU5ErkJggg==)
]
:: [s0;:SColorMark`(`): Color [* SColorMark]()]
:: [s0; Marked text, e.g. hyperlink.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAoElEQVR4nO3csQ3AIAwAQRNl/5WTOmIApPxdB5WLl0XFmplnyLpOD8BZAogTQNy9X3kS/Nv6nGyAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4tb4GDDNBogTQJwA4l74xgNfWe9guAAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApklEQVR4nO3csQ2AMAwAQQcxDfvPwjpQwwJI/F2XVC5eVqqsmbmGrO3rAfiWAOIEELe/L87Tk+DPjmM9zjZAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcWv8FZxmA8QJIE4AcTealgVfodX7qgAAAABJRU5ErkJggg==)
]
:: [s0;:SColorMenuMark`(`): Color [* SColorMenuMark]()]
:: [s0; Marked text in menu.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAoElEQVR4nO3csQ3AIAwAQRNl/5WTOmIApPxdB5WLl0XFmplnyLpOD8BZAogTQNy9X3kS/Nv6nGyAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4tb4GDDNBogTQJwA4l74xgNfWe9guAAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApklEQVR4nO3csQ2AMAwAQQcxDfvPwjpQwwJI/F2XVC5eVqqsmbmGrO3rAfiWAOIEELe/L87Tk+DPjmM9zjZAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcWv8FZxmA8QJIE4AcTealgVfodX7qgAAAABJRU5ErkJggg==)
]
:: [s0;:SColorDisabled`(`): Color [* SColorDisabled]()]
:: [s0; Disabled item text.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApklEQVR4nO3csRHDMAwAMTqXdTWNBo7reACreKCjKhZ/LHXNzG/I+pxegLMEECeAuO/zYa11Yg9esvf+m12AOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4q7xV3CaCxAngDgBxN3+6QVf9LrqGQAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApklEQVR4nO3csRHDMAwAMTqX4TSytovreACreKCjKhZ/LHXNzG/I+pxegLMEECeAuO/zYe99Yg9estb6m12AOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4q7xV3CaCxAngDgBxN2k5wVfpmbH0wAAAABJRU5ErkJggg==)
]
:: [s0;:SColorLight`(`): Color [* SColorLight]()]
:: [s0; Light side of 3D bezel.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAo0lEQVR4nO3cMQ4DIQwAQfuU/3+Z1JcPIGVnOqhcrCwqdmbOkPXcHoC7BBAngLjP78U5ngT/bHdfZxsgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAuB1/BafZAHECiBNA3Bc0ZQVfjRhi4wAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApElEQVR4nO3coREDMQwAQSnz/bfsx0kBMbhdKCRwozHyzswZsj63F+AuAcQJIO75HezujT34k3O+n3wuQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHE7/gpOcwHiBBAngLgXn0sFX43/O6IAAAAASUVORK5CYII=)
]
:: [s0;:SColorLabel`(`): Color [* SColorLabel]()]
:: [s0; Label text color.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAj0lEQVR4nO3SMQEAIAzAsIF/zyBjRxMFPXpm5g1ZdzuAXQaIM0CcAeIMEGeAOAPEGSDOAHEGiDNAnAHiDBBngDgDxBkgzgBxBogzQJwB4gwQZ4A4A8QZIM4AcQaIM0CcAeIMEGeAOAPEGSDOAHEGiDNAnAHiDBBngDgDxBkgzgBxBogzQJwB4gwQZ4A4A8R9O7IBXz2gPQkAAAAASUVORK5CYII=)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAo0lEQVR4nO3cMQ4DIQwAQfuU/3+Z1JcPIGVnOqhcrCwqdmbOkPXcHoC7BBAngLjP78U5ngT/bHdfZxsgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAuB1/BafZAHECiBNA3Bc0ZQVfjRhi4wAAAABJRU5ErkJggg==)
]
:: [s0;:SColorShadow`(`): Color [* SColorShadow]()]
:: [s0; Dark side of 3D bezel.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApklEQVR4nO3csRHDMAwAMTqXQTWaNo3reACreKCjKhZ/LHXNzG/I+pxegLMEECeAuO/zYe99YA3estb6m12AOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4q7xV3CaCxAngDgBxN0d5wVfS0RcFAAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApklEQVR4nO3csRHDMAwAMTqXdTWNBo7reACreKCjKhZ/LHXNzG/I+pxegLMEECeAuO/zYe99Yg9estb6m12AOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4q7xV3CaCxAngDgBxN3UuAVfZki0iwAAAABJRU5ErkJggg==)
]
:: [s0;:SColorLtFace`(`): Color [* SColorLtFace]()]
:: [s0; Somewhat lighter SColorFace.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApklEQVR4nO3cIRLDMAwAQaVT4v8/1rDBzQNicLtMRgI3gr5m5jdkfU4vwFkCiBNA3Pf5sPc+sQcvWWv9zS5AnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4Acdf4KzjNBYgTQJwA4m4HZQVf5ov4gQAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAp0lEQVR4nO3cIRLDMAwAQaVT6v8/1A9ocPOAGNwuk5HAjaCvmfkNWZ/TC3CWAOIEEPd9Pqy1TuzBS/bef7MLECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQNw1/gpOcwHiBBAngLgb4ssFXzHiK8UAAAAASUVORK5CYII=)
]
:: [s0;:SColorDkShadow`(`): Color [* SColorDkShadow]()]
:: [s0; Somewhat darker SColorShadow.]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAApklEQVR4nO3csRHDMAwAMTqX/TSrJozreACreKCjKhZ/LHXNzG/I+pxegLMEECeAuO/zYa11Yg9esvf+m12AOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4q7xV3CaCxAngDgBxN1WKQVfMEtQ1gAAAABJRU5ErkJggg==)
]
:: [s0;= 
@@rawimage:256&96
(iVBORw0KGgoAAAANSUhEUgAAAIAAAAAwCAYAAADZ9HK+AAAACXBIWXMAAAAAAAAAAAHqZRakAAAAqElEQVR4nO3csRHDMAwAMTqXkbT/BNopruMBrOKBjqpY/LHUNTO/IetzegHOEkCcAOK+z4e994k9eMla6292AeIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAogTQJwA4gQQJ4A4AcQJIE4AcQKIE0CcAOIEECeAOAHECSBOAHECiBNAnADiBBAngDgBxAkgTgBxAoi7xl/BaS5AnADiBBB3AxV2BV8hT9uYAAAAAElFTkSuQmCC)
]}}&]
[s3; &]
[s4; &]
[s5;:Upp`:`:IsDarkTheme`(`): [@(0.0.255) bool]_[* IsDarkTheme]()&]
[s2;%% Returns true if SColorPaper is dark, which is indicator of 
dark theme.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:AdjustIfDark`(Upp`:`:Color`): [_^Upp`:`:Color^ Color]_[* AdjustIfDark]([_^Upp`:`:Color^ C
olor]_[*@3 c])&]
[s2;%% If current color scheme is dark, color [%-*@3 c] (which should 
be intended for light theme) is adjusted to dark theme.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:DefaultInk`(`): [_^Upp`:`:Color^ Color]_[* DefaultInk]()&]
[s2;%% This special pseudo`-color is used as default argument to 
several Draw methods. Inside Draw, DefaultInk is converted to 
White() if the Draw target is pixels and dark theme is active, 
otherwise it resolves to Black().&]
[s3; &]
[s4; &]
[s5;:Upp`:`:InvertColor`(`): [_^Upp`:`:Color^ Color]_[* InvertColor]()&]
[s2;%% This special pseudo`-color can be used with Draw`::DrawRect 
for pixel targets and instructs DrawRect to invert target pixels 
(perform binary not on all color channels).&]
[s0;%% ]]