topic "Draw Tutorial";
[l288;i1120;a17;O9;~~~.1408;2 $$1,0#10431211400427159095818037425705:param]
[a83;*R6 $$2,5#31310162474203024125188417583966:caption]
[H4;b83;*4 $$3,5#07864147445237544204411237157677:title]
[i288;O9;C2 $$4,6#40027414424643823182269349404212:item]
[b42;a42;ph2 $$5,5#45413000475342174754091244180557:text]
[l288;b17;a17;2 $$6,6#27521748481378242620020725143825:desc]
[l321;t246;C@5+75 $$7,7#20902679421464641399138805415013:code]
[b2503;2 $$8,0#65142375456100023862071332075487:separator]
[*@(0.0.255)2 $$9,0#83433469410354161042741608181528:base]
[t4167;C2 $$10,0#37138531426314131251341829483380:class]
[l288;a17;*1 $$11,11#70004532496200323422659154056402:requirement]
[i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam]
[b167;C2 $$13,13#92430459443460461911108080531343:item1]
[i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2]
[*@2$(0.128.128)2 $$15,15#34511555403152284025741354420178:NewsDate]
[l321;*C$7;2 $$16,16#03451589433145915344929335295360:result]
[l321;b83;a83;*C$7;2 $$17,17#07531550463529505371228428965313:result`-line]
[l160;t4167;*C+117 $$18,5#88603949442205825958800053222425:package`-title]
[2 $$19,0#53580023442335529039900623488521:gap]
[t4167;C2 $$20,20#70211524482531209251820423858195:class`-nested]
[b50;2 $$21,21#03324558446220344731010354752573:Par]
[i448;a25;kKO9;*@(64)2 $$22,0#37138531426314131252341829483370:item]
[2 $$0,0#00000000000000000000000000000000:Default]
[{_} 
[s2;%% Draw tutorial&]
[s3;%% Table of contents&]
[s0;%% &]
[s0;%% [^topic`:`/`/Draw`/srcdoc`/DrawTutorial`$en`-us`#1^ 1. Basic 
drawing operations]&]
[s0;%% [^topic`:`/`/Draw`/srcdoc`/DrawTutorial`$en`-us`#2^ 2. Offsets 
and clipping]&]
[s0;%% [^topic`:`/`/Draw`/srcdoc`/DrawTutorial`$en`-us`#3^ 3. Fonts 
and font metrics]&]
[s0;%% [^topic`:`/`/Draw`/srcdoc`/DrawTutorial`$en`-us`#4^ 4. DrawingDraw]&]
[s0;%% [^topic`:`/`/Draw`/srcdoc`/DrawTutorial`$en`-us`#5^ 5. ImageDraw]&]
[s0;%% [^topic`:`/`/Draw`/srcdoc`/DrawTutorial`$en`-us`#6^ 6. Printing]&]
[s0;%% &]
[s3;:1:%% 1. Basic Drawing Operations&]
[s5;%% Draw class is base class representing graphical output. It 
is intentionally designed with quite limited set of easy to use 
drawing primitives. Unlike most of other similar classes in competing 
toolkits, U`+`+ drawing operations are [*/ stateless] `- there 
is no separate setup of e.g. line width, pen color etc, all necessary 
painting attributes are parameters of respective methods.&]
[s5;%% &]
[s0;l320; [C@(128.0.255)+75 #include][C+75  ][C@(0.0.255)+75 <][C+75 CtrlLib][C@(0.0.255)+75 /][C+75 C
trlLib][C@(0.0.255)+75 .][C+75 h][C@(0.0.255)+75 >]&]
[s0;l320;C+75 &]
[s0;l320; [*C@(0.0.255)+75 using][C+75  ][*C@(0.0.255)+75 namespace][C+75  
Upp;]&]
[s0;l320;C+75 &]
[s0;l320; [*C@(0.0.255)+75 struct][C+75  MyApp ][C@(0.0.255)+75 :][C+75  TopWindow 
`{]&]
[s0;l320; [C+75     ][*C@(0.0.255)+75 void][C+75  Paint(Draw][C@(0.0.255)+75 `&][C+75  
w) ][*C@(0.0.255)+75 override][C+75  `{]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawRect][C+75 (GetSize(), 
White());]&]
[s0;l320;C+75 &]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawRect][C+75 (][C@3+75 10][C+75 , 
][C@3+75 10][C+75 , ][C@3+75 60][C+75 , ][C@3+75 80][C+75 , Green());]&]
[s0;l320;C+75 &]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawLine][C+75 (][C@3+75 100][C+75 , 
][C@3+75 10][C+75 , ][C@3+75 160][C+75 , ][C@3+75 80][C+75 , ][C@3+75 0][C+75 , 
Black());]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawLine][C+75 (][C@3+75 160][C+75 , 
][C@3+75 10][C+75 , ][C@3+75 100][C+75 , ][C@3+75 80][C+75 , ][C@3+75 4][C+75 , 
Red());]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawLine][C+75 (][C@3+75 160][C+75 , 
][C@3+75 40][C+75 , ][C@3+75 100][C+75 , ][C@3+75 50][C+75 , PEN`_DOT, Red());]&]
[s0;l320;C+75 &]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawEllipse][C+75 (][C@3+75 210][C+75 , 
][C@3+75 20][C+75 , ][C@3+75 80][C+75 , ][C@3+75 60][C+75 , Blue());]&]
[s0;l320;C+75 &]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawEllipse][C+75 (][C@3+75 310][C+75 , 
][C@3+75 20][C+75 , ][C@3+75 80][C+75 , ][C@3+75 60][C+75 , LtBlue(), ][C@3+75 5][C+75 , 
Red());]&]
[s0;l320;C+75 &]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawArc][C+75 (RectC(][C@3+75 410][C+75 , 
][C@3+75 20][C+75 , ][C@3+75 80][C+75 , ][C@3+75 60][C+75 ), Point(][C@3+75 10][C+75 , 
][C@3+75 10][C+75 ), Point(][C@3+75 450][C+75 , ][C@3+75 80][C+75 ), ][C@3+75 3][C+75 , 
Cyan);]&]
[s0;l320;C+75 &]
[s0;l320; [C+75         Vector][C@(0.0.255)+75 <][C+75 Point][C@(0.0.255)+75 >][C+75  
p;]&]
[s0;l320; [C+75         p ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 30][C+75 , 
][C@3+75 110][C+75 ) ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 60][C+75 , 
][C@3+75 180][C+75 ) ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 10][C+75 , 
][C@3+75 150][C+75 ) ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 70][C+75 , 
][C@3+75 150][C+75 );]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawPolyline][C+75 (p, 
][C@3+75 4][C+75 , Black);]&]
[s0;l320;C+75 &]
[s0;l320; [C+75         p][C@(0.0.255)+75 .][C+75 Clear();]&]
[s0;l320; [C+75         p ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 130][C+75 , 
][C@3+75 110][C+75 ) ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 160][C+75 , 
][C@3+75 180][C+75 ) ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 110][C+75 , 
][C@3+75 150][C+75 ) ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 170][C+75 , 
][C@3+75 120][C+75 )]&]
[s0;l320; [C+75           ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 130][C+75 , 
][C@3+75 110][C+75 );]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawPolygon][C+75 (p, 
Blue);]&]
[s0;l320;C+75 &]
[s0;l320; [C+75         p][C@(0.0.255)+75 .][C+75 Clear();]&]
[s0;l320; [C+75         p ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 230][C+75 , 
][C@3+75 110][C+75 ) ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 260][C+75 , 
][C@3+75 180][C+75 ) ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 210][C+75 , 
][C@3+75 150][C+75 ) ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 270][C+75 , 
][C@3+75 120][C+75 )]&]
[s0;l320; [C+75           ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 230][C+75 , 
][C@3+75 110][C+75 );]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawPolygon][C+75 (p, 
Cyan, ][C@3+75 5][C+75 , Magenta);]&]
[s0;l320;C+75 &]
[s0;l320; [C+75         p][C@(0.0.255)+75 .][C+75 Clear();]&]
[s0;l320; [C+75         p ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 330][C+75 , 
][C@3+75 110][C+75 ) ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 360][C+75 , 
][C@3+75 180][C+75 ) ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 310][C+75 , 
][C@3+75 150][C+75 ) ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 370][C+75 , 
][C@3+75 120][C+75 )]&]
[s0;l320; [C+75           ][C@(0.0.255)+75 <<][C+75  Point(][C@3+75 330][C+75 , 
][C@3+75 110][C+75 );]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawPolygon][C+75 (p, 
Cyan, ][C@3+75 5][C+75 , Magenta, I64(][C@5+75 0xaa55aa55aa55aa55][C+75 ));]&]
[s0;l320;C+75 &]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawImage][C+75 (][C@3+75 40][C+75 , 
][C@3+75 240][C+75 , CtrlImg][C@(0.0.255)+75 `::][C+75 save());]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawImage][C+75 (][C@3+75 110][C+75 , 
][C@3+75 210][C+75 , ][C@3+75 80][C+75 , ][C@3+75 80][C+75 , CtrlImg][C@(0.0.255)+75 `::][C+75 sav
e());]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawImage][C+75 (][C@3+75 240][C+75 , 
][C@3+75 240][C+75 , CtrlImg][C@(0.0.255)+75 `::][C+75 save(), Blue);]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawImage][C+75 (][C@3+75 310][C+75 , 
][C@3+75 210][C+75 , ][C@3+75 80][C+75 , ][C@3+75 80][C+75 , CtrlImg][C@(0.0.255)+75 `::][C+75 sav
e(), Blue);]&]
[s0;l320;C+75 &]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawText][C+75 (][C@3+75 20][C+75 , 
][C@3+75 330][C+75 , ][C@3+75 `"Hello world!`"][C+75 );]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawText][C+75 (][C@3+75 120][C+75 , 
][C@3+75 330][C+75 , ][C@3+75 `"Hello world!`"][C+75 , Arial(][C@3+75 15][C+75 )][C@(0.0.255)+75 .
][C+75 Bold());]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawText][C+75 (][C@3+75 220][C+75 , 
][C@3+75 330][C+75 , ][C@3+75 `"Hello world!`"][C+75 , Roman(][C@3+75 15][C+75 )][C@(0.0.255)+75 .
][C+75 Italic(), Red);]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawText][C+75 (][C@3+75 320][C+75 , 
][C@3+75 380][C+75 , ][C@3+75 400][C+75 , ][C@3+75 `"Hello world!`"][C+75 , 
Courier(][C@3+75 15][C+75 )][C@(0.0.255)+75 .][C+75 Underline());]&]
[s0;l320; [C+75     `}]&]
[s0;l320; [C+75 `};]&]
[s0;l320;C+75 &]
[s0;l320; [C+75 GUI`_APP`_MAIN]&]
[s0;l320; [C+75 `{]&]
[s0;l320; [C+75     MyApp app;]&]
[s0;l320; [C+75     app.Title(`"Basic Drawing Operations`").Zoomable().Sizeable();]&]
[s0;l320; [C+75     app.SetRect(0, 0, 500, 420);]&]
[s0;l320; [C+75     app][C@(0.0.255)+75 .][C+75 Run();]&]
[s7;l320; `}&]
[s5;C@N+75 &]
[s0;=%% 
@@rawimage:2000&1857
(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)
&]
[s5;%% &]
[s5;%% The examples shows the full range of drawing operations in 
action.&]
[s5;%% &]
[s3;:2:%% 2. Offsets and Clipping&]
[s5;%% You can offset the drawing position and clip the drawing operations 
to specified rectangle. Offsetting and clipping in U`+`+ is stack 
based operation `- [*/ End] method restores the previous state. 
Particularly important is combined offset/clip operation [*/ Clipoff] 
that in fact creates a new Draw for subregion of current Draw 
area.&]
[s5;%% &]
[s0;l320; [C@(128.0.255)+75 #include][C+75  ][C@(0.0.255)+75 <][C+75 CtrlLib][C@(0.0.255)+75 /][C+75 C
trlLib][C@(0.0.255)+75 .][C+75 h][C@(0.0.255)+75 >]&]
[s0;l320;C+75 &]
[s0;l320; [*C@(0.0.255)+75 using][C+75  ][*C@(0.0.255)+75 namespace][C+75  
Upp;]&]
[s0;l320;C+75 &]
[s0;l320; [*C@(0.0.255)+75 struct][C+75  MyApp ][C@(0.0.255)+75 :][C+75  TopWindow 
`{]&]
[s0;l320; [C+75     ][*C@(0.0.255)+75 void][C+75  DoPainting(Draw][C@(0.0.255)+75 `&][C+75  
w) `{]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][C+75 DrawEllipse(][C@3+75 0][C+75 , 
][C@3+75 0][C+75 , ][C@3+75 100][C+75 , ][C@3+75 30][C+75 , WhiteGray(), 
][C@3+75 1][C+75 , Cyan);]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][C+75 DrawText(][C@3+75 0][C+75 , 
][C@3+75 0][C+75 , ][C@3+75 `"Hello world`"][C+75 , Roman(][C@3+75 30][C+75 )][C@(0.0.255)+75 .
][C+75 Bold());]&]
[s0;l320; [C+75     `}]&]
[s0;l320; [C+75     ]&]
[s0;l320; [C+75     ][*C@(0.0.255)+75 void][C+75  Paint(Draw][C@(0.0.255)+75 `&][C+75  
w) ][*C@(0.0.255)+75 override][C+75  `{]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][C+75 DrawRect(GetSize(), White());]&]
[s0;l320; [C+75         DoPainting(w);]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 Offset][C+75 (][C@3+75 30][C+75 , 
][C@3+75 50][C+75 );]&]
[s0;l320; [C+75         DoPainting(w);]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 End][C+75 ();]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 Offset][C+75 (][C@3+75 20][C+75 , 
][C@3+75 100][C+75 );]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 Clip][C+75 (][C@3+75 5][C+75 , 
][C@3+75 5][C+75 , ][C@3+75 40][C+75 , ][C@3+75 20][C+75 );]&]
[s0;l320; [C+75         DoPainting(w);]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 End][C+75 ();]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 End][C+75 ();]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 Clipoff][C+75 (][C@3+75 10][C+75 , 
][C@3+75 150][C+75 , ][C@3+75 60][C+75 , ][C@3+75 20][C+75 );]&]
[s0;l320; [C+75         DoPainting(w);]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 End][C+75 ();]&]
[s0;l320; [C+75     `}]&]
[s0;l320; [C+75 `};]&]
[s0;l320;C+75 &]
[s0;l320; [C+75 GUI`_APP`_MAIN]&]
[s0;l320; [C+75 `{]&]
[s0;l320; [C+75     MyApp app;]&]
[s0;l320; [C+75     app.Title(`"Offsets and Cliping`").Zoomable().Sizeable();]&]
[s0;l320; [C+75     app.SetRect(0, 0, 420, 240);]&]
[s0;l320; [C+75     app][C@(0.0.255)+75 .][C+75 Run();]&]
[s0;l320; [C+75 `}]&]
[s5;%% &]
[s0;=%% 
@@rawimage:2000&1359
(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)
&]
[s5;%% &]
[s3;:3:%% 3. Fonts and Font Metrics&]
[s5;%% [* Font] is a simple font description value type `- it contains 
an index of typeface, height of font and additional attributes 
(e.g. italic flag). Font also provides metrics information about 
the font and individual characters.&]
[s5;%% The most important information of Font is the [* GetAscent] 
value `- distance from the baseline to the top of character, 
the [* GetDescent] value `- distance from the baseline to the bottom 
of character cell (height of character cell `- [* GetHeight] `- 
is simply the sum of both values) and the individual character 
width that can be obtained by Font`'s [* operator`[`]] (where index 
is in UNICODE).&]
[s5;%% To get the list all available typefaces and respective use 
[* GetFaceCount] and [* GetFaceName] static methods of Font.&]
[s5;%% Position given in [* DrawText] specifies the top`-left corner 
of the first letter of text.&]
[s5;%% Different than default character spacing can be specified 
by the C array with integer widths of characters.&]
[s5;%% &]
[s0;l320; [C@(128.0.255)+75 #include][C+75  ][C@(0.0.255)+75 <][C+75 CtrlLib][C@(0.0.255)+75 /][C+75 C
trlLib][C@(0.0.255)+75 .][C+75 h][C@(0.0.255)+75 >]&]
[s0;l320;C+75 &]
[s0;l320; [*C@(0.0.255)+75 using][C+75  ][*C@(0.0.255)+75 namespace][C+75  
Upp;]&]
[s0;l320;C+75 &]
[s0;l320; [*C@(0.0.255)+75 struct][C+75  MyApp ][C@(0.0.255)+75 :][C+75  TopWindow 
`{]&]
[s0;l320; [C+75     DropList font`_list;]&]
[s0;l320;C+75 &]
[s0;l320; [C+75     ][*C@(0.0.255)+75 void][C+75  Paint(Draw][C@(0.0.255)+75 `&][C+75  
w) ][*C@(0.0.255)+75 override][C+75  `{]&]
[s0;l320; [C+75         ][*C@(0.0.255)+75 const][C+75  String text ][C@(0.0.255)+75 `=][C+75  
][C@3+75 `"Programming is fun`"][C+75 ;]&]
[s0;l320; [C+75         Font fnt(][C@(0.0.255)+75 `~][C+75 font`_list, 
][C@3+75 60][C+75 );]&]
[s0;l320; [C+75         ]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][C+75 DrawRect(GetSize(), White);]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][C+75 Offset(][C@3+75 30][C+75 , 
][C@3+75 50][C+75 );]&]
[s0;l320; [C+75         ][*C@(0.0.255)+75 int][C+75  x ][C@(0.0.255)+75 `=][C+75  
][C@3+75 0][C+75 ;]&]
[s0;l320; [C+75         Vector][C@(0.0.255)+75 <][*C@(0.0.255)+75 int][C@(0.0.255)+75 >][C+75  
dx;]&]
[s0;l320; [C+75         ][*C@(0.0.255)+75 for][C+75 (][*C@(0.0.255)+75 char][C+75  
letter ][C@(0.0.255)+75 :][C+75  text) `{]&]
[s0;l320; [C+75             ][*C@(0.0.255)+75 int][C+75  width ][C@(0.0.255)+75 `=][C+75  
fnt][C@(0.0.255)+75 `[][C+75 letter][C@(0.0.255)+75 `]][C+75 ;]&]
[s0;l320; [C+75             w][C@(0.0.255)+75 .][C+75 DrawRect(x, ][C@3+75 0][C+75 , 
width ][C@(0.0.255)+75 `-][C+75  ][C@3+75 1][C+75 , fnt][C@(0.0.255)+75 .][C+75 GetAscent(), 
Color(][C@3+75 255][C+75 , ][C@3+75 255][C+75 , ][C@3+75 200][C+75 ));]&]
[s0;l320; [C+75             w][C@(0.0.255)+75 .][C+75 DrawRect(x, fnt][C@(0.0.255)+75 .][C+75 G
etAscent(), width ][C@(0.0.255)+75 `-][C+75  ][C@3+75 1][C+75 , fnt][C@(0.0.255)+75 .][C+75 G
etDescent(), Color(][C@3+75 255][C+75 , ][C@3+75 200][C+75 , ][C@3+75 255][C+75 ));]&]
[s0;l320; [C+75             w][C@(0.0.255)+75 .][C+75 DrawRect(x ][C@(0.0.255)+75 `+][C+75  
width ][C@(0.0.255)+75 `-][C+75  ][C@3+75 1][C+75 , ][C@3+75 0][C+75 , ][C@3+75 1][C+75 , 
fnt][C@(0.0.255)+75 .][C+75 GetHeight(), Black());]&]
[s0;l320; [C+75             dx][C@(0.0.255)+75 .][C+75 Add(width ][C@(0.0.255)+75 `+][C+75  
][C@3+75 4][C+75 );]&]
[s0;l320; [C+75             x ][C@(0.0.255)+75 `+`=][C+75  width;]&]
[s0;l320; [C+75         `}]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][C+75 DrawRect(][C@3+75 0][C+75 , 
][C@3+75 0][C+75 , ][C@3+75 4][C+75 , ][C@3+75 4][C+75 , Black());]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][C+75 DrawText(][C@3+75 0][C+75 , 
][C@3+75 0][C+75 , text, fnt);]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][C+75 DrawText(][C@3+75 0][C+75 , 
][C@3+75 70][C+75 , text, fnt, Blue(), dx][C@(0.0.255)+75 .][C+75 GetCount(), 
dx][C@(0.0.255)+75 .][C+75 Begin());]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][C+75 End();]&]
[s0;l320; [C+75     `}]&]
[s0;l320;C+75 &]
[s0;l320; [C+75     ][*C@(0.0.255)+75 void][C+75  NewFont() `{]&]
[s0;l320; [C+75         Refresh();]&]
[s0;l320; [C+75     `}]&]
[s0;l320;C+75 &]
[s0;l320; [C+75     MyApp() `{]&]
[s0;l320; [C+75         ][*C@(0.0.255)+75 for][C+75 (][*C@(0.0.255)+75 int][C+75  
i ][C@(0.0.255)+75 `=][C+75  ][C@3+75 0][C+75 ; i ][C@(0.0.255)+75 <][C+75  
][*_C+75 Font][*_C@(0.0.255)+75 `::][*_C+75 GetFaceCount()][C+75 ; i][C@(0.0.255)+75 `+`+][C+75 )
]&]
[s0;l320; [C+75             font`_list][C@(0.0.255)+75 .][C+75 Add(i, ][*_C+75 Font][*_C@(0.0.255)+75 `:
:][*_C+75 GetFaceName(i)][C+75 );]&]
[s0;l320; [C+75         Add(font`_list][C@(0.0.255)+75 .][C+75 TopPos(][C@3+75 0][C+75 , 
MINSIZE)][C@(0.0.255)+75 .][C+75 LeftPosZ(][C@3+75 0][C+75 , ][C@3+75 200][C+75 ));]&]
[s0;l320; [C+75         font`_list ][C@(0.0.255)+75 <<`=][C+75  ][C@3+75 0][C+75 ;]&]
[s0;l320; [C+75         font`_list ][C@(0.0.255)+75 <<][C+75  ][C@(0.0.255)+75 `[`=`]][C+75  
`{ NewFont(); `};]&]
[s0;l320; [C+75     `}]&]
[s0;l320; [C+75 `};]&]
[s0;l320;C+75 &]
[s0;l320; [C+75 GUI`_APP`_MAIN]&]
[s0;l320; [C+75 `{]&]
[s0;l320; [C+75     MyApp app;]&]
[s0;l320; [C+75     app.Title(`"Fonts and Font Metrics`").Zoomable().Sizeable();]&]
[s0;l320; [C+75     app.SetRect(0, 0, 640, 300);]&]
[s0;l320; [C+75     app][C@(0.0.255)+75 .][C+75 Run();]&]
[s0;l320; [C+75 `}]&]
[s0;%% &]
[s5;%% In this lesson we used [* operator`~] to obtain current value 
stored by [* font`_list]. Alternatively, the GetData() function 
can be used for more verbosity. More information about this topic 
can be found in [*^topic`:`/`/CtrlLib`/srcdoc`/Tutorial`_en`-us`#17^ Value 
of widget] section of GUI Tutorial.&]
[s5;%% The final results of program operation is shown below:&]
[s0;%% &]
[s0;=%% 
@@rawimage:2000&1082
(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)
&]
[s5;%% &]
[s3;:4:%% 4. DrawingDraw&]
[s5;%% [* Drawing] object contains a set of drawing operations and 
in fact represents a vector image with smooth rescaling. [* DrawingDraw] 
serves as the target Draw when creating Drawing, Drawing can 
be painted to any Draw target using the [* DrawDrawing] method:&]
[s5;%% &]
[s0;l320; [C@(128.0.255)+75 #include][C+75  ][C@(0.0.255)+75 <][C+75 CtrlLib][C@(0.0.255)+75 /][C+75 C
trlLib][C@(0.0.255)+75 .][C+75 h][C@(0.0.255)+75 >]&]
[s0;l320;C+75 &]
[s0;l320; [*C@(0.0.255)+75 using][C+75  ][*C@(0.0.255)+75 namespace][C+75  
Upp;]&]
[s0;l320;C+75 &]
[s0;l320; [*C@(0.0.255)+75 struct][C+75  MyApp ][C@(0.0.255)+75 :][C+75  TopWindow 
`{]&]
[s0;l320; [C+75     Drawing drawing;]&]
[s0;l320;C+75 &]
[s0;l320; [C+75     ][*C@(0.0.255)+75 void][C+75  Paint(Draw][C@(0.0.255)+75 `&][C+75  
w) ][*C@(0.0.255)+75 override][C+75  `{]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][C+75 DrawRect(GetSize(), White());]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawDrawing][C+75 (][C@3+75 10][C+75 , 
][C@3+75 10][C+75 , ][C@3+75 50][C+75 , ][C@3+75 60][C+75 , drawing);]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawDrawing][C+75 (][C@3+75 100][C+75 , 
][C@3+75 10][C+75 , ][C@3+75 150][C+75 , ][C@3+75 100][C+75 , drawing);]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 DrawDrawing][C+75 (][C@3+75 10][C+75 , 
][C@3+75 110][C+75 , ][C@3+75 300][C+75 , ][C@3+75 300][C+75 , drawing);]&]
[s0;l320; [C+75     `}]&]
[s0;l320;C+75 &]
[s0;l320; [C+75     MyApp() `{]&]
[s0;l320; [C+75         ][*_C+75 DrawingDraw][C+75  iw(][C@3+75 200][C+75 , 
][C@3+75 200][C+75 );]&]
[s0;l320; [C+75         iw][C@(0.0.255)+75 .][C+75 DrawEllipse(][C@3+75 10][C+75 , 
][C@3+75 10][C+75 , ][C@3+75 180][C+75 , ][C@3+75 100][C+75 , Cyan());]&]
[s0;l320; [C+75         iw][C@(0.0.255)+75 .][C+75 DrawImage(][C@3+75 100][C+75 , 
][C@3+75 100][C+75 , CtrlImg][C@(0.0.255)+75 `::][C+75 exclamation());]&]
[s0;l320; [C+75         iw][C@(0.0.255)+75 .][C+75 DrawRect(][C@3+75 20][C+75 , 
][C@3+75 100][C+75 , ][C@3+75 30][C+75 , ][C@3+75 30][C+75 , Blue);]&]
[s0;l320; [C+75         ][*_C+75 drawing ][*_C@(0.0.255)+75 `=][*_C+75  iw][C+75 ;]&]
[s0;l320; [C+75     `}]&]
[s0;l320; [C+75 `};]&]
[s0;l320;C+75 &]
[s0;l320; [C+75 GUI`_APP`_MAIN]&]
[s0;l320; [C+75 `{]&]
[s0;l320; [C+75     MyApp app;]&]
[s0;l320; [C+75     app.Title(`"DrawingDraw`").Zoomable().Sizeable();]&]
[s0;l320; [C+75     app.SetRect(0, 0, 380, 360);]&]
[s0;l320; [C+75     app][C@(0.0.255)+75 .][C+75 Run();]&]
[s0;l320; [C+75 `}]&]
[s5;%% &]
[s0;=%% 
@@rawimage:1883&2000
(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)
&]
[s5;%% &]
[s3;:5:%% 5. ImageDraw&]
[s5;%% [* ImageDraw] provides a Draw target that creates an Image object. 
To define the alpha component, use Draw target returned by [* Alpha] 
method and [* GrayColor] to define the value (if you never use 
Alpha, it is considered to be 255 for the whole Image, otherwise 
it is set to 0 when Alpha is called for the first time).&]
[s5;%% &]
[s0;l320; [C@(128.0.255)+75 #include][C+75  ][C@(0.0.255)+75 <][C+75 CtrlLib][C@(0.0.255)+75 /][C+75 C
trlLib][C@(0.0.255)+75 .][C+75 h][C@(0.0.255)+75 >]&]
[s0;l320;C+75 &]
[s0;l320; [*C@(0.0.255)+75 using][C+75  ][*C@(0.0.255)+75 namespace][C+75  
Upp;]&]
[s0;l320;C+75 &]
[s0;l320; [*C@(0.0.255)+75 struct][C+75  MyApp ][C@(0.0.255)+75 :][C+75  TopWindow 
`{]&]
[s0;l320; [C+75     Image image;]&]
[s0;l320;C+75 &]
[s0;l320; [C+75     ][*C@(0.0.255)+75 void][C+75  Paint(Draw][C@(0.0.255)+75 `&][C+75  
w) ][*C@(0.0.255)+75 override][C+75  `{]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][C+75 DrawRect(GetSize(), Cyan());]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][C+75 DrawImage(][C@3+75 10][C+75 , 
][C@3+75 10][C+75 , image);]&]
[s0;l320; [C+75     `}]&]
[s0;l320;C+75 &]
[s0;l320; [C+75     MyApp() `{]&]
[s0;l320; [C+75         ][*_C+75 ImageDraw][C+75  iw(][C@3+75 400][C+75 , ][C@3+75 200][C+75 );]&]
[s0;l320; [C+75         iw][C@(0.0.255)+75 .][*_C+75 Alpha][C+75 ()][C@(0.0.255)+75 .][C+75 DrawR
ect(][C@3+75 0][C+75 , ][C@3+75 0][C+75 , ][C@3+75 400][C+75 , ][C@3+75 200][C+75 , 
GrayColor(][C@3+75 0][C+75 ));]&]
[s0;l320; [C+75         iw][C@(0.0.255)+75 .][*_C+75 Alpha][C+75 ()][C@(0.0.255)+75 .][C+75 DrawE
llipse(][C@3+75 0][C+75 , ][C@3+75 0][C+75 , ][C@3+75 400][C+75 , ][C@3+75 200][C+75 , 
GrayColor(][C@3+75 255][C+75 ));]&]
[s0;l320; [C+75         iw][C@(0.0.255)+75 .][C+75 DrawEllipse(][C@3+75 0][C+75 , 
][C@3+75 0][C+75 , ][C@3+75 400][C+75 , ][C@3+75 200][C+75 , Yellow());]&]
[s0;l320; [C+75         iw][C@(0.0.255)+75 .][C+75 DrawText(][C@3+75 100][C+75 , 
][C@3+75 50][C+75 , ][C@3+75 `"Image`"][C+75 , Arial(][C@3+75 70][C+75 )][C@(0.0.255)+75 .][C+75 B
old(), Black());]&]
[s0;l320; [C+75         ][*_C+75 image ][*_C@(0.0.255)+75 `=][*_C+75  iw][C+75 ;]&]
[s0;l320; [C+75     `}]&]
[s0;l320; [C+75 `};]&]
[s0;l320;C+75 &]
[s0;l320; [C+75 GUI`_APP`_MAIN]&]
[s0;l320; [C+75 `{]&]
[s0;l320; [C+75     MyApp app;]&]
[s0;l320; [C+75     app.Title(`"ImageDraw`").Zoomable().Sizeable();]&]
[s0;l320; [C+75     app.SetRect(0, 0, 420, 240);]&]
[s0;l320; [C+75     app][C@(0.0.255)+75 .][C+75 Run();]&]
[s0;l320; [C+75 `}]&]
[s5;%% &]
[s0;=%% 
@@rawimage:2000&1359
(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)
&]
[s5;%% &]
[s3;:6:%% 6. Printing&]
[s5;%% Printing is quite similar to painting on the screen. To acquire 
Draw target for the printer, you need to use [* PrinterJob] (CtrlLib 
feature). Each page printed should be started by calling [* StartPage] 
method and ended with [* EndPage]. Drawing coordinates when printing 
are in [*/ dots], defined as 1/600 of inch (in fact, a pixel on 
600dpi printer).&]
[s5;%% &]
[s7; [@(128.0.255) #include][@0  ][@(0.0.255) <][@0 CtrlLib][@(0.0.255) /][@0 CtrlLib][@(0.0.255) .
][@0 h][@(0.0.255) >]&]
[s0;l320;C+75 &]
[s0;l320; [*C@(0.0.255)+75 using][C+75  ][*C@(0.0.255)+75 namespace][C+75  
Upp;]&]
[s0;l320;C+75 &]
[s0;l320; [C+75 GUI`_APP`_MAIN]&]
[s0;l320; [C+75 `{]&]
[s0;l320; [C+75     ][*_C+75 PrinterJob][C+75  pd(][C@3+75 `"My printer job`"][C+75 );]&]
[s0;l320; [C+75     pd][C@(0.0.255)+75 .][C+75 CurrentPage(][C@3+75 0][C+75 );]&]
[s0;l320; [C+75     pd][C@(0.0.255)+75 .][C+75 MinMaxPage(][C@3+75 0][C+75 , 
][C@3+75 1][C+75 );]&]
[s0;l320; [C+75     ][*C@(0.0.255)+75 if][C+75 (pd][C@(0.0.255)+75 .][*_C+75 Execute][C+75 ()) 
`{]&]
[s0;l320; [C+75         Draw][C@(0.0.255)+75 `&][C+75  w ][C@(0.0.255)+75 `=][C+75  
pd][C@(0.0.255)+75 .][*_C+75 GetDraw][C+75 ();]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 StartPage][C+75 ();]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][C+75 DrawText(][C@3+75 200][C+75 , 
][C@3+75 1200][C+75 , ][C@3+75 `"Helo world!`"][C+75 , Arial(][C@3+75 600][C+75 ));]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 EndPage][C+75 ();]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 StartPage][C+75 ();]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][C+75 DrawText(][C@3+75 200][C+75 , 
][C@3+75 1200][C+75 , ][C@3+75 `"Second page`"][C+75 , Roman(][C@3+75 600][C+75 ));]&]
[s0;l320; [C+75         w][C@(0.0.255)+75 .][*_C+75 EndPage][C+75 ();]&]
[s0;l320; [C+75     `}]&]
[s0;l320; [C+75 `}]&]
[s5;C+75 &]
[s0;=%% 
@@image:2050&1612
(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)
&]
[s5;%% &]
[s3;%% Recommended tutorials:&]
[s5;%% If you want to learn more, we have several tutorials that 
you can find useful:&]
[s5;l160;i150;O0;%% [^topic`:`/`/Draw`/srcdoc`/ImgTutorial`$en`-us^ Image 
tutorial] `- here we move things related to images. We show how 
to create, use and embed icons directly in application.]]