// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// WARNING, this entire header is generated by
// utils/generate_escaped_output_table.py
// DO NOT MODIFY!

// UNICODE, INC. LICENSE AGREEMENT - DATA FILES AND SOFTWARE
//
// See Terms of Use <https://www.unicode.org/copyright.html>
// for definitions of Unicode Inc.'s Data Files and Software.
//
// NOTICE TO USER: Carefully read the following legal agreement.
// BY DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING UNICODE INC.'S
// DATA FILES ("DATA FILES"), AND/OR SOFTWARE ("SOFTWARE"),
// YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
// TERMS AND CONDITIONS OF THIS AGREEMENT.
// IF YOU DO NOT AGREE, DO NOT DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE
// THE DATA FILES OR SOFTWARE.
//
// COPYRIGHT AND PERMISSION NOTICE
//
// Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
// Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of the Unicode data files and any associated documentation
// (the "Data Files") or Unicode software and any associated documentation
// (the "Software") to deal in the Data Files or Software
// without restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, and/or sell copies of
// the Data Files or Software, and to permit persons to whom the Data Files
// or Software are furnished to do so, provided that either
// (a) this copyright and permission notice appear with all copies
// of the Data Files or Software, or
// (b) this copyright and permission notice appear in associated
// Documentation.
//
// THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
// ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT OF THIRD PARTY RIGHTS.
// IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
// NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
// DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
// DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
// TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THE DATA FILES OR SOFTWARE.
//
// Except as contained in this notice, the name of a copyright holder
// shall not be used in advertising or otherwise to promote the sale,
// use or other dealings in these Data Files or Software without prior
// written authorization of the copyright holder.

#ifndef _LIBCPP___FORMAT_ESCAPED_OUTPUT_TABLE_H
#define _LIBCPP___FORMAT_ESCAPED_OUTPUT_TABLE_H

#include <__algorithm/ranges_upper_bound.h>
#include <__config>
#include <__cstddef/ptrdiff_t.h>
#include <cstdint>

#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#  pragma GCC system_header
#endif

_LIBCPP_BEGIN_NAMESPACE_STD

#if _LIBCPP_STD_VER >= 23

namespace __escaped_output_table {
// clang-format off

/// The entries of the characters to escape in format's debug string.
///
/// Contains the entries for [format.string.escaped]/2.2.1.2.1
///   CE is a Unicode encoding and C corresponds to a UCS scalar value whose
///   Unicode property General_Category has a value in the groups Separator (Z)
///   or Other (C), as described by table 12 of UAX #44
///
/// Separator (Z) consists of General_Category
/// - Space_Separator,
/// - Line_Separator,
/// - Paragraph_Separator.
///
/// Other (C) consists of General_Category
/// - Control,
/// - Format,
/// - Surrogate,
/// - Private_Use,
/// - Unassigned.
///
/// The data is generated from
/// - https://www.unicode.org/Public/UCD/latest/ucd/extracted/DerivedGeneralCategory.txt
///
/// The table is similar to the table
///  __extended_grapheme_custer_property_boundary::__entries
/// which explains the details of these classes. The only difference is this
/// table lacks a property, thus having more bits available for the size.
///
/// The data has 2 values:
/// - bits [0, 13] The size of the range, allowing 16384 elements.
/// - bits [14, 31] The lower bound code point of the range. The upper bound of
///   the range is lower bound + size. Note the code expects code units the fit
///   into 18 bits, instead of the 21 bits needed for the full Unicode range.
_LIBCPP_HIDE_FROM_ABI inline constexpr uint32_t __entries[735] = {
    0x00000020 /* 00000000 - 00000020 [   33] */,
    0x001fc021 /* 0000007f - 000000a0 [   34] */,
    0x002b4000 /* 000000ad - 000000ad [    1] */,
    0x00de0001 /* 00000378 - 00000379 [    2] */,
    0x00e00003 /* 00000380 - 00000383 [    4] */,
    0x00e2c000 /* 0000038b - 0000038b [    1] */,
    0x00e34000 /* 0000038d - 0000038d [    1] */,
    0x00e88000 /* 000003a2 - 000003a2 [    1] */,
    0x014c0000 /* 00000530 - 00000530 [    1] */,
    0x0155c001 /* 00000557 - 00000558 [    2] */,
    0x0162c001 /* 0000058b - 0000058c [    2] */,
    0x01640000 /* 00000590 - 00000590 [    1] */,
    0x01720007 /* 000005c8 - 000005cf [    8] */,
    0x017ac003 /* 000005eb - 000005ee [    4] */,
    0x017d4010 /* 000005f5 - 00000605 [   17] */,
    0x01870000 /* 0000061c - 0000061c [    1] */,
    0x01b74000 /* 000006dd - 000006dd [    1] */,
    0x01c38001 /* 0000070e - 0000070f [    2] */,
    0x01d2c001 /* 0000074b - 0000074c [    2] */,
    0x01ec800d /* 000007b2 - 000007bf [   14] */,
    0x01fec001 /* 000007fb - 000007fc [    2] */,
    0x020b8001 /* 0000082e - 0000082f [    2] */,
    0x020fc000 /* 0000083f - 0000083f [    1] */,
    0x02170001 /* 0000085c - 0000085d [    2] */,
    0x0217c000 /* 0000085f - 0000085f [    1] */,
    0x021ac004 /* 0000086b - 0000086f [    5] */,
    0x0223c007 /* 0000088f - 00000896 [    8] */,
    0x02388000 /* 000008e2 - 000008e2 [    1] */,
    0x02610000 /* 00000984 - 00000984 [    1] */,
    0x02634001 /* 0000098d - 0000098e [    2] */,
    0x02644001 /* 00000991 - 00000992 [    2] */,
    0x026a4000 /* 000009a9 - 000009a9 [    1] */,
    0x026c4000 /* 000009b1 - 000009b1 [    1] */,
    0x026cc002 /* 000009b3 - 000009b5 [    3] */,
    0x026e8001 /* 000009ba - 000009bb [    2] */,
    0x02714001 /* 000009c5 - 000009c6 [    2] */,
    0x02724001 /* 000009c9 - 000009ca [    2] */,
    0x0273c007 /* 000009cf - 000009d6 [    8] */,
    0x02760003 /* 000009d8 - 000009db [    4] */,
    0x02778000 /* 000009de - 000009de [    1] */,
    0x02790001 /* 000009e4 - 000009e5 [    2] */,
    0x027fc001 /* 000009ff - 00000a00 [    2] */,
    0x02810000 /* 00000a04 - 00000a04 [    1] */,
    0x0282c003 /* 00000a0b - 00000a0e [    4] */,
    0x02844001 /* 00000a11 - 00000a12 [    2] */,
    0x028a4000 /* 00000a29 - 00000a29 [    1] */,
    0x028c4000 /* 00000a31 - 00000a31 [    1] */,
    0x028d0000 /* 00000a34 - 00000a34 [    1] */,
    0x028dc000 /* 00000a37 - 00000a37 [    1] */,
    0x028e8001 /* 00000a3a - 00000a3b [    2] */,
    0x028f4000 /* 00000a3d - 00000a3d [    1] */,
    0x0290c003 /* 00000a43 - 00000a46 [    4] */,
    0x02924001 /* 00000a49 - 00000a4a [    2] */,
    0x02938002 /* 00000a4e - 00000a50 [    3] */,
    0x02948006 /* 00000a52 - 00000a58 [    7] */,
    0x02974000 /* 00000a5d - 00000a5d [    1] */,
    0x0297c006 /* 00000a5f - 00000a65 [    7] */,
    0x029dc009 /* 00000a77 - 00000a80 [   10] */,
    0x02a10000 /* 00000a84 - 00000a84 [    1] */,
    0x02a38000 /* 00000a8e - 00000a8e [    1] */,
    0x02a48000 /* 00000a92 - 00000a92 [    1] */,
    0x02aa4000 /* 00000aa9 - 00000aa9 [    1] */,
    0x02ac4000 /* 00000ab1 - 00000ab1 [    1] */,
    0x02ad0000 /* 00000ab4 - 00000ab4 [    1] */,
    0x02ae8001 /* 00000aba - 00000abb [    2] */,
    0x02b18000 /* 00000ac6 - 00000ac6 [    1] */,
    0x02b28000 /* 00000aca - 00000aca [    1] */,
    0x02b38001 /* 00000ace - 00000acf [    2] */,
    0x02b4400e /* 00000ad1 - 00000adf [   15] */,
    0x02b90001 /* 00000ae4 - 00000ae5 [    2] */,
    0x02bc8006 /* 00000af2 - 00000af8 [    7] */,
    0x02c00000 /* 00000b00 - 00000b00 [    1] */,
    0x02c10000 /* 00000b04 - 00000b04 [    1] */,
    0x02c34001 /* 00000b0d - 00000b0e [    2] */,
    0x02c44001 /* 00000b11 - 00000b12 [    2] */,
    0x02ca4000 /* 00000b29 - 00000b29 [    1] */,
    0x02cc4000 /* 00000b31 - 00000b31 [    1] */,
    0x02cd0000 /* 00000b34 - 00000b34 [    1] */,
    0x02ce8001 /* 00000b3a - 00000b3b [    2] */,
    0x02d14001 /* 00000b45 - 00000b46 [    2] */,
    0x02d24001 /* 00000b49 - 00000b4a [    2] */,
    0x02d38006 /* 00000b4e - 00000b54 [    7] */,
    0x02d60003 /* 00000b58 - 00000b5b [    4] */,
    0x02d78000 /* 00000b5e - 00000b5e [    1] */,
    0x02d90001 /* 00000b64 - 00000b65 [    2] */,
    0x02de0009 /* 00000b78 - 00000b81 [   10] */,
    0x02e10000 /* 00000b84 - 00000b84 [    1] */,
    0x02e2c002 /* 00000b8b - 00000b8d [    3] */,
    0x02e44000 /* 00000b91 - 00000b91 [    1] */,
    0x02e58002 /* 00000b96 - 00000b98 [    3] */,
    0x02e6c000 /* 00000b9b - 00000b9b [    1] */,
    0x02e74000 /* 00000b9d - 00000b9d [    1] */,
    0x02e80002 /* 00000ba0 - 00000ba2 [    3] */,
    0x02e94002 /* 00000ba5 - 00000ba7 [    3] */,
    0x02eac002 /* 00000bab - 00000bad [    3] */,
    0x02ee8003 /* 00000bba - 00000bbd [    4] */,
    0x02f0c002 /* 00000bc3 - 00000bc5 [    3] */,
    0x02f24000 /* 00000bc9 - 00000bc9 [    1] */,
    0x02f38001 /* 00000bce - 00000bcf [    2] */,
    0x02f44005 /* 00000bd1 - 00000bd6 [    6] */,
    0x02f6000d /* 00000bd8 - 00000be5 [   14] */,
    0x02fec004 /* 00000bfb - 00000bff [    5] */,
    0x03034000 /* 00000c0d - 00000c0d [    1] */,
    0x03044000 /* 00000c11 - 00000c11 [    1] */,
    0x030a4000 /* 00000c29 - 00000c29 [    1] */,
    0x030e8001 /* 00000c3a - 00000c3b [    2] */,
    0x03114000 /* 00000c45 - 00000c45 [    1] */,
    0x03124000 /* 00000c49 - 00000c49 [    1] */,
    0x03138006 /* 00000c4e - 00000c54 [    7] */,
    0x0315c000 /* 00000c57 - 00000c57 [    1] */,
    0x0316c001 /* 00000c5b - 00000c5c [    2] */,
    0x03178001 /* 00000c5e - 00000c5f [    2] */,
    0x03190001 /* 00000c64 - 00000c65 [    2] */,
    0x031c0006 /* 00000c70 - 00000c76 [    7] */,
    0x03234000 /* 00000c8d - 00000c8d [    1] */,
    0x03244000 /* 00000c91 - 00000c91 [    1] */,
    0x032a4000 /* 00000ca9 - 00000ca9 [    1] */,
    0x032d0000 /* 00000cb4 - 00000cb4 [    1] */,
    0x032e8001 /* 00000cba - 00000cbb [    2] */,
    0x03314000 /* 00000cc5 - 00000cc5 [    1] */,
    0x03324000 /* 00000cc9 - 00000cc9 [    1] */,
    0x03338006 /* 00000cce - 00000cd4 [    7] */,
    0x0335c005 /* 00000cd7 - 00000cdc [    6] */,
    0x0337c000 /* 00000cdf - 00000cdf [    1] */,
    0x03390001 /* 00000ce4 - 00000ce5 [    2] */,
    0x033c0000 /* 00000cf0 - 00000cf0 [    1] */,
    0x033d000b /* 00000cf4 - 00000cff [   12] */,
    0x03434000 /* 00000d0d - 00000d0d [    1] */,
    0x03444000 /* 00000d11 - 00000d11 [    1] */,
    0x03514000 /* 00000d45 - 00000d45 [    1] */,
    0x03524000 /* 00000d49 - 00000d49 [    1] */,
    0x03540003 /* 00000d50 - 00000d53 [    4] */,
    0x03590001 /* 00000d64 - 00000d65 [    2] */,
    0x03600000 /* 00000d80 - 00000d80 [    1] */,
    0x03610000 /* 00000d84 - 00000d84 [    1] */,
    0x0365c002 /* 00000d97 - 00000d99 [    3] */,
    0x036c8000 /* 00000db2 - 00000db2 [    1] */,
    0x036f0000 /* 00000dbc - 00000dbc [    1] */,
    0x036f8001 /* 00000dbe - 00000dbf [    2] */,
    0x0371c002 /* 00000dc7 - 00000dc9 [    3] */,
    0x0372c003 /* 00000dcb - 00000dce [    4] */,
    0x03754000 /* 00000dd5 - 00000dd5 [    1] */,
    0x0375c000 /* 00000dd7 - 00000dd7 [    1] */,
    0x03780005 /* 00000de0 - 00000de5 [    6] */,
    0x037c0001 /* 00000df0 - 00000df1 [    2] */,
    0x037d400b /* 00000df5 - 00000e00 [   12] */,
    0x038ec003 /* 00000e3b - 00000e3e [    4] */,
    0x03970024 /* 00000e5c - 00000e80 [   37] */,
    0x03a0c000 /* 00000e83 - 00000e83 [    1] */,
    0x03a14000 /* 00000e85 - 00000e85 [    1] */,
    0x03a2c000 /* 00000e8b - 00000e8b [    1] */,
    0x03a90000 /* 00000ea4 - 00000ea4 [    1] */,
    0x03a98000 /* 00000ea6 - 00000ea6 [    1] */,
    0x03af8001 /* 00000ebe - 00000ebf [    2] */,
    0x03b14000 /* 00000ec5 - 00000ec5 [    1] */,
    0x03b1c000 /* 00000ec7 - 00000ec7 [    1] */,
    0x03b3c000 /* 00000ecf - 00000ecf [    1] */,
    0x03b68001 /* 00000eda - 00000edb [    2] */,
    0x03b8001f /* 00000ee0 - 00000eff [   32] */,
    0x03d20000 /* 00000f48 - 00000f48 [    1] */,
    0x03db4003 /* 00000f6d - 00000f70 [    4] */,
    0x03e60000 /* 00000f98 - 00000f98 [    1] */,
    0x03ef4000 /* 00000fbd - 00000fbd [    1] */,
    0x03f34000 /* 00000fcd - 00000fcd [    1] */,
    0x03f6c024 /* 00000fdb - 00000fff [   37] */,
    0x04318000 /* 000010c6 - 000010c6 [    1] */,
    0x04320004 /* 000010c8 - 000010cc [    5] */,
    0x04338001 /* 000010ce - 000010cf [    2] */,
    0x04924000 /* 00001249 - 00001249 [    1] */,
    0x04938001 /* 0000124e - 0000124f [    2] */,
    0x0495c000 /* 00001257 - 00001257 [    1] */,
    0x04964000 /* 00001259 - 00001259 [    1] */,
    0x04978001 /* 0000125e - 0000125f [    2] */,
    0x04a24000 /* 00001289 - 00001289 [    1] */,
    0x04a38001 /* 0000128e - 0000128f [    2] */,
    0x04ac4000 /* 000012b1 - 000012b1 [    1] */,
    0x04ad8001 /* 000012b6 - 000012b7 [    2] */,
    0x04afc000 /* 000012bf - 000012bf [    1] */,
    0x04b04000 /* 000012c1 - 000012c1 [    1] */,
    0x04b18001 /* 000012c6 - 000012c7 [    2] */,
    0x04b5c000 /* 000012d7 - 000012d7 [    1] */,
    0x04c44000 /* 00001311 - 00001311 [    1] */,
    0x04c58001 /* 00001316 - 00001317 [    2] */,
    0x04d6c001 /* 0000135b - 0000135c [    2] */,
    0x04df4002 /* 0000137d - 0000137f [    3] */,
    0x04e68005 /* 0000139a - 0000139f [    6] */,
    0x04fd8001 /* 000013f6 - 000013f7 [    2] */,
    0x04ff8001 /* 000013fe - 000013ff [    2] */,
    0x05a00000 /* 00001680 - 00001680 [    1] */,
    0x05a74002 /* 0000169d - 0000169f [    3] */,
    0x05be4006 /* 000016f9 - 000016ff [    7] */,
    0x05c58008 /* 00001716 - 0000171e [    9] */,
    0x05cdc008 /* 00001737 - 0000173f [    9] */,
    0x05d5000b /* 00001754 - 0000175f [   12] */,
    0x05db4000 /* 0000176d - 0000176d [    1] */,
    0x05dc4000 /* 00001771 - 00001771 [    1] */,
    0x05dd000b /* 00001774 - 0000177f [   12] */,
    0x05f78001 /* 000017de - 000017df [    2] */,
    0x05fa8005 /* 000017ea - 000017ef [    6] */,
    0x05fe8005 /* 000017fa - 000017ff [    6] */,
    0x06038000 /* 0000180e - 0000180e [    1] */,
    0x06068005 /* 0000181a - 0000181f [    6] */,
    0x061e4006 /* 00001879 - 0000187f [    7] */,
    0x062ac004 /* 000018ab - 000018af [    5] */,
    0x063d8009 /* 000018f6 - 000018ff [   10] */,
    0x0647c000 /* 0000191f - 0000191f [    1] */,
    0x064b0003 /* 0000192c - 0000192f [    4] */,
    0x064f0003 /* 0000193c - 0000193f [    4] */,
    0x06504002 /* 00001941 - 00001943 [    3] */,
    0x065b8001 /* 0000196e - 0000196f [    2] */,
    0x065d400a /* 00001975 - 0000197f [   11] */,
    0x066b0003 /* 000019ac - 000019af [    4] */,
    0x06728005 /* 000019ca - 000019cf [    6] */,
    0x0676c002 /* 000019db - 000019dd [    3] */,
    0x06870001 /* 00001a1c - 00001a1d [    2] */,
    0x0697c000 /* 00001a5f - 00001a5f [    1] */,
    0x069f4001 /* 00001a7d - 00001a7e [    2] */,
    0x06a28005 /* 00001a8a - 00001a8f [    6] */,
    0x06a68005 /* 00001a9a - 00001a9f [    6] */,
    0x06ab8001 /* 00001aae - 00001aaf [    2] */,
    0x06b3c030 /* 00001acf - 00001aff [   49] */,
    0x06d34000 /* 00001b4d - 00001b4d [    1] */,
    0x06fd0007 /* 00001bf4 - 00001bfb [    8] */,
    0x070e0002 /* 00001c38 - 00001c3a [    3] */,
    0x07128002 /* 00001c4a - 00001c4c [    3] */,
    0x0722c004 /* 00001c8b - 00001c8f [    5] */,
    0x072ec001 /* 00001cbb - 00001cbc [    2] */,
    0x07320007 /* 00001cc8 - 00001ccf [    8] */,
    0x073ec004 /* 00001cfb - 00001cff [    5] */,
    0x07c58001 /* 00001f16 - 00001f17 [    2] */,
    0x07c78001 /* 00001f1e - 00001f1f [    2] */,
    0x07d18001 /* 00001f46 - 00001f47 [    2] */,
    0x07d38001 /* 00001f4e - 00001f4f [    2] */,
    0x07d60000 /* 00001f58 - 00001f58 [    1] */,
    0x07d68000 /* 00001f5a - 00001f5a [    1] */,
    0x07d70000 /* 00001f5c - 00001f5c [    1] */,
    0x07d78000 /* 00001f5e - 00001f5e [    1] */,
    0x07df8001 /* 00001f7e - 00001f7f [    2] */,
    0x07ed4000 /* 00001fb5 - 00001fb5 [    1] */,
    0x07f14000 /* 00001fc5 - 00001fc5 [    1] */,
    0x07f50001 /* 00001fd4 - 00001fd5 [    2] */,
    0x07f70000 /* 00001fdc - 00001fdc [    1] */,
    0x07fc0001 /* 00001ff0 - 00001ff1 [    2] */,
    0x07fd4000 /* 00001ff5 - 00001ff5 [    1] */,
    0x07ffc010 /* 00001fff - 0000200f [   17] */,
    0x080a0007 /* 00002028 - 0000202f [    8] */,
    0x0817c010 /* 0000205f - 0000206f [   17] */,
    0x081c8001 /* 00002072 - 00002073 [    2] */,
    0x0823c000 /* 0000208f - 0000208f [    1] */,
    0x08274002 /* 0000209d - 0000209f [    3] */,
    0x0830400e /* 000020c1 - 000020cf [   15] */,
    0x083c400e /* 000020f1 - 000020ff [   15] */,
    0x08630003 /* 0000218c - 0000218f [    4] */,
    0x090a8015 /* 0000242a - 0000243f [   22] */,
    0x0912c014 /* 0000244b - 0000245f [   21] */,
    0x0add0001 /* 00002b74 - 00002b75 [    2] */,
    0x0ae58000 /* 00002b96 - 00002b96 [    1] */,
    0x0b3d0004 /* 00002cf4 - 00002cf8 [    5] */,
    0x0b498000 /* 00002d26 - 00002d26 [    1] */,
    0x0b4a0004 /* 00002d28 - 00002d2c [    5] */,
    0x0b4b8001 /* 00002d2e - 00002d2f [    2] */,
    0x0b5a0006 /* 00002d68 - 00002d6e [    7] */,
    0x0b5c400d /* 00002d71 - 00002d7e [   14] */,
    0x0b65c008 /* 00002d97 - 00002d9f [    9] */,
    0x0b69c000 /* 00002da7 - 00002da7 [    1] */,
    0x0b6bc000 /* 00002daf - 00002daf [    1] */,
    0x0b6dc000 /* 00002db7 - 00002db7 [    1] */,
    0x0b6fc000 /* 00002dbf - 00002dbf [    1] */,
    0x0b71c000 /* 00002dc7 - 00002dc7 [    1] */,
    0x0b73c000 /* 00002dcf - 00002dcf [    1] */,
    0x0b75c000 /* 00002dd7 - 00002dd7 [    1] */,
    0x0b77c000 /* 00002ddf - 00002ddf [    1] */,
    0x0b978021 /* 00002e5e - 00002e7f [   34] */,
    0x0ba68000 /* 00002e9a - 00002e9a [    1] */,
    0x0bbd000b /* 00002ef4 - 00002eff [   12] */,
    0x0bf58019 /* 00002fd6 - 00002fef [   26] */,
    0x0c000000 /* 00003000 - 00003000 [    1] */,
    0x0c100000 /* 00003040 - 00003040 [    1] */,
    0x0c25c001 /* 00003097 - 00003098 [    2] */,
    0x0c400004 /* 00003100 - 00003104 [    5] */,
    0x0c4c0000 /* 00003130 - 00003130 [    1] */,
    0x0c63c000 /* 0000318f - 0000318f [    1] */,
    0x0c798008 /* 000031e6 - 000031ee [    9] */,
    0x0c87c000 /* 0000321f - 0000321f [    1] */,
    0x29234002 /* 0000a48d - 0000a48f [    3] */,
    0x2931c008 /* 0000a4c7 - 0000a4cf [    9] */,
    0x298b0013 /* 0000a62c - 0000a63f [   20] */,
    0x29be0007 /* 0000a6f8 - 0000a6ff [    8] */,
    0x29f38001 /* 0000a7ce - 0000a7cf [    2] */,
    0x29f48000 /* 0000a7d2 - 0000a7d2 [    1] */,
    0x29f50000 /* 0000a7d4 - 0000a7d4 [    1] */,
    0x29f74014 /* 0000a7dd - 0000a7f1 [   21] */,
    0x2a0b4002 /* 0000a82d - 0000a82f [    3] */,
    0x2a0e8005 /* 0000a83a - 0000a83f [    6] */,
    0x2a1e0007 /* 0000a878 - 0000a87f [    8] */,
    0x2a318007 /* 0000a8c6 - 0000a8cd [    8] */,
    0x2a368005 /* 0000a8da - 0000a8df [    6] */,
    0x2a55000a /* 0000a954 - 0000a95e [   11] */,
    0x2a5f4002 /* 0000a97d - 0000a97f [    3] */,
    0x2a738000 /* 0000a9ce - 0000a9ce [    1] */,
    0x2a768003 /* 0000a9da - 0000a9dd [    4] */,
    0x2a7fc000 /* 0000a9ff - 0000a9ff [    1] */,
    0x2a8dc008 /* 0000aa37 - 0000aa3f [    9] */,
    0x2a938001 /* 0000aa4e - 0000aa4f [    2] */,
    0x2a968001 /* 0000aa5a - 0000aa5b [    2] */,
    0x2ab0c017 /* 0000aac3 - 0000aada [   24] */,
    0x2abdc009 /* 0000aaf7 - 0000ab00 [   10] */,
    0x2ac1c001 /* 0000ab07 - 0000ab08 [    2] */,
    0x2ac3c001 /* 0000ab0f - 0000ab10 [    2] */,
    0x2ac5c008 /* 0000ab17 - 0000ab1f [    9] */,
    0x2ac9c000 /* 0000ab27 - 0000ab27 [    1] */,
    0x2acbc000 /* 0000ab2f - 0000ab2f [    1] */,
    0x2adb0003 /* 0000ab6c - 0000ab6f [    4] */,
    0x2afb8001 /* 0000abee - 0000abef [    2] */,
    0x2afe8005 /* 0000abfa - 0000abff [    6] */,
    0x35e9000b /* 0000d7a4 - 0000d7af [   12] */,
    0x35f1c003 /* 0000d7c7 - 0000d7ca [    4] */,
    0x35ff2103 /* 0000d7fc - 0000f8ff [ 8452] */,
    0x3e9b8001 /* 0000fa6e - 0000fa6f [    2] */,
    0x3eb68025 /* 0000fada - 0000faff [   38] */,
    0x3ec1c00b /* 0000fb07 - 0000fb12 [   12] */,
    0x3ec60004 /* 0000fb18 - 0000fb1c [    5] */,
    0x3ecdc000 /* 0000fb37 - 0000fb37 [    1] */,
    0x3ecf4000 /* 0000fb3d - 0000fb3d [    1] */,
    0x3ecfc000 /* 0000fb3f - 0000fb3f [    1] */,
    0x3ed08000 /* 0000fb42 - 0000fb42 [    1] */,
    0x3ed14000 /* 0000fb45 - 0000fb45 [    1] */,
    0x3ef0c00f /* 0000fbc3 - 0000fbd2 [   16] */,
    0x3f640001 /* 0000fd90 - 0000fd91 [    2] */,
    0x3f720006 /* 0000fdc8 - 0000fdce [    7] */,
    0x3f74001f /* 0000fdd0 - 0000fdef [   32] */,
    0x3f868005 /* 0000fe1a - 0000fe1f [    6] */,
    0x3f94c000 /* 0000fe53 - 0000fe53 [    1] */,
    0x3f99c000 /* 0000fe67 - 0000fe67 [    1] */,
    0x3f9b0003 /* 0000fe6c - 0000fe6f [    4] */,
    0x3f9d4000 /* 0000fe75 - 0000fe75 [    1] */,
    0x3fbf4003 /* 0000fefd - 0000ff00 [    4] */,
    0x3fefc002 /* 0000ffbf - 0000ffc1 [    3] */,
    0x3ff20001 /* 0000ffc8 - 0000ffc9 [    2] */,
    0x3ff40001 /* 0000ffd0 - 0000ffd1 [    2] */,
    0x3ff60001 /* 0000ffd8 - 0000ffd9 [    2] */,
    0x3ff74002 /* 0000ffdd - 0000ffdf [    3] */,
    0x3ff9c000 /* 0000ffe7 - 0000ffe7 [    1] */,
    0x3ffbc00c /* 0000ffef - 0000fffb [   13] */,
    0x3fff8001 /* 0000fffe - 0000ffff [    2] */,
    0x40030000 /* 0001000c - 0001000c [    1] */,
    0x4009c000 /* 00010027 - 00010027 [    1] */,
    0x400ec000 /* 0001003b - 0001003b [    1] */,
    0x400f8000 /* 0001003e - 0001003e [    1] */,
    0x40138001 /* 0001004e - 0001004f [    2] */,
    0x40178021 /* 0001005e - 0001007f [   34] */,
    0x403ec004 /* 000100fb - 000100ff [    5] */,
    0x4040c003 /* 00010103 - 00010106 [    4] */,
    0x404d0002 /* 00010134 - 00010136 [    3] */,
    0x4063c000 /* 0001018f - 0001018f [    1] */,
    0x40674002 /* 0001019d - 0001019f [    3] */,
    0x4068402e /* 000101a1 - 000101cf [   47] */,
    0x407f8081 /* 000101fe - 0001027f [  130] */,
    0x40a74002 /* 0001029d - 0001029f [    3] */,
    0x40b4400e /* 000102d1 - 000102df [   15] */,
    0x40bf0003 /* 000102fc - 000102ff [    4] */,
    0x40c90008 /* 00010324 - 0001032c [    9] */,
    0x40d2c004 /* 0001034b - 0001034f [    5] */,
    0x40dec004 /* 0001037b - 0001037f [    5] */,
    0x40e78000 /* 0001039e - 0001039e [    1] */,
    0x40f10003 /* 000103c4 - 000103c7 [    4] */,
    0x40f58029 /* 000103d6 - 000103ff [   42] */,
    0x41278001 /* 0001049e - 0001049f [    2] */,
    0x412a8005 /* 000104aa - 000104af [    6] */,
    0x41350003 /* 000104d4 - 000104d7 [    4] */,
    0x413f0003 /* 000104fc - 000104ff [    4] */,
    0x414a0007 /* 00010528 - 0001052f [    8] */,
    0x4159000a /* 00010564 - 0001056e [   11] */,
    0x415ec000 /* 0001057b - 0001057b [    1] */,
    0x4162c000 /* 0001058b - 0001058b [    1] */,
    0x4164c000 /* 00010593 - 00010593 [    1] */,
    0x41658000 /* 00010596 - 00010596 [    1] */,
    0x41688000 /* 000105a2 - 000105a2 [    1] */,
    0x416c8000 /* 000105b2 - 000105b2 [    1] */,
    0x416e8000 /* 000105ba - 000105ba [    1] */,
    0x416f4002 /* 000105bd - 000105bf [    3] */,
    0x417d000b /* 000105f4 - 000105ff [   12] */,
    0x41cdc008 /* 00010737 - 0001073f [    9] */,
    0x41d58009 /* 00010756 - 0001075f [   10] */,
    0x41da0017 /* 00010768 - 0001077f [   24] */,
    0x41e18000 /* 00010786 - 00010786 [    1] */,
    0x41ec4000 /* 000107b1 - 000107b1 [    1] */,
    0x41eec044 /* 000107bb - 000107ff [   69] */,
    0x42018001 /* 00010806 - 00010807 [    2] */,
    0x42024000 /* 00010809 - 00010809 [    1] */,
    0x420d8000 /* 00010836 - 00010836 [    1] */,
    0x420e4002 /* 00010839 - 0001083b [    3] */,
    0x420f4001 /* 0001083d - 0001083e [    2] */,
    0x42158000 /* 00010856 - 00010856 [    1] */,
    0x4227c007 /* 0001089f - 000108a6 [    8] */,
    0x422c002f /* 000108b0 - 000108df [   48] */,
    0x423cc000 /* 000108f3 - 000108f3 [    1] */,
    0x423d8004 /* 000108f6 - 000108fa [    5] */,
    0x42470002 /* 0001091c - 0001091e [    3] */,
    0x424e8004 /* 0001093a - 0001093e [    5] */,
    0x4250003f /* 00010940 - 0001097f [   64] */,
    0x426e0003 /* 000109b8 - 000109bb [    4] */,
    0x42740001 /* 000109d0 - 000109d1 [    2] */,
    0x42810000 /* 00010a04 - 00010a04 [    1] */,
    0x4281c004 /* 00010a07 - 00010a0b [    5] */,
    0x42850000 /* 00010a14 - 00010a14 [    1] */,
    0x42860000 /* 00010a18 - 00010a18 [    1] */,
    0x428d8001 /* 00010a36 - 00010a37 [    2] */,
    0x428ec003 /* 00010a3b - 00010a3e [    4] */,
    0x42924006 /* 00010a49 - 00010a4f [    7] */,
    0x42964006 /* 00010a59 - 00010a5f [    7] */,
    0x42a8001f /* 00010aa0 - 00010abf [   32] */,
    0x42b9c003 /* 00010ae7 - 00010aea [    4] */,
    0x42bdc008 /* 00010af7 - 00010aff [    9] */,
    0x42cd8002 /* 00010b36 - 00010b38 [    3] */,
    0x42d58001 /* 00010b56 - 00010b57 [    2] */,
    0x42dcc004 /* 00010b73 - 00010b77 [    5] */,
    0x42e48006 /* 00010b92 - 00010b98 [    7] */,
    0x42e7400b /* 00010b9d - 00010ba8 [   12] */,
    0x42ec004f /* 00010bb0 - 00010bff [   80] */,
    0x43124036 /* 00010c49 - 00010c7f [   55] */,
    0x432cc00c /* 00010cb3 - 00010cbf [   13] */,
    0x433cc006 /* 00010cf3 - 00010cf9 [    7] */,
    0x434a0007 /* 00010d28 - 00010d2f [    8] */,
    0x434e8005 /* 00010d3a - 00010d3f [    6] */,
    0x43598002 /* 00010d66 - 00010d68 [    3] */,
    0x43618007 /* 00010d86 - 00010d8d [    8] */,
    0x436400cf /* 00010d90 - 00010e5f [  208] */,
    0x439fc000 /* 00010e7f - 00010e7f [    1] */,
    0x43aa8000 /* 00010eaa - 00010eaa [    1] */,
    0x43ab8001 /* 00010eae - 00010eaf [    2] */,
    0x43ac800f /* 00010eb2 - 00010ec1 [   16] */,
    0x43b14036 /* 00010ec5 - 00010efb [   55] */,
    0x43ca0007 /* 00010f28 - 00010f2f [    8] */,
    0x43d68015 /* 00010f5a - 00010f6f [   22] */,
    0x43e28025 /* 00010f8a - 00010faf [   38] */,
    0x43f30013 /* 00010fcc - 00010fdf [   20] */,
    0x43fdc008 /* 00010ff7 - 00010fff [    9] */,
    0x44138003 /* 0001104e - 00011051 [    4] */,
    0x441d8008 /* 00011076 - 0001107e [    9] */,
    0x442f4000 /* 000110bd - 000110bd [    1] */,
    0x4430c00c /* 000110c3 - 000110cf [   13] */,
    0x443a4006 /* 000110e9 - 000110ef [    7] */,
    0x443e8005 /* 000110fa - 000110ff [    6] */,
    0x444d4000 /* 00011135 - 00011135 [    1] */,
    0x44520007 /* 00011148 - 0001114f [    8] */,
    0x445dc008 /* 00011177 - 0001117f [    9] */,
    0x44780000 /* 000111e0 - 000111e0 [    1] */,
    0x447d400a /* 000111f5 - 000111ff [   11] */,
    0x44848000 /* 00011212 - 00011212 [    1] */,
    0x4490803d /* 00011242 - 0001127f [   62] */,
    0x44a1c000 /* 00011287 - 00011287 [    1] */,
    0x44a24000 /* 00011289 - 00011289 [    1] */,
    0x44a38000 /* 0001128e - 0001128e [    1] */,
    0x44a78000 /* 0001129e - 0001129e [    1] */,
    0x44aa8005 /* 000112aa - 000112af [    6] */,
    0x44bac004 /* 000112eb - 000112ef [    5] */,
    0x44be8005 /* 000112fa - 000112ff [    6] */,
    0x44c10000 /* 00011304 - 00011304 [    1] */,
    0x44c34001 /* 0001130d - 0001130e [    2] */,
    0x44c44001 /* 00011311 - 00011312 [    2] */,
    0x44ca4000 /* 00011329 - 00011329 [    1] */,
    0x44cc4000 /* 00011331 - 00011331 [    1] */,
    0x44cd0000 /* 00011334 - 00011334 [    1] */,
    0x44ce8000 /* 0001133a - 0001133a [    1] */,
    0x44d14001 /* 00011345 - 00011346 [    2] */,
    0x44d24001 /* 00011349 - 0001134a [    2] */,
    0x44d38001 /* 0001134e - 0001134f [    2] */,
    0x44d44005 /* 00011351 - 00011356 [    6] */,
    0x44d60004 /* 00011358 - 0001135c [    5] */,
    0x44d90001 /* 00011364 - 00011365 [    2] */,
    0x44db4002 /* 0001136d - 0001136f [    3] */,
    0x44dd400a /* 00011375 - 0001137f [   11] */,
    0x44e28000 /* 0001138a - 0001138a [    1] */,
    0x44e30001 /* 0001138c - 0001138d [    2] */,
    0x44e3c000 /* 0001138f - 0001138f [    1] */,
    0x44ed8000 /* 000113b6 - 000113b6 [    1] */,
    0x44f04000 /* 000113c1 - 000113c1 [    1] */,
    0x44f0c001 /* 000113c3 - 000113c4 [    2] */,
    0x44f18000 /* 000113c6 - 000113c6 [    1] */,
    0x44f2c000 /* 000113cb - 000113cb [    1] */,
    0x44f58000 /* 000113d6 - 000113d6 [    1] */,
    0x44f64007 /* 000113d9 - 000113e0 [    8] */,
    0x44f8c01c /* 000113e3 - 000113ff [   29] */,
    0x45170000 /* 0001145c - 0001145c [    1] */,
    0x4518801d /* 00011462 - 0001147f [   30] */,
    0x45320007 /* 000114c8 - 000114cf [    8] */,
    0x453680a5 /* 000114da - 0001157f [  166] */,
    0x456d8001 /* 000115b6 - 000115b7 [    2] */,
    0x45778021 /* 000115de - 000115ff [   34] */,
    0x4591400a /* 00011645 - 0001164f [   11] */,
    0x45968005 /* 0001165a - 0001165f [    6] */,
    0x459b4012 /* 0001166d - 0001167f [   19] */,
    0x45ae8005 /* 000116ba - 000116bf [    6] */,
    0x45b28005 /* 000116ca - 000116cf [    6] */,
    0x45b9001b /* 000116e4 - 000116ff [   28] */,
    0x45c6c001 /* 0001171b - 0001171c [    2] */,
    0x45cb0003 /* 0001172c - 0001172f [    4] */,
    0x45d1c0b8 /* 00011747 - 000117ff [  185] */,
    0x460f0063 /* 0001183c - 0001189f [  100] */,
    0x463cc00b /* 000118f3 - 000118fe [   12] */,
    0x4641c001 /* 00011907 - 00011908 [    2] */,
    0x46428001 /* 0001190a - 0001190b [    2] */,
    0x46450000 /* 00011914 - 00011914 [    1] */,
    0x4645c000 /* 00011917 - 00011917 [    1] */,
    0x464d8000 /* 00011936 - 00011936 [    1] */,
    0x464e4001 /* 00011939 - 0001193a [    2] */,
    0x4651c008 /* 00011947 - 0001194f [    9] */,
    0x46568045 /* 0001195a - 0001199f [   70] */,
    0x466a0001 /* 000119a8 - 000119a9 [    2] */,
    0x46760001 /* 000119d8 - 000119d9 [    2] */,
    0x4679401a /* 000119e5 - 000119ff [   27] */,
    0x46920007 /* 00011a48 - 00011a4f [    8] */,
    0x46a8c00c /* 00011aa3 - 00011aaf [   13] */,
    0x46be4006 /* 00011af9 - 00011aff [    7] */,
    0x46c280b5 /* 00011b0a - 00011bbf [  182] */,
    0x46f8800d /* 00011be2 - 00011bef [   14] */,
    0x46fe8005 /* 00011bfa - 00011bff [    6] */,
    0x47024000 /* 00011c09 - 00011c09 [    1] */,
    0x470dc000 /* 00011c37 - 00011c37 [    1] */,
    0x47118009 /* 00011c46 - 00011c4f [   10] */,
    0x471b4002 /* 00011c6d - 00011c6f [    3] */,
    0x47240001 /* 00011c90 - 00011c91 [    2] */,
    0x472a0000 /* 00011ca8 - 00011ca8 [    1] */,
    0x472dc048 /* 00011cb7 - 00011cff [   73] */,
    0x4741c000 /* 00011d07 - 00011d07 [    1] */,
    0x47428000 /* 00011d0a - 00011d0a [    1] */,
    0x474dc002 /* 00011d37 - 00011d39 [    3] */,
    0x474ec000 /* 00011d3b - 00011d3b [    1] */,
    0x474f8000 /* 00011d3e - 00011d3e [    1] */,
    0x47520007 /* 00011d48 - 00011d4f [    8] */,
    0x47568005 /* 00011d5a - 00011d5f [    6] */,
    0x47598000 /* 00011d66 - 00011d66 [    1] */,
    0x475a4000 /* 00011d69 - 00011d69 [    1] */,
    0x4763c000 /* 00011d8f - 00011d8f [    1] */,
    0x47648000 /* 00011d92 - 00011d92 [    1] */,
    0x47664006 /* 00011d99 - 00011d9f [    7] */,
    0x476a8135 /* 00011daa - 00011edf [  310] */,
    0x47be4006 /* 00011ef9 - 00011eff [    7] */,
    0x47c44000 /* 00011f11 - 00011f11 [    1] */,
    0x47cec002 /* 00011f3b - 00011f3d [    3] */,
    0x47d6c054 /* 00011f5b - 00011faf [   85] */,
    0x47ec400e /* 00011fb1 - 00011fbf [   15] */,
    0x47fc800c /* 00011ff2 - 00011ffe [   13] */,
    0x48e68065 /* 0001239a - 000123ff [  102] */,
    0x491bc000 /* 0001246f - 0001246f [    1] */,
    0x491d400a /* 00012475 - 0001247f [   11] */,
    0x49510a4b /* 00012544 - 00012f8f [ 2636] */,
    0x4bfcc00c /* 00012ff3 - 00012fff [   13] */,
    0x4d0c000f /* 00013430 - 0001343f [   16] */,
    0x4d158009 /* 00013456 - 0001345f [   10] */,
    0x50fec004 /* 000143fb - 000143ff [    5] */,
    0x5191dab8 /* 00014647 - 000160ff [ 6841] */,
    0x584e86c5 /* 0001613a - 000167ff [ 1734] */,
    0x5a8e4006 /* 00016a39 - 00016a3f [    7] */,
    0x5a97c000 /* 00016a5f - 00016a5f [    1] */,
    0x5a9a8003 /* 00016a6a - 00016a6d [    4] */,
    0x5aafc000 /* 00016abf - 00016abf [    1] */,
    0x5ab28005 /* 00016aca - 00016acf [    6] */,
    0x5abb8001 /* 00016aee - 00016aef [    2] */,
    0x5abd8009 /* 00016af6 - 00016aff [   10] */,
    0x5ad18009 /* 00016b46 - 00016b4f [   10] */,
    0x5ad68000 /* 00016b5a - 00016b5a [    1] */,
    0x5ad88000 /* 00016b62 - 00016b62 [    1] */,
    0x5ade0004 /* 00016b78 - 00016b7c [    5] */,
    0x5ae401af /* 00016b90 - 00016d3f [  432] */,
    0x5b5e80c5 /* 00016d7a - 00016e3f [  198] */,
    0x5ba6c064 /* 00016e9b - 00016eff [  101] */,
    0x5bd2c003 /* 00016f4b - 00016f4e [    4] */,
    0x5be20006 /* 00016f88 - 00016f8e [    7] */,
    0x5be8003f /* 00016fa0 - 00016fdf [   64] */,
    0x5bf9400a /* 00016fe5 - 00016fef [   11] */,
    0x5bfc800d /* 00016ff2 - 00016fff [   14] */,
    0x61fe0007 /* 000187f8 - 000187ff [    8] */,
    0x63358028 /* 00018cd6 - 00018cfe [   41] */,
    0x634262e6 /* 00018d09 - 0001afef [ 8935] */,
    0x6bfd0000 /* 0001aff4 - 0001aff4 [    1] */,
    0x6bff0000 /* 0001affc - 0001affc [    1] */,
    0x6bffc000 /* 0001afff - 0001afff [    1] */,
    0x6c48c00e /* 0001b123 - 0001b131 [   15] */,
    0x6c4cc01c /* 0001b133 - 0001b14f [   29] */,
    0x6c54c001 /* 0001b153 - 0001b154 [    2] */,
    0x6c55800d /* 0001b156 - 0001b163 [   14] */,
    0x6c5a0007 /* 0001b168 - 0001b16f [    8] */,
    0x6cbf0903 /* 0001b2fc - 0001bbff [ 2308] */,
    0x6f1ac004 /* 0001bc6b - 0001bc6f [    5] */,
    0x6f1f4002 /* 0001bc7d - 0001bc7f [    3] */,
    0x6f224006 /* 0001bc89 - 0001bc8f [    7] */,
    0x6f268001 /* 0001bc9a - 0001bc9b [    2] */,
    0x6f280f5f /* 0001bca0 - 0001cbff [ 3936] */,
    0x733e8005 /* 0001ccfa - 0001ccff [    6] */,
    0x73ad004b /* 0001ceb4 - 0001ceff [   76] */,
    0x73cb8001 /* 0001cf2e - 0001cf2f [    2] */,
    0x73d1c008 /* 0001cf47 - 0001cf4f [    9] */,
    0x73f1003b /* 0001cfc4 - 0001cfff [   60] */,
    0x743d8009 /* 0001d0f6 - 0001d0ff [   10] */,
    0x7449c001 /* 0001d127 - 0001d128 [    2] */,
    0x745cc007 /* 0001d173 - 0001d17a [    8] */,
    0x747ac014 /* 0001d1eb - 0001d1ff [   21] */,
    0x74918079 /* 0001d246 - 0001d2bf [  122] */,
    0x74b5000b /* 0001d2d4 - 0001d2df [   12] */,
    0x74bd000b /* 0001d2f4 - 0001d2ff [   12] */,
    0x74d5c008 /* 0001d357 - 0001d35f [    9] */,
    0x74de4086 /* 0001d379 - 0001d3ff [  135] */,
    0x75154000 /* 0001d455 - 0001d455 [    1] */,
    0x75274000 /* 0001d49d - 0001d49d [    1] */,
    0x75280001 /* 0001d4a0 - 0001d4a1 [    2] */,
    0x7528c001 /* 0001d4a3 - 0001d4a4 [    2] */,
    0x7529c001 /* 0001d4a7 - 0001d4a8 [    2] */,
    0x752b4000 /* 0001d4ad - 0001d4ad [    1] */,
    0x752e8000 /* 0001d4ba - 0001d4ba [    1] */,
    0x752f0000 /* 0001d4bc - 0001d4bc [    1] */,
    0x75310000 /* 0001d4c4 - 0001d4c4 [    1] */,
    0x75418000 /* 0001d506 - 0001d506 [    1] */,
    0x7542c001 /* 0001d50b - 0001d50c [    2] */,
    0x75454000 /* 0001d515 - 0001d515 [    1] */,
    0x75474000 /* 0001d51d - 0001d51d [    1] */,
    0x754e8000 /* 0001d53a - 0001d53a [    1] */,
    0x754fc000 /* 0001d53f - 0001d53f [    1] */,
    0x75514000 /* 0001d545 - 0001d545 [    1] */,
    0x7551c002 /* 0001d547 - 0001d549 [    3] */,
    0x75544000 /* 0001d551 - 0001d551 [    1] */,
    0x75a98001 /* 0001d6a6 - 0001d6a7 [    2] */,
    0x75f30001 /* 0001d7cc - 0001d7cd [    2] */,
    0x76a3000e /* 0001da8c - 0001da9a [   15] */,
    0x76a80000 /* 0001daa0 - 0001daa0 [    1] */,
    0x76ac044f /* 0001dab0 - 0001deff [ 1104] */,
    0x77c7c005 /* 0001df1f - 0001df24 [    6] */,
    0x77cac0d4 /* 0001df2b - 0001dfff [  213] */,
    0x7801c000 /* 0001e007 - 0001e007 [    1] */,
    0x78064001 /* 0001e019 - 0001e01a [    2] */,
    0x78088000 /* 0001e022 - 0001e022 [    1] */,
    0x78094000 /* 0001e025 - 0001e025 [    1] */,
    0x780ac004 /* 0001e02b - 0001e02f [    5] */,
    0x781b8020 /* 0001e06e - 0001e08e [   33] */,
    0x7824006f /* 0001e090 - 0001e0ff [  112] */,
    0x784b4002 /* 0001e12d - 0001e12f [    3] */,
    0x784f8001 /* 0001e13e - 0001e13f [    2] */,
    0x78528003 /* 0001e14a - 0001e14d [    4] */,
    0x7854013f /* 0001e150 - 0001e28f [  320] */,
    0x78abc010 /* 0001e2af - 0001e2bf [   17] */,
    0x78be8004 /* 0001e2fa - 0001e2fe [    5] */,
    0x78c001cf /* 0001e300 - 0001e4cf [  464] */,
    0x793e80d5 /* 0001e4fa - 0001e5cf [  214] */,
    0x797ec003 /* 0001e5fb - 0001e5fe [    4] */,
    0x798001df /* 0001e600 - 0001e7df [  480] */,
    0x79f9c000 /* 0001e7e7 - 0001e7e7 [    1] */,
    0x79fb0000 /* 0001e7ec - 0001e7ec [    1] */,
    0x79fbc000 /* 0001e7ef - 0001e7ef [    1] */,
    0x79ffc000 /* 0001e7ff - 0001e7ff [    1] */,
    0x7a314001 /* 0001e8c5 - 0001e8c6 [    2] */,
    0x7a35c028 /* 0001e8d7 - 0001e8ff [   41] */,
    0x7a530003 /* 0001e94c - 0001e94f [    4] */,
    0x7a568003 /* 0001e95a - 0001e95d [    4] */,
    0x7a580310 /* 0001e960 - 0001ec70 [  785] */,
    0x7b2d404b /* 0001ecb5 - 0001ed00 [   76] */,
    0x7b4f80c1 /* 0001ed3e - 0001edff [  194] */,
    0x7b810000 /* 0001ee04 - 0001ee04 [    1] */,
    0x7b880000 /* 0001ee20 - 0001ee20 [    1] */,
    0x7b88c000 /* 0001ee23 - 0001ee23 [    1] */,
    0x7b894001 /* 0001ee25 - 0001ee26 [    2] */,
    0x7b8a0000 /* 0001ee28 - 0001ee28 [    1] */,
    0x7b8cc000 /* 0001ee33 - 0001ee33 [    1] */,
    0x7b8e0000 /* 0001ee38 - 0001ee38 [    1] */,
    0x7b8e8000 /* 0001ee3a - 0001ee3a [    1] */,
    0x7b8f0005 /* 0001ee3c - 0001ee41 [    6] */,
    0x7b90c003 /* 0001ee43 - 0001ee46 [    4] */,
    0x7b920000 /* 0001ee48 - 0001ee48 [    1] */,
    0x7b928000 /* 0001ee4a - 0001ee4a [    1] */,
    0x7b930000 /* 0001ee4c - 0001ee4c [    1] */,
    0x7b940000 /* 0001ee50 - 0001ee50 [    1] */,
    0x7b94c000 /* 0001ee53 - 0001ee53 [    1] */,
    0x7b954001 /* 0001ee55 - 0001ee56 [    2] */,
    0x7b960000 /* 0001ee58 - 0001ee58 [    1] */,
    0x7b968000 /* 0001ee5a - 0001ee5a [    1] */,
    0x7b970000 /* 0001ee5c - 0001ee5c [    1] */,
    0x7b978000 /* 0001ee5e - 0001ee5e [    1] */,
    0x7b980000 /* 0001ee60 - 0001ee60 [    1] */,
    0x7b98c000 /* 0001ee63 - 0001ee63 [    1] */,
    0x7b994001 /* 0001ee65 - 0001ee66 [    2] */,
    0x7b9ac000 /* 0001ee6b - 0001ee6b [    1] */,
    0x7b9cc000 /* 0001ee73 - 0001ee73 [    1] */,
    0x7b9e0000 /* 0001ee78 - 0001ee78 [    1] */,
    0x7b9f4000 /* 0001ee7d - 0001ee7d [    1] */,
    0x7b9fc000 /* 0001ee7f - 0001ee7f [    1] */,
    0x7ba28000 /* 0001ee8a - 0001ee8a [    1] */,
    0x7ba70004 /* 0001ee9c - 0001eea0 [    5] */,
    0x7ba90000 /* 0001eea4 - 0001eea4 [    1] */,
    0x7baa8000 /* 0001eeaa - 0001eeaa [    1] */,
    0x7baf0033 /* 0001eebc - 0001eeef [   52] */,
    0x7bbc810d /* 0001eef2 - 0001efff [  270] */,
    0x7c0b0003 /* 0001f02c - 0001f02f [    4] */,
    0x7c25000b /* 0001f094 - 0001f09f [   12] */,
    0x7c2bc001 /* 0001f0af - 0001f0b0 [    2] */,
    0x7c300000 /* 0001f0c0 - 0001f0c0 [    1] */,
    0x7c340000 /* 0001f0d0 - 0001f0d0 [    1] */,
    0x7c3d8009 /* 0001f0f6 - 0001f0ff [   10] */,
    0x7c6b8037 /* 0001f1ae - 0001f1e5 [   56] */,
    0x7c80c00c /* 0001f203 - 0001f20f [   13] */,
    0x7c8f0003 /* 0001f23c - 0001f23f [    4] */,
    0x7c924006 /* 0001f249 - 0001f24f [    7] */,
    0x7c94800d /* 0001f252 - 0001f25f [   14] */,
    0x7c998099 /* 0001f266 - 0001f2ff [  154] */,
    0x7db60003 /* 0001f6d8 - 0001f6db [    4] */,
    0x7dbb4002 /* 0001f6ed - 0001f6ef [    3] */,
    0x7dbf4002 /* 0001f6fd - 0001f6ff [    3] */,
    0x7dddc003 /* 0001f777 - 0001f77a [    4] */,
    0x7df68005 /* 0001f7da - 0001f7df [    6] */,
    0x7dfb0003 /* 0001f7ec - 0001f7ef [    4] */,
    0x7dfc400e /* 0001f7f1 - 0001f7ff [   15] */,
    0x7e030003 /* 0001f80c - 0001f80f [    4] */,
    0x7e120007 /* 0001f848 - 0001f84f [    8] */,
    0x7e168005 /* 0001f85a - 0001f85f [    6] */,
    0x7e220007 /* 0001f888 - 0001f88f [    8] */,
    0x7e2b8001 /* 0001f8ae - 0001f8af [    2] */,
    0x7e2f0003 /* 0001f8bc - 0001f8bf [    4] */,
    0x7e30803d /* 0001f8c2 - 0001f8ff [   62] */,
    0x7e95000b /* 0001fa54 - 0001fa5f [   12] */,
    0x7e9b8001 /* 0001fa6e - 0001fa6f [    2] */,
    0x7e9f4002 /* 0001fa7d - 0001fa7f [    3] */,
    0x7ea28004 /* 0001fa8a - 0001fa8e [    5] */,
    0x7eb1c006 /* 0001fac7 - 0001facd [    7] */,
    0x7eb74001 /* 0001fadd - 0001fade [    2] */,
    0x7eba8005 /* 0001faea - 0001faef [    6] */,
    0x7ebe4006 /* 0001faf9 - 0001faff [    7] */,
    0x7ee4c000 /* 0001fb93 - 0001fb93 [    1] */,
    0x7efe8405 /* 0001fbfa - 0001ffff [ 1030] */,
    0xa9b8001f /* 0002a6e0 - 0002a6ff [   32] */,
    0xadce8005 /* 0002b73a - 0002b73f [    6] */,
    0xae078001 /* 0002b81e - 0002b81f [    2] */,
    0xb3a8800d /* 0002cea2 - 0002ceaf [   14] */,
    0xbaf8400e /* 0002ebe1 - 0002ebef [   15] */,
    0xbb9789a1 /* 0002ee5e - 0002f7ff [ 2466] */,
    0xbe8785e1 /* 0002fa1e - 0002ffff [ 1506] */,
    0xc4d2c004 /* 0003134b - 0003134f [    5] */};

/// Returns whether the code unit needs to be escaped.
///
/// At the end of the valid Unicode code points space a lot of code points are
/// either reserved or a noncharacter. Adding all these entries to the
/// lookup table would greatly increase the size of the table. Instead these
/// entries are manually processed. In this large area of reserved code points,
/// there is a small area of extended graphemes that should not be escaped
/// unconditionally. This is also manually coded. See the generation script for
/// more details.

///
/// \\pre The code point is a valid Unicode code point.
[[nodiscard]] _LIBCPP_HIDE_FROM_ABI constexpr bool __needs_escape(const char32_t __code_point) noexcept {

  // The entries in the gap at the end.
  if(__code_point >= 0x000e0100 && __code_point <= 0x000e01ef)
     return false;

  // The entries at the end.
  if (__code_point >= 0x000323b0)
    return true;

  ptrdiff_t __i = std::ranges::upper_bound(__entries, (__code_point << 14) | 0x3fffu) - __entries;
  if (__i == 0)
    return false;

  --__i;
  uint32_t __upper_bound = (__entries[__i] >> 14) + (__entries[__i] & 0x3fffu);
  return __code_point <= __upper_bound;
}

// clang-format on
} // namespace __escaped_output_table

#endif // _LIBCPP_STD_VER >= 23

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___FORMAT_ESCAPED_OUTPUT_TABLE_H
