topic "Tutorial";
[2 $$0,0#00000000000000000000000000000000:Default]
[l288;i704;a17;O9;~~~.992;2 $$1,0#10431211400427159095818037425705:param]
[a83;*R6 $$2,5#31310162474203024125188417583966:caption]
[b83;*2 $$3,5#07864147445237544204411237157677:title]
[b167;a42;C2 $$4,6#40027414424643823182269349404212:item]
[b42;a42;2 $$5,5#45413000475342174754091244180557:text]
[l288;a17;2 $$6,6#27521748481378242620020725143825:desc]
[l321;t246;C@5;1 $$7,7#20902679421464641399138805415013:code]
[b2503;2 $$8,0#65142375456100023862071332075487:separator]
[*@(0.0.255)2 $$9,0#83433469410354161042741608181528:base]
[t4167;C2 $$10,0#37138531426314131251341829483380:class]
[l288;a17;*1 $$11,11#70004532496200323422659154056402:requirement]
[i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam]
[b167;C2 $$13,13#92430459443460461911108080531343:item1]
[i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2]
[*@2$(0.128.128)2 $$15,15#34511555403152284025741354420178:NewsDate]
[l321;*C$7;2 $$16,16#03451589433145915344929335295360:result]
[l321;b83;a83;*C$7;2 $$17,17#07531550463529505371228428965313:result`-line]
[l160;t4167;*C+117 $$18,5#88603949442205825958800053222425:package`-title]
[{_}%EN-US 
[s0; [* 1. Basics]&]
[s0;* &]
[s0; -|To use a grid control in your application add the GridCtrl 
package to your project and then just add grid as any other control 
in layout editor (Complex`-> GridCtrl) or manually put some code 
somewhere in your app constructor eg:&]
[s0; &]
[s7; #include <CtrlLib/CtrlLib.h>&]
[s7; #include <GridCtrl/GridCtrl.h>&]
[s7; &]
[s7; struct App : TopWindow&]
[s7; `{&]
[s7; -|typedef App CLASSNAME;&]
[s7; &]
[s7; -|GridCtrl grid;&]
[s7; &]
[s7; -|App()&]
[s7; -|`{&]
[s7; -|-|Add(grid.SizePos());&]
[s7; -|`}&]
[s7; `};&]
[s7; &]
[s7; GUI`_APP`_MAIN&]
[s7; `{&]
[s7; -|App().Run();&]
[s7; `}&]
[s0; &]
[s0; Now we have grid control spanned onto the main window. However 
grid without columns is useless. To add some columns write:&]
[s0; &]
[s7; grid.AddColumn(`"Name`");&]
[s7; grid.AddColumn(`"Age`");&]
[s7; &]
[s7; &]
[s0; Let`'s add some data into it:&]
[s0; &]
[s7; grid.Add(`"Ann`", 21)&]
[s7;     .Add(`"Jack`", 34)&]
[s7;     .Add(`"David`", 15);&]
[s0; &]
[s0; As you can see the first row of grid containing column names 
is painted differently. It is often called header (as in the 
array control), but here I call it fixed row (because there can 
me more than one fixed row). Next `"lines`" are just ordinary 
rows.&]
[s0; &]
[s0; Once you`'ve added data into the grid you can change it:&]
[s0; &]
[s7; grid.Set(0, 0, `"Daniel`");&]
[s0; &]
[s0; First argument of Set() is a row number, second is a column 
and the last `- a new value to be set. Remember that the row 
0 is the first row after fixed rows. To change the value of fixed 
item use SetFixed:&]
[s0; &]
[s7; grid.SetFixed(0, 1, `"Age of person`");&]
[s9; &]
[s0; If number of row/column in Set is greater than the number of 
total rows/columns `- grid is automatically `"stretched`" to 
fit the new item[` 1].&]
[s0; &]
[s0; If you want to change value of current row you can omit the 
first argument of Set():&]
[s0; &]
[s7; grid.Set(0, `"Daniel 1`");&]
[s7; &]
[s0; In both cases you can use the short form:&]
[s0; &]
[s7; grid(0, 0) `= `"Daniel`";&]
[s7; grid(0) `= `"Daniel 1`";&]
[s0; &]
[s0; However there are two differences:&]
[s0;i150;O0; short form always updates internal data. That means 
if there is an edit control active above your item it`'s value 
won`'t change `- only underlaying value will change.&]
[s0;i150;O0; short form never refreshes grid.&]
[s0; &]
[s0; Short form are mainly dedicated to extremely fast updates and 
to use in callbacks (see next chapter)&]
[s0; &]
[s0; Now let`'s do opposite. Let`'s get the data from grid. To do 
it simply use Get() method:&]
[s0; &]
[s7; Value v0 `= grid.Get(0, 0); // get value from row 0 and column 
0&]
[s7; Value v1 `= grid.Get(0);    // get value from cursor row and 
column 0&]
[s7; Value v0 `= grid(0, 0);     // short form of case 1&]
[s7; Value v1 `= grid(0);        // short form of case 2&]
[s0; &]
[s0; Get always returns a copy of internal data (short form returns 
reference to the internal value).&]
[s0; &]
[s0; 1) Not fully implemented in current version, only resizing of 
rows. Column resizing will be available in full 1.0 version.&]
[s0; &]
[s0; [* 2. Callbacks]&]
[s0;* &]
[s0; The easiest method to add some interaction to the grid control 
is to use callbacks. There are many. The most basic are:&]
[s0; &]
[s0; [* WhenLeftClick] `- called when left mouse button is pushed.&]
[s0; [* WhenLeftDouble] `- called when left mouse button is pushed 
twice.&]
[s0; [* WhenRowChange] `- called when cursor in grid changes its position.&]
[s0; [* WhenEnter] `- called when enter key is pressed.&]
[s0; &]
[s0; Add to the code:&]
[s0; &]
[s7; void ShowInfo()&]
[s7; `{&]
[s7; -|PromptOK(Format(`"%s is %d years old`", grid(0), grid(1)));&]
[s7; `}&]
[s7; &]
[s7; grid.WhenLeftDouble `= THISBACK(ShowInfo);&]
[s0; &]
[s0; After running the application and double clicking at first row 
you should see:&]
[s0; &]
[s0;= 
@@image:1449&1034
πÜМ̮ǻǽްힷߺڭ
݈Ȝɪ闄넁ݳԥƟϗʁ
؜᫿ߜɝڄ؄״ڀģܴ˾
Ձ孡ז֖ى߅Ʉ䪍ԛ
ۮȵ枬˯ߊēϭ⫷
ѯ˷܋믌˓ˬֿʗ˦ːŲٜ
͓㚔Ӳڳð̞ن܊傱䙳𓖙
׮ɬƏ뗯Ǻ陒ҝͱߵǹ˹ضنʞ
힘񎨦𓖹ۏٛ䇦嗅ߊ͓Ȝķ߼
̫𰬇Îׯ˘嗅؎à܋à䤙ː
ÚĠˀͺ٩òٹӈ뵀
ʳ؃ωӈ얐儗̼޻ҫ
녰ư堁Ӻħ潐ډϘʎиᨑ萟ˏ
ͮ٬¢杭òɹᔜӅ޷두ع֚˗צ
؄繙ݐعʲ̮ݚˆ䠁
ج썙ٍ먆ѬӍҬǏ©èͥ؏òށ
ᔜŲᬶ٬٨߂պʌ؃ۗ򀺪
ߎع䊡꓃٣͐ӈ
뀋刄ʬ򳪯ׯɬֈ
Ϳ맖;ξځòئ엡˽̮ǯݽȔ򖷙
֒¸נپ˟ݾξљɲƾˬ
ç봶ܖ噂ˬ¼æ򊯅ҽσҿ枿ض
Ќؚ˖̪ҿӿĩ򆂀ɷ쩞٦óˊòށьݏ
ҋΆ˼ҋꝹˬ⢐̲ޑ
ᙥҸ퇞垷ᙥ퇞Ր垷򰛰ٍ獌ئӏβˋ
Ἄئ橆̉ʡᐙӂɬֈޜئ饠
ʷ̓ڊ̵Ĝ˞ƧŚ񅍨࿰˔󧥈٧
㨶βʖԧąӡ٬Ӎ좴Ʈ͊Ɍܻ܍ލ
ܛ锲гמᐯڤ¦Ψ慄ФӢαԀլ
ƅԨҴ܉آ⑥©΢穓򾒘鶦ȕږųǗΨ
ũó삾шʅ贕Ꭾ霒àȇԍݺ̍
񦚗؍԰ʍȋԤГӦʘ㇍ŕ̈
ѽђĸ셠򝤶ڑטϸⅪ͆ɔ˵ڰҵȬ
Ȩٗ슓Ņ빠ȊڽòۏӖӉϹ؈
Ʊȸᙌʴ񂗘ڶʇփý爯䦲쨹䇼堇
͚ϴֱًݭ݈ППՅ㳏
ɇ㳨ՂڼΥٝǓ߈ڸ콚ܾǰ
Ɂӑǝ߈孁ЃȠǗӸгȢȬ項ŗɫ㐸
陬ߘӐҔ؀ɹ͖Íըմּ㋏Ȓ֟Ε
֛ŋśٖӥ灻׉ª٦燵ЧƸݪ
쟣䆞贵ܟԹ熞Ϭߙ
ɾկ䄗̋ڼӆܔŋЩ܏؀憙
Ա©ѹǄ֣ýۀ񴗸҉Ԇֵ𫨖
˔֗ѴΨɫͫﺜۓ斐У
֞ʥ＜Д놧֜۩ˠ𳟽֊ߝă򇞘
ӿ램쁉¹ۼûⴱіٺĘٍ
斅ښʚӰѮ񲁍̼􊩃ĕ֊˺
Ҽء̕ױ퉎̣ՈށЀܸڲԶݐף
ɫʯ՜ˤﹴ㡨Ӣïԣƞ»ސ
Ŏݷәſꄧ̳邤Ŭ駬Ы
幵Ʃ⾎ەÆɋΦ炲ӯвđژƓи̕
梇ъ󍋽ݰ޶ۃȅԅ򱳺ʑ
օܱ鿃ǻ䧎޹϶٧߉횟
ﮢªÑݻӇɓΘ͹Հ̗۹զИܕ͛׀
Ӛ֣°̦Ո󸤠ȼƁɊީԨ
ݨИô̬Πɔεܽŉݴܭ軜֬ȱ
͏ǁʑӁ賕Ξ̹朌ܳ
ŒŲߙڱօ֟͌︶
݁ϷۭЉݖ֮Ͽܤأ³
Ɖ颪ʨɵԫϚ󪶑қƀ⅗߂ƦԈƉѢӗۤ
Ȯ쀏ÑСߺΪԐґՑվٕܛǭ檽
ͮ͆Ƿ巾ۀ츒󈽟̄
ӳۅص˴Ȗŝ፫㲣ԜĩȮ傲
Ѭ͑ҵݦ㘤Ɨ糂̏싳釐졤गޣ˒
܍Π폸Ù͠廗噵ʡ˚
߮񋋿۔뙷ٹ𳒽㰹؆鿑ܝȝ
ЏڟƮ͸ۣ杭禺駬Ƌæ쬋˄
⼘尶ʣ̔ӊȼƷέ詴߼
ݟک׼۩肳у쌋տȴʐ爳ñ·Ɣޟݕ
֙ԯ㉸ٿ靖ߦϫݒڪƦʙ
ϯ΃ľªϣ˦쀥؀뷏́ʍ㠅ΰ
ʹӊւڊұԅ̢ؓ꺞ʈԸԆݨט
ˆ͞ə̋ŝ넹ÕᴠۨʦݥꢔӮ땘߻տƵ
Ԧ˲ɯ؎хү㎧ߣٳʻ
ĤǒϜ́߹ʔӊظէƦΛˑʯ
ɀυ۳̊܂Єخ¡Խט򜈕´갔
Ö䔙Ơơʊ޸ݬᫌ܅ἦؔ੠Ȇϻ݅ԉ¢೛
ӯȭ噵去ԾѨƩ큡
焝ȣܙܡ꒫΍Ꚕڮ啦דּÞڈ
ƘԴќҮ̈棑ȣ貝˲ܙަٺە´ś
´քحҳ͉ԩ̵Φĸ˅ٿǞ؈
ೋӮ̇ʐƅؚ̍ɥ󭀼Ņ敳
˿湱ޯƠͳ͢ラ՘Ǭ܃
ͦ氘ĕս鮗ē繼̦͚ۜƽűϸ쒺
摙ʺˏƠΊǲݠ΀ن̸ۜنβ
΂øІˆΆ䙂ᠠːنøȲ䙫ːΆن
궐ȲƆÃũܻŖͭ￺
Çͼ矁쳃Ζ֏ݐ漚ь
̹ͳ晝Ǽ˖̲׻Ǯ޽ӧⰿ߽
ܟ۠­ƆχƧ̡ݩ֠Њ瞭̮
ӹծߤٶŖ횞茟̿ɦ֪ўի箑橑ܕͽ
ҷ욛呷Ǉݾ΂쉬ٳܟօ
ƞ͒É奛ᤠݷݖ
𛟎șޣɴ料؟ţ炈˺޲Σ
çأһ߃Ͽ͙
ߕȽͬ⑙ڠ댎ߛ叉ï޻ϑǄ
ˌ瞡գ̤Ջ
Ԫхː̒雠ė镑˷½ʲխŏ
ΓۿŽÐ鹾ȕձܜ
嶳ƍû짬硊׊ŀ뉙Ƶͺڨ
ȍȷۑЬѰ泻ˣʿꖲɌ޺˦
ț׽ۛ״׎ܞ䗇ݚ﫿ݐȶ
نЎЌ𞂻ǧՋǶ˼㚆ƘݘҦ˰İΏ
ز߭򭮿렬ړйٳ抔ɭٴŻßð闥ֶ۝ܙ
ɕ雥Ǚڭ隔霤ψ֖
ʴʥ讋ʭش˚ꮷܻʮצʲՋ
Ʒ̲꘠ޞ̱ᐶ洶Ӊߣϖіؚ։̖
֖ݻ򾠇׊ρġܜˬ޼襹߱Ьӑ˪ד
ʶ뺯ϖƛ劸ޅ芕е끬˳倨ݍ۶堡
읠ߧߗըԍʻ嬟߸뽂
ښ˔֞ڳٴ䙻ʹ󌃵ͣࡰߣ߿
ߋڡٔ휡՟罯ｱٵ֯춅
ǥܹȖȲţ̆⶙ՇķϾܷ߭Ӗ
ߕǈɹٱֽ彯ܾꮄ鬃Ĥț
ޚܫډʇˈޥܝ
𴪺ǂӹë緜Ȯŷ禌󕃤Ճ
٭뼮Õٶ͖Ɔ݆϶ϩϷՅ쉿
ӭኹȻ򌏾яㅔבֿ㣟
厫ۛ旄Ý׶ƔȿϾϴߨثݥ˗ݾڐΆʁ
ƮȴϿ̟ȿӵë߀焀Ɓ
ˍ߆꼂Ҋ͙քׄ
ߚҩɱĳɬ䗖򓑵߰ԍל쁬ˎՍ
ݗĈˎȲճٱֆًï헡晀犫޶
ìː١øȲːΆ٩ȲÖќ䙲ː焃نø
ȲՖːΆنȲ󊤖Ԟá˨ܽôǰ̘㚑
㶧菋Ўĉˮٹ팠܌»òĞفȲҺ
ֲԣę括Ȳǲ洂ҼˎȲط耘å∡檭ή
Ш栍̘鮶¿ት垩ԦƐÁȲ
ױ责ヽ㖱滠էѬƲ
病˥癛攜Ҙ֘栍ߧŚ׳
栍ԄϪ⦩ڪΎȲѡمýشƀɲʠ
Ȳǲؔ֡ȲƆۮŐɔ㬆Ė˺
ꓰш౔뤎Ȳۄʷֳ̡֓Ȳ܏Ź媏
½Öќ䙲ː焃نøȲՖːΆنȲŖ䙲Ҍ
Ï󝀬Á㙌䙎ΞȲ쁬Á֖ԡ
ҠÁ၀
&]
[s0; Now some funky stuff:&]
[s0; &]
[s7; void RandomColor()&]
[s7; `{&]
[s7; -|grid.GetRow().Bg(Color(rand() % 255, rand() % 255, rand() % 
255));&]
[s7; `}&]
[s7; &]
[s7; grid.WhenRowChange `= THISBACK(RandomColor);&]
[s0;* &]
[s0; Try to change cursor position (using cursor keys or mouse). 
After each position change the background color of the previous 
active row is changed.&]
[s0;* &]
[s0; [* 3. Editing, indexes and integration with databases]&]
[s0;* &]
[s0; Displaying static data is very useful, but in most cases some 
of it must be changed. One way is to show another window (eg 
as a reaction on double click) and put entered data from it into 
the grid. Second way is to edit data directly in grid. GridCtrl 
support two edit modes:&]
[s0; &]
[s0; 1. Row editing.&]
[s0; -|In this mode all edit controls binded to the columns are shown. 
You can move from one edit to another by pressing tab key (or 
enter if special switch is on). &]
[s0; &]
[s0; 2. Cell editing&]
[s0; -|In this mode only one edit control is displayed. Tab moves 
the cursor to the next edit control (if available).&]
[s0;* &]
[s0; Binding edits with columns is very easy. Let`'s make our example 
to allow edit name and age. First we need to declare edit controls:&]
[s7; -|&]
[s7; EditString name;&]
[s7; EditInt age;&]
[s7; &]
[s0; Then we simply call Edit method for each column:&]
[s0; &]
[s7; grid.AddColumn(`"Name`").Edit(name);&]
[s7; grid.AddColumn(`"Age`").Edit(age);&]
[s7; &]
[s0; Now you can press Enter or click double LMB to start editing. 
By default Tab skips from one cell to another (with binded edit). 
If it is the last editing cell pressing Tab adds a new row. There 
are several ways to change editing behaviour e.g:&]
[s0; &]
[s7; grid.TabAddsRow(bool b) -|enables/disables adding new row after 
pressing tab key &]
[s7; grid.TabChangesRow(bool b)-|enables/disables changing row after 
pressing tab key &]
[s7; grid.EnterLikeTab(bool b)-|enables/disables emulation of tab 
by enter key&]
[s7; grid.OneClickEdit(bool b)-|enables/disables immediate editing 
after LMB click&]
[s0; &]
[s0; [* 4. Bulit`-in toolbar, popup menu]&]
[s0;* &]
[s0; [* 5. Properties]&]
[s0;* &]
[s0; [* 6. Others]]]