TITLE("Some more stuff about Callbacks")
TOPIC_TEXT(
"[2 $$0,0#00000000000000000000000000000000:Default][l288;i1120;a17;O9;~~~.1408;2 "
"$$1,0#10431211400427159095818037425705:param][a83;*R6 $$2,5#31310162474203024125188417583966:caption][b83;*4 "
"$$3,5#07864147445237544204411237157677:title][i288;O9;C2 $$4,6#40027414424643823182269349404212:item][b42;a42;2 "
"$$5,5#45413000475342174754091244180557:text][l288;b17;a17;2 $$6,6#27521748481378242620020725143825:desc][l321;t246;C@5;1 "
"$$7,7#20902679421464641399138805415013:code][b2503; $$8,0#65142375456100023862071332075487:separator][*@(0.0.255)2 "
"$$9,0#83433469410354161042741608181528:base][t4167;C $$10,0#37138531426314131251341829483380:class][l288;a17;*1 "
"$$11,11#70004532496200323422659154056402:requirement][i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam][b167;C2 "
"$$13,13#92430459443460461911108080531343:item1][i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2][*@2$(0.128.128) "
"$$15,15#34511555403152284025741354420178:NewsDate][l321;*C$7;2 $$16,16#03451589433145915344929335295360:result][l321;b83;a83;*C$7;2 "
"$$17,17#07531550463529505371228428965313:result`-line][l160;t4167;*C+117 $$18,5#88603949442205825958800053222425:package`-title][ "
"$$19,0#53580023442335529039900623488521:gap][t4167;C2 $$20,20#70211524482531209251820423858195:class`-nested][b50;2 "
"$$21,21#03324558446220344731010354752573:Par][{_}%EN-US [s2; Some more stuff about "
"Callbacks&][s5; In previous example `\"reference`\\Callback`\" we saw basics of U`+`+ "
"callbacks. This article will explore some more features of callback mechanism.&][s5; "
"&][s5; First we will take a look on [^topic`:`/`/Core`/src`/Callbacks`$en`-us`#`:`:CallbackArgTarget`:`:CallbackArgTarget`(`)^ "
"CallbackArgTarget] template class. This is helper template class which is useful "
"in situation when set of callbacks define some output value. Example is pop`-up menu "
"that provides selection of one character `- in that case, [* CallbackArgTarget] can "
"be used instead of dedicated method to obtain result of user selection. Note that")
TOPIC_TEXT(
" type of output value must be able to be assigned [* Null]. &][s5; Lets look the "
"code of `\"reference`\\CallbackArgTarget`\" example:&][s7; &][s7; #include <CtrlLib/CtrlLib.h>&][s7; "
"&][s7; GUI`_APP`_MAIN&][s7; `{&][s7;* [* -|]CallbackArgTarget<int> result;&][s7; "
"-|MenuBar menu;&][s7; -|for(int i `= 0; i < 10; i`+`+)&][s7; -|-|menu.Add(AsString(i), "
"result`[i`]);&][s7; -|menu.Execute();&][s7; -|if(IsNull(result))&][s7; -|-|PromptOK(`\"Menu "
"was cancelled`\");&][s7; -|else&][s7; -|-|PromptOK(`\"You have selected `\" `+ AsString((int)result));&][s7; "
"`}&][s7; &][s5; In first line we are making new object of type [* CallbackArgTarget] "
"and we tell U`+`+ that output value of callbacks is [* int]. Constructor of this "
"class will assign [* Null] to output value. Then we create [* menu] and in [* for] "
"loop add ten menu items into it.[*  result`[i`]] will return callback that, when "
"invoked, assigns [* i] to the [* result] output value.&][s5; Although we don`'t have "
"main window with menu bar in this example, we can still show our [* menu] like pop "
"up window with [* Execute] method `- when program executes it will show pop up window "
"on current position of mouse. If we don`'t select anything in pop up menu bar window "
"than[*  IsNull(result)] will return [* True]. Instead of using [* IsNull] we could "
"use [^topic`:`/`/Core`/src`/Callbacks`$en`-us`#`:`:CallbackArgTarget`:`:IsNullInstance`(`)const^ "
"IsNullInstance]  template method wich will call IsNull(int).[*  ]On the other hand "
"if we select some menu item, appropriate callback will be executed and output value "
"of [* result] will get some number.&][s5; &][s5; Another feature of U`+`+ callbacks "
"is that they can easily imitate proxy behavior. If we wan`'t to make callback which "
"is in the same time proxy we can do that with a help of [* Proxy] function like in "
"next example&][s0; &][s7; #include <Core/Core.h>&][s7; &][s7; void Foo()&][s7; `{&][s7; "
"-|LOG(`\"Foo`\");&][s7; `}&][s7; &][s7; void Bar()&][s7; `{&][s7; -|LOG(`\"Bar`\");&][s7; "
"`}&][s7; &][s7;")
TOPIC_TEXT(
" CONSOLE`_APP`_MAIN&][s7; `{&][s7; -|Callback a, b;&][s7; -|a `= [* Proxy](b);&][s7; "
"-|b `= callback(Foo);&][s7; -|a();&][s7; -|b `= callback(Bar);&][s7; -|a();&][s7; "
"`}&][s5; &][s5; We have two callbacks [* a] and [* b], and in the next line [* Proxy(b)] "
"will return new callback which when executed will execute [* b] callback. So when "
"we assign to [* b] callback to [* Foo] and then execute [* a] callback, [* a] will "
"behave like a proxy callback and will then execute [* b] callback and [* b] will "
"then callback [* Foo] function.&][s0; This example is also interesting because it "
"uses some basics of U`+`+ login capabilities. In [* Foo] and [* Bar] we can see how "
"easy is to log program execution with a help of [* LOG()] macro. When program executes "
"on Linux, it will create log file in the home dir, or if you start it on Windows "
"on the same path where executable of program is. When we execute this example U`+`+ "
"will create file named `\".CallbackProxy.log`\" and it content will be like this&][s0; "
"&][s16; `* CallbackProxy 22.11.2005 22:44:48, user: ivica&][s16; &][s16; Foo&][s16; "
"Bar&][s0; &][s5; If log file with same name already exist, U`+`+ will first rename "
"existing log file (it will append `\".old`\" extension) and then it will write new "
"log.&][s5; &][s5; U`+`+ callbaks also have gates. There is nothing complicated about "
"the `\"gate`\" `- it is just callback that returns `\"bool`\" value. Note that perhaps "
"a little more generalisation here would seem fine (like possibility to define returns "
"values for callbacks) but so far, in 7 years, no more variants were really needed. "
"Also, reducing the real number of callback variants is somewhat benefical in order "
"to keep code ortogonal.]")
