#include <GLCtrl/GLCtrl.h>

using namespace Upp;

// Define a constant for the value of PI
#define GL_PI 3.1415f

struct OpenGLExample : GLCtrl {
	
    GLfloat nRange;

	// Rotation amounts
	GLfloat xRot;
	GLfloat yRot;
	
    GLfloat x,y,z,angle; // Storage for coordinates and angles

	void SetupRC() {
	    // Black background
	    glClearColor(0.0f, 0.0f, 0.0f, 1.0f );
	    // Set drawing color to green
	    glColor3f(0.0f, 1.0f, 0.0f);
	}
	
	virtual void GLPaint() {
	    SetupRC();

//	    Layout();

	    // Clear the window with current clearing color
	    glClear(GL_COLOR_BUFFER_BIT);
	
	    // Save matrix state and do the rotation
	    glPushMatrix();
	    glRotatef(xRot, 1.0f, 0.0f, 0.0f);
	    glRotatef(yRot, 0.0f, 1.0f, 0.0f);
	
	    // Call only once for all remaining points
	    glBegin(GL_POINTS);
	
	    z = -50.0f;
	    for(angle = 0.0f; angle <= (2.0f*GL_PI)*3.0f; angle += 0.1f)
	        {
	        x = 50.0f*sin(angle);
	        y = 50.0f*cos(angle);
	
	        // Specify the point and move the Z value up a little
	        glVertex3f(x, y, z);
	        z += 0.5f;
	        }
	
	    // Done drawing points
	    glEnd();
	
	    // Restore transformations
	    glPopMatrix();

	}
	
	void Layout() {
		Size sz = GetSize();
		int w = sz.cx; int h = sz.cy;
		
	    // Set Viewport to window dimensions
	    glViewport(0, 0, w, h);
	
	    // Reset projection matrix stack
	    glMatrixMode(GL_PROJECTION);
	    glLoadIdentity();
	
	    // Establish clipping volume (left, right, bottom, top, near, far)
	        if (w <= h)
	            glOrtho (-nRange, nRange, -nRange*h/w, nRange*h/w, -nRange, nRange);
	        else
	            glOrtho (-nRange*w/h, nRange*w/h, -nRange, nRange, -nRange, nRange);
	
	    // Reset Model view matrix stack
	    glMatrixMode(GL_MODELVIEW);
	    glLoadIdentity();
 	}
 	
	virtual bool Key(dword key, int count)
	{
		if(key == K_UP)
			xRot-= 5.0f;
	
		if(key == K_DOWN)
			xRot += 5.0f;
	
		if(key == K_LEFT)
			yRot -= 5.0f;
	
		if(key == K_RIGHT)
			yRot += 5.0f;
	
		if(key == K_DELETE) {
			xRot = 0.f; yRot = 0.f;
		}
		
		Refresh();
		
		return true; // key accepted
	}
	
public:

	OpenGLExample() : nRange(100.f), xRot(0.f), yRot(0.f) {}

};

class GLApp : public TopWindow {

	OpenGLExample gl;

public:

	typedef GLApp CLASSNAME;

	GLApp() {
		SetRect(0, 0, 250, 250);
		Add(gl.SizePos());
		Sizeable().Zoomable().Title("Points Example");
	}
	
};

GUI_APP_MAIN
{
	GLApp().Run();
}
