#include <GLCtrl/GLCtrl.h>

using namespace Upp;

struct OpenGLExample : GLCtrl {
	
	// Initial square position and size
	GLfloat x1;
	GLfloat y1;
	GLfloat rsize;
	
	// Step size in x and y directions
	// (number of pixels to move each time)
	GLfloat xstep;
	GLfloat ystep;
	
	// Keep track of windows changing width and height
	GLfloat windowWidth;
	GLfloat windowHeight;	

	virtual void GLPaint() {

		int w = GetSize().cx;
		int h = GetSize().cy;

		windowWidth = w>>1;
		windowHeight = h>>1;

	    // Set Viewport to window dimensions
	    glViewport(0, 0, w, h);
	
	    // Reset coordinate system
	    glMatrixMode(GL_PROJECTION);
	    glLoadIdentity();
	
	    glOrtho (-windowWidth, windowWidth, -windowHeight, windowHeight, 1., -1.);

	    glMatrixMode(GL_MODELVIEW);
	    glLoadIdentity();
	    
		glClearColor(0.f, 0.f, 1.f, 1.f);

	    // Clear the window with current clearing color
	    glClear(GL_COLOR_BUFFER_BIT);
	
	    // Set current drawing color to red
	    //         R     G     B
	    glColor3f(1.0f, 0.0f, 0.0f);
	
		ChangeSize();

	    // Draw a filled rectangle with current color
	    glRectf(x1, y1, x1 + rsize, y1 - rsize);
	}
	
	void ChangeSize() {
	    // Reverse direction when you reach left or right edge
	    if(x1 > windowWidth-rsize || x1 < -windowWidth)
	        xstep = -xstep;
	
	    // Reverse direction when you reach top or bottom edge
	    if(y1 > windowHeight || y1 < -windowHeight + rsize)
	        ystep = -ystep;
	
	    // Actually move the square
	    x1 += xstep;
	    y1 += ystep;
	
	    // Check bounds. This is in case the window is made
	    // smaller while the rectangle is bouncing and the
	    // rectangle suddenly finds itself outside the new
	    // clipping volume
	    if(x1 > (windowWidth-rsize + xstep))
	        x1 = windowWidth-rsize-1;
	    else if(x1 < -(windowWidth + xstep))
	    	x1 = -windowWidth -1;
	
	    if(y1 > (windowHeight + ystep))
	        y1 = windowHeight-1;
	    else if(y1 < -(windowHeight - rsize + ystep))
	    	y1 = -windowHeight + rsize -1;
	}

public:
	
	OpenGLExample() : x1(0.f), y1(0.f), xstep(1.f), ystep(1.f), rsize(50) {}

};

class GLApp : public TopWindow {

	OpenGLExample gl;

	void timeTick() { Refresh(); }

public:

	typedef GLApp CLASSNAME;

	GLApp() {
		SetRect(0, 0, 250, 250);
		Add(gl.SizePos());
		Sizeable().Zoomable().Title("Bounce");
		SetTimeCallback(-10, THISBACK(timeTick));
	}
	
};

GUI_APP_MAIN
{
	GLApp().Run();
}
