#ifndef _nRaster_Raster_h_
#define _nRaster_Raster_h_

enum {
	RASTER_1,
	RASTER_2,
	RASTER_4,
	RASTER_8,
	RASTER_16,
	RASTER_24,
	RASTER_32,
	RASTER_32ALPHA,

	RASTER_MSBFIRST = 0x80,

	RASTER_MAP_R = 32,
	RASTER_SHIFT_R = 3,
	RASTER_MAP_G = 64,
	RASTER_SHIFT_G = 2,
	RASTER_MAP_B = 16,
	RASTER_SHIFT_B = 4,

	RASTER_MAP_MAX = 64
};

struct PaletteCv {
	Buffer<byte> cv;

	byte *At(int r, int b)           { return cv + (r << 10) + (b << 6); }
	byte  Get(const RGBA& b) const   { return cv[(int(b.r >> RASTER_SHIFT_R) << 10) +
	                                             (int(b.g >> RASTER_SHIFT_G)) +
	                                             (int(b.b >> RASTER_SHIFT_B) << 6)]; }
	PaletteCv()                      { cv.Alloc(RASTER_MAP_R * RASTER_MAP_G * RASTER_MAP_B); }
};

struct RasterFormat {
	byte  type;
	dword rmask, gmask, bmask, amask;

	void Set1lf()          { type = RASTER_1; }
	void Set1mf()          { type = RASTER_1|RASTER_MSBFIRST; }
	void Set2lf()          { type = RASTER_2; }
	void Set2mf()          { type = RASTER_2|RASTER_MSBFIRST; }
	void Set4lf()          { type = RASTER_4; }
	void Set4mf()          { type = RASTER_4|RASTER_MSBFIRST; }
	void Set8()            { type = RASTER_8; }
	void Set16le(dword rmask, dword gmask, dword bmask);
	void Set16be(dword rmask, dword gmask, dword bmask);
	void Set24le(dword rmask, dword gmask, dword bmask);
	void Set24be(dword rmask, dword gmask, dword bmask);
	void Set32le(dword rmask, dword gmask, dword bmask, dword amask = 0);
	void Set32be(dword rmask, dword gmask, dword bmask, dword amask = 0);

	int  GetByteCount(int cx);
	void Read(RGBA *t, const byte *s, int cx, const RGBA *palette);
	void Write(byte *t, const RGBA *s, int cx, const PaletteCv *palcv);

private:
	byte  rpos, gpos, bpos, apos;
	static void TailBits(RGBA *t, const byte *src, int cx, byte and, byte shift, const RGBA *palette);
	static void TailBitsMSB1st(RGBA *t, const byte *src, int cx, byte shift1, byte and, byte shift, const RGBA *palette);
};

void CreatePaletteCv(const RGBA *palette, int ncolors, PaletteCv& cv_pal);
void CreatePalette(const RGBA *s, int count, RGBA *palette, int ncolors);
void CreatePalette(const RGBA *s, int count, RGBA *palette, int ncolors, PaletteCv& cv);

/*
struct RasterLine {
	bool        del;
	int         bytes;
	RasterBase *base;
	byte       *data;

	~RasterLine() { base->Set
}

class RasterBase {
	Size         size;
	RasterFormat format;
	int          linebytes;

protected:

public:
	virtual RasterLine Read(int line) = 0;
	virtual void       Write(int line, const byte *buffer);



	Image  Get(int x, int y, int cx, int cy);
	void   Set(int x, int y, int cx, int cy);

	virtual Image  Get();
	virtual Image  Put();

	int   GetLineBytes() const                              { return linebytes; }
	Size                GetSize() const                     { return size; }
	const RasterFormat& GetFormat()
};
*/

#endif