#include "ImgCtrl.h"

CImgCtrl::CImgCtrl()
{ 
	BackPaint();
	
	m_pOriginDraw=Point(0,0);
	
	m_pLastStop=m_pOriginDraw;
	
	m_bMoving=false;
	m_pLastPoint=Point(0,0);
	
	m_dFactor=0;
}

void CImgCtrl::Paint(Draw& w)
{
	w.DrawRect(GetSize(), White);
	if(m_ImgRep)
	{
		w.DrawImage(m_pOriginDraw.x, m_pOriginDraw.y, m_ImgRep);
	}
}

void CImgCtrl::incFactor(void)
{
	if(m_Img)
	{
		m_dFactor+=2;
		

		Size szTam=m_Img.GetSize();
		Rect iRect = Rect(0,0, szTam.cx, szTam.cy);
		Size szFinal = Size(szTam.cx+(szTam.cx*m_dFactor/100), szTam.cy+(szTam.cy*m_dFactor/100)); 
		m_ImgRep.Clear();
		m_ImgRep = Rescale(m_Img, szFinal, iRect); 
	
	
		Refresh();
	}
}

void CImgCtrl::decFactor(void)
{
	if(m_Img)
	{
		m_dFactor-=2;
		
		
		Size szTam=m_Img.GetSize();
		Rect iRect = Rect(0,0, szTam.cx, szTam.cy);
		Size szFinal = Size(szTam.cx+(szTam.cx*m_dFactor/100), szTam.cy+(szTam.cy*m_dFactor/100)); 
		m_ImgRep.Clear();
		m_ImgRep = Rescale(m_Img, szFinal, iRect); //se maior estica, se menor encolhe
		
		
		Refresh();
	}
}

void CImgCtrl::Fit(void)
{
	if(m_Img)
	{
		m_pOriginDraw=Point(0,0);
		m_pLastStop=m_pOriginDraw;
	
		Size szImagem=m_Img.GetSize(); 
		Size szJanela = GetSize(); //Por com este tamanho da janela
		
		m_dFactor=szJanela.cx-szImagem.cx;
		
		Rect iRect = Rect(0,0, szImagem.cx, szImagem.cy);
		m_ImgRep.Clear();
		m_ImgRep = Rescale(m_Img, szJanela, iRect); //se maior estica, se menor encolhe
		Refresh();
	}
}

void CImgCtrl::Center(void)
{
	if(!m_ImgRep)
		return;

	Size szImgFinal=m_ImgRep.GetSize();
	Size szWin=GetSize();
		
	int x=szWin.cx/2;
	int y=szWin.cy/2;
		
	x=x-(szImgFinal.cx/2);
	y=y-(szImgFinal.cy/2);
		
	m_pOriginDraw=Point(x,y);
	m_pLastStop=m_pOriginDraw;
}

void CImgCtrl::RealSize(void)
{
	if(m_Img)
	{
		m_ImgRep.Clear();
		m_dFactor=0;
		m_ImgRep.Clear();
		m_ImgRep = m_Img;

		Center();
		
		Refresh();
	}
}

void CImgCtrl::MouseWheel(Point p, int zdelta, dword keyflags)
{
	if(zdelta > 0)
		incFactor();
	else
		decFactor();
}

void CImgCtrl::LocalMenu(Bar& bar)
{
	if(m_ImgRep)
	{
		//bar.Add("Tamanho da janela", THISBACK(Fit)); 
		//bar.Add("Tamanho real", THISBACK(RealSize));	
		bar.Add("Fit Window", THISBACK(Fit)); 
		bar.Add("Real Size", THISBACK(RealSize));	
	}
}

void CImgCtrl::RightDown(Point p, dword keyflags)
{
	MenuBar::Execute(THISBACK(LocalMenu));
}

void CImgCtrl::LeftDown(Point p, dword keyflags) 
{
	m_pLastPoint=p;
    m_bMoving = true;
}

void CImgCtrl::LeftUp(Point p, dword keyflags) 
{
	m_pLastStop=m_pOriginDraw;//Largou-se o rapo, guardar deslocamento onde parou
    m_bMoving = false;
}
            
void CImgCtrl::MouseMove(Point p, dword keyflags) 
{
	Point pDif;
	
    if(m_bMoving) 
    {
         pDif=m_pLastPoint-p;
         int deslocX=pDif.x;
         int deslocY=pDif.y;
         
		 deslocX=deslocX*-1;
		 deslocY=deslocY*-1;
         
         m_pOriginDraw.x=m_pLastStop.x+deslocX;
         m_pOriginDraw.y=m_pLastStop.y+deslocY;
         
         Refresh();
    }
}

bool CImgCtrl::LoadImg(const String str_img_path) 
{
    m_Img.Clear();
	
	m_Img = StreamRaster::LoadFileAny(str_img_path);
	
	if(m_Img)
	{
		m_dFactor=0;
		
		Size szTam=m_Img.GetSize();
		Rect iRect = Rect(0,0, szTam.cx, szTam.cy);
		//Size szFinal = Size(szTam.cx+m_dFactor, szTam.cy+m_dFactor); //Por com este tamanho 
		Size szFinal = Size(szTam.cx+(szTam.cx*m_dFactor/100), szTam.cy+(szTam.cy*m_dFactor/100)); 
		m_ImgRep.Clear();
		m_ImgRep = Rescale(m_Img, szFinal, iRect); //se maior estica, se menor encolhe
		
		Center();
		
		Refresh();
		return true;
	}
	
	return false;
}


//Prints image alone or emnedded in other document
void CImgCtrl::PrintImg(Draw * p_draw_device/*=NULL*/, int n_draw_origin_x/*=0*/,int n_draw_origin_y/*=0*/,int n_image_cx/*=1000*/,int n_image_cy/*=1000*/)
{
	if(!m_ImgRep)
	{
		return;
	}
	
	//Format img for the asked size
	Size szTam=m_ImgRep.GetSize(); 
	Rect iRect = Rect(0,0, szTam.cx, szTam.cy); //Original
	Size szFinal = Size(n_image_cx,n_image_cy); //New
	Image imgAux = Rescale(m_Img, szFinal, iRect); //Zoom
	
	if(p_draw_device != NULL)
	{
		p_draw_device->DrawImage(n_draw_origin_x, n_draw_origin_y, imgAux);
		imgAux.Clear();
		return;
	}
	
	PrinterJob pd("Impressao de documento digitalizado");
	//if(pd.Execute())  //No Dialog
	Draw& w=pd.GetDraw();
	w.StartPage();
		w.DrawImage(n_draw_origin_x, n_draw_origin_y, m_ImgRep);
	w.EndPage();
	imgAux.Clear();
}

bool CImgCtrl::GetImageSize(Size* p_sz_image_size)
{
	if(!m_ImgRep)
	{
		return false;
	}
	
	*p_sz_image_size=m_ImgRep.GetSize();
	return true;
}


