#include "MinhaImagem.h"



MinhaImagem::MinhaImagem()
{
	CtrlLayout(*this, "Quick project to test CImageCtrl");
	
	Sizeable().Zoomable();
	Sizeable().MaximizeBox();
	SetMinSize(Size(300, 200));
	
		
	btOpen1 <<= THISBACK(OnButtonOpen1);
	btOpen2 <<= THISBACK(OnButtonOpen2);
	btPrintEmb <<= THISBACK(OnButtonPrintEmb);
	btPrint <<= THISBACK(OnButtonPrint);
	
	
}

void MinhaImagem::OnButtonOpen1(void)
{
	imgFoto.LoadImg("./1_Por do sol.jpg");
}

void MinhaImagem::OnButtonOpen2(void)
{
	imgFoto.LoadImg("./1_Inverno.jpg");
}

void MinhaImagem::OnButtonPrintEmb(void)
{
	Size szImagem;
	
	if(!imgFoto.GetImageSize(&szImagem))
	{
		Exclamation("Error!");
		return;
	}

	PrinterJob pd("Impressao de documento digitalizado");
	Draw& w=pd.GetDraw();
	w.StartPage();
		w.DrawText(100, 100, "Hello", Arial(100));
		w.DrawText(100, 200, "Here the image on position 0,1000", Arial(100));
		imgFoto.PrintImg(&w,0,1000,szImagem.cx+2000,szImagem.cy+2000);
	w.EndPage();
}

void MinhaImagem::OnButtonPrint(void)
{
	Size szImagem;
	
	if(!imgFoto.GetImageSize(&szImagem))
	{
		Exclamation("Error!");
		return;
	}
	
	imgFoto.PrintImg(NULL,0,1000,szImagem.cx+2000,szImagem.cy+2000);
}

GUI_APP_MAIN
{
	MinhaImagem x;
	x.Run();
}

