#include "ImgCtrl.h"

CImgCtrl::CImgCtrl()
{ 
	BackPaint();
	
	m_pOriginDraw=Point(0,0);
	
	m_pUltimoStop=m_pOriginDraw;
	
	m_bMoving=false;
	m_pLastPoint=Point(0,0);
	
	m_fFactor=0.0;
	
	m_fStep=0.03;
	
	m_bShowZoom=true;
}



void CImgCtrl::Paint(Draw& w)
{
	String strTemp;
	Size szWin=GetSize();

	w.DrawRect(GetSize(), White);
	if(m_ImgRep)
	{
		w.DrawImage(m_pOriginDraw.x, m_pOriginDraw.y, m_ImgRep);  
		if(m_bShowZoom)
		{
			strTemp=Format("Zoom: %2.2f",m_fFactor);
			w.DrawText(szWin.cx-65, szWin.cy-13, strTemp, Arial(10));
		}
	}
}

void CImgCtrl::incFactor(void)
{
	if(m_Img)
	{
		if(m_fFactor < MAX_ZOOM_FACTOR)
			m_fFactor+=m_fStep;
		
		Size szTam=m_Img.GetSize();
		Rect iRect = Rect(0,0, szTam.cx, szTam.cy);
		
		Size szFinal;
		if(m_fFactor >= 0)
			szFinal = Size(szTam.cx+int(szTam.cx*m_fFactor), szTam.cy+int(szTam.cy*m_fFactor)); //Por com este tamanho 
		else
			szFinal = Size(szTam.cx-abs(int(szTam.cx*m_fFactor)), szTam.cy-abs(int(szTam.cy*m_fFactor))); //Por com este tamanho 
				
		m_ImgRep.Clear();
		m_ImgRep = Rescale(m_Img, szFinal, iRect); //se maior estica, se menor encolhe
	
		Refresh();
	}
}

void CImgCtrl::decFactor(void)
{
	if(m_Img)
	{
		if(m_fFactor > MIN_ZOOM_FACTOR)
			m_fFactor-=m_fStep;
		
		Size szTam=m_Img.GetSize();
		Rect iRect = Rect(0,0, szTam.cx, szTam.cy);
		
		Size szFinal;
		if(m_fFactor >= 0)
			szFinal = Size(szTam.cx+int(szTam.cx*m_fFactor), szTam.cy+int(szTam.cy*m_fFactor)); //Por com este tamanho 
		else
			szFinal = Size(szTam.cx-abs(int(szTam.cx*m_fFactor)), szTam.cy-abs(int(szTam.cy*m_fFactor))); //Por com este tamanho 
		
		
		
		m_ImgRep.Clear();
		m_ImgRep = Rescale(m_Img, szFinal, iRect); //se maior estica, se menor encolhe
		Refresh();
	}
}

void CImgCtrl::Fit(void)
{
	float fFactor=0.0;
	Size szImagem=m_Img.GetSize(); 
	Size szJanela = GetSize(); 
	
	Rect targetWindowToDraw=Rect(0,0,szJanela.cx,szJanela.cy);
	Rect OriginalImgRect=Rect(0,0,szImagem.cx, szImagem.cy);
	Rect ImgTransfRect=OriginalImgRect;
	
	//Draw image inside the window rect
	//Image is smaller than window
	if(targetWindowToDraw.Contains(OriginalImgRect))
	{
		fFactor=0.0;
		
	}
	else
	{
		while(!targetWindowToDraw.Contains(ImgTransfRect))
		{
			ImgTransfRect=Rect(0,0,OriginalImgRect.Width()-abs(int(OriginalImgRect.Width()*fFactor)),OriginalImgRect.Height()-abs(int(OriginalImgRect.Height()*fFactor)));
				
			fFactor-=m_fStep;
			
			if(fFactor<= MIN_ZOOM_FACTOR)
			{
				break;
			}
		}
	}
	
	//Center image
	int dx=targetWindowToDraw.Width()-ImgTransfRect.Width();
	int dy=targetWindowToDraw.Height()-ImgTransfRect.Height();
	
	m_pOriginDraw=Point(0+int(dx/2),0+int(dy/2));
	//m_pOriginDraw=Point(0,0);
	m_pUltimoStop=m_pOriginDraw;
	
	
	m_fFactor=fFactor;
	m_ImgRep.Clear();
	Rect iRect = Rect(0,0, szImagem.cx, szImagem.cy);
	m_ImgRep = Rescale(m_Img, Size(ImgTransfRect.Width(),ImgTransfRect.Height()), iRect);          
	
	Refresh();
}


void CImgCtrl::RealSize(void)
{
	if(m_Img)
	{
		m_pOriginDraw=Point(0,0);
		m_pUltimoStop=m_pOriginDraw;
		m_ImgRep.Clear();
		m_fFactor=0.0;
		m_ImgRep.Clear();
		m_ImgRep = m_Img;
		Refresh();
	}
}

void CImgCtrl::MouseWheel(Point p, int zdelta, dword keyflags)
{
	if(zdelta > 0)
		incFactor();
	else
		decFactor();
}

void CImgCtrl::LocalMenu(Bar& bar)
{
	if(m_ImgRep)
	{
		bar.Add("Window size", THISBACK(Fit)); 
		bar.Add("Real size", THISBACK(RealSize));	
	}
}

void CImgCtrl::RightDown(Point p, dword keyflags)
{
	MenuBar::Execute(THISBACK(LocalMenu));
}

void CImgCtrl::LeftDown(Point p, dword keyflags) 
{
	m_pLastPoint=p;
    m_bMoving = true;
}

void CImgCtrl::LeftUp(Point p, dword keyflags) 
{
	m_pUltimoStop=m_pOriginDraw;//Largou-se o rapo, guardar deslocamento onde parou
    m_bMoving = false;
}
            
void CImgCtrl::MouseMove(Point p, dword keyflags) 
{
	Point pDif;
	
    if(m_bMoving) 
    {
         pDif=m_pLastPoint-p;
         //Exclamation(Format("Last(%d,%d) Actual(%d,%d), Dif(%d,%d)",m_pLastPoint.x,m_pLastPoint.y,p.x,p.y,pDif.x,pDif.y));
         int deslocX=pDif.x;
         int deslocY=pDif.y;
         
         //Deslocamentos estão ao contrário! +x andou para esq, +y andou para cima
		 deslocX=deslocX*-1;
		 deslocY=deslocY*-1;
         
         m_pOriginDraw.x=m_pUltimoStop.x+deslocX;
         m_pOriginDraw.y=m_pUltimoStop.y+deslocY;
         
         Refresh();
    }
}

void CImgCtrl::LoadImg(const String str_img_path) 
{
    m_Img.Clear();
	
	m_Img = StreamRaster::LoadFileAny(str_img_path);
	if(m_Img)
	{
		Fit();
	}
}

bool CImgCtrl::GetImageSize(Size* p_sz_image_size)
{
	if(!m_Img)
	{
		return false;
	}
	
	*p_sz_image_size=m_Img.GetSize();
	return true;
}

void CImgCtrl::PrintImagem(Draw * p_draw_device/*=NULL*/, int n_draw_origin_x/*=0*/,int n_draw_origin_y/*=0*/,int n_image_cx/*=1000*/,int n_image_cy/*=1000*/)
{
	if(!m_Img)
	{
		return;
	}
	
	//Formatar para tamanho pedido
	Size szTam=m_Img.GetSize(); 
	Rect iRect = Rect(0,0, szTam.cx, szTam.cy); //Original
	Size szFinal = Size(n_image_cx,n_image_cy); //Novo tamanho
	Image imgAux = Rescale(m_Img, szFinal, iRect); //Zoom
	
	if(p_draw_device != NULL)
	{
		p_draw_device->DrawImage(n_draw_origin_x, n_draw_origin_y, imgAux);
		imgAux.Clear();
		return;
	}
	
	PrinterJob pd("Impressao de documento digitalizado");
	//if(pd.Execute())  //Para aparecer a printer dialog!
	Draw& w=pd.GetDraw();
	w.StartPage();
		w.DrawImage(n_draw_origin_x, n_draw_origin_y, imgAux);
	w.EndPage();
	imgAux.Clear();
}



void CImgCtrl::SetStepZoomFactor(float f_step)
{
	if(f_step <= 0 || f_step > MAX_STEP)
		return;
	m_fStep=f_step;
}

float CImgCtrl::GetStepZoomFactor(void)
{
	return m_fStep;
}

void CImgCtrl::SetZoomVisible(const bool b_show)
{
	m_bShowZoom=b_show;
}

bool CImgCtrl::IsZoomShow(void)
{
	return m_bShowZoom;
}



