//Imagem A4: 1700x2338

////////////////AUTOR: NCosta//////////////////////////////////////
#ifndef _ImgCtrl_h_
#define _ImgCtrl_h_


#include <CtrlLib/CtrlLib.h>

#define MAX_STEP 0.5
#define MIN_ZOOM_FACTOR -0.95
#define MAX_ZOOM_FACTOR 3.00

using namespace Upp;

class CImgCtrl : public Ctrl 
{
public:
	typedef CImgCtrl CLASSNAME;
	CImgCtrl();
	
	void incFactor(void);
	void decFactor(void);
	void Fit(void);
	void RealSize(void);
	void LoadImg(const String str_img_path); 
	void PrintImagem(Draw * p_draw_device=NULL, int n_draw_origin_x=0,int n_draw_origin_y=0,int n_image_cx=1000,int n_image_cy=1000);
	bool GetImageSize(Size* p_sz_image_size);
	void SetStepZoomFactor(float f_step);
	float GetStepZoomFactor(void);
	void SetZoomVisible(const bool b_show);
	bool IsZoomShow(void);


	
	virtual void	MouseWheel(Point p, int zdelta, dword keyflags);
	virtual void	RightDown(Point p, dword keyflags);

	virtual void LeftDown(Point p, dword keyflags);
	virtual void LeftUp(Point p, dword keyflags);
	virtual void MouseMove(Point p, dword keyflags);
	
	

private:
	void LocalMenu(Bar& bar);
	void Paint(Draw& w);
	
	Point   m_pOriginDraw; //Coordenada origem para desenho
	Point   m_pUltimoStop; //Guarda o ultimo deslocamento em relação ao 0,0
	
	Image   m_Img;
	Image   m_ImgRep;
	float	m_fFactor;
	float	m_fStep;
	
	bool 	m_bMoving; 
	Point 	m_pLastPoint;
	bool    m_bShowZoom;
};


#endif

