#ifndef _Docking_SplitterTree_h_
#define _Docking_SplitterTree_h_

#include <CtrlLib/CtrlLib.h>
using namespace Upp;

#include "Tree.h"

class SplitterTree : public Ctrl
{
public:	
	typedef SplitterTree CLASSNAME;

	virtual void Paint(Draw &w);
	virtual void Layout()							{ LayoutNode(tree.Root(), GetView()); }
	virtual void LeftDown(Point p, dword keyflags);
	virtual void LeftUp(Point p, dword keyflags);
	virtual void MouseMove(Point p, dword keyflags);
	virtual Image CursorImage(Point p, dword keyflags);
	virtual void CancelMode()						{ drag = NULL; }
	
	virtual void ChildAdded(Ctrl *child) 			{ if (!internal_block && child->GetParent() == this) AddRoot0(*child, false, Size(Null)); }
	virtual void ChildRemoved(Ctrl *child) 			{ if (!internal_block && child->GetParent() == this) RemoveFromTree(*child); }
protected:	
	struct CtrlNode
	{
		Ctrl *	ctrl;
		bool 	vert:1;
		int 	sz;
		
		bool 	IsEmpty()								{ return ctrl; }
		CtrlNode() : ctrl(NULL), vert(false), sz(0)		{ }		
	};
	Tree<CtrlNode> 					tree;
	typedef Tree<CtrlNode>::Node 	Node;
	
	Node *	drag;
	Point 	dragpos;
	bool 	internal_block:1;

	Size 	HVSize(bool vert, const Size &a, const Size &b);
	Size 	GetNodeMinSize(Node *n);
	Size 	GetNodeMaxSize(Node *n);
	Rect 	GetNodeRect(Node *n);

	Rect 	PaintNode(Draw &w, Node *p);
	void	LayoutNode(Node *p, Rect r);
	void 	RefreshNode(Node *n)								{ Refresh(GetNodeRect(n)); }
	Node * 	AddBA(bool before, Node *p, Ctrl &c);					
	void	AddRoot0(Ctrl &ctrl, bool first, const Size &sz);
	void	BlockAdd(Ctrl &c)									{ internal_block = true; Add(c); internal_block = false; }

	Node *	MouseInBar(const Point &pt, Node *p, Rect r, bool store_nodes);
	Rect	DragHlRect();

	void	FixChildSizes(Node *p);
	void	SetNodeSize(Node *n, const Size &sz);

	Node *	FindCtrl(Ctrl *c);

	void 	RemoveFromTree(Ctrl &ctrl);
	void	CleanTree(Node *n);	
public:
	Ctrl & 	AddRoot(Ctrl &ctrl, bool first, Size sz = Null) 	{ if (!HasChild(&ctrl)) AddRoot0(ctrl, first, sz); return ctrl; }	
	Ctrl &	AddSibling(bool before, Ctrl &sibling, Ctrl &c, Size sz = Null);
	Ctrl & 	AddSiblingOver(bool vert, bool before, Ctrl &sibling, Ctrl &c, Size sz = Null);
	Ctrl & 	AddSiblingUnder(bool vert, bool before, Ctrl &sibling, Ctrl &c, Size sz = Null);
	Ctrl &	Swap(Ctrl &oldctrl, Ctrl &newctrl);
	
	void 	Clear()									{ tree.RemoveDeep(tree.Root()); for (Ctrl *c = GetFirstChild(); c; c = c->GetNext()) c->Remove(); }
	
	void 	RootVert()								{ RootVertHorz(true); }
	void 	RootHorz()								{ RootVertHorz(false); }
	void 	RootVertHorz(bool isvert)				{ tree.Root()->vert = isvert; Layout(); }
	bool 	IsRootVert() const	  					{ return tree.Root()->vert; }
	bool	IsCtrlVert(Ctrl &c)						{ Node *n = FindCtrl(&c); ASSERT(n); return tree.Parent(n)->vert; }
	
	Ctrl *	GetNextSibling(Ctrl &c);
	Ctrl *	GetPrevSibling(Ctrl &c);
	
	bool IsEmpty()									{ return tree.Root()->IsLeaf(); }
	
	SplitterTree();
};



#endif
