#include "test.h"
#include <string>

#define IMAGEFILE <test/test.iml>
#include <Draw/iml_source.h>

#if 0
#include "..\ezcomm\ezcomm.h"
#include "..\ezcomm\ezudp.h"
using namespace ezproject;
#endif

// Throw expection
void exception(void)
{
	throw std::string("throwing");
}

// Base class
class A
{
public:	
	void nonvt();
	virtual void vt() = 0;
};

// Inheritor
class B : public A
{
public:	
	void nonvt();
	virtual void vt() { exception(); }
};

test::test()
{
	CtrlLayout(*this, "Thanks");
	
	One<A> obj;
	obj = new B();
	thrd.Run(THISBACK2(Serve, obj, THISBACK(OnException)));
}

// Thread function
void test::Serve(One<A> obj, Callback1<String> WhenException)
{
	try
	{
		obj->vt();
		WhenException("not thrown");
	}
	catch (std::string err)
	{
		WhenException(err.c_str());
	}
}

// Called to update the GUI
void test::OnException(String exc)
{
	labe.SetText(exc);
}

GUI_APP_MAIN
{
//	WSADATA wsaData;
//	WSAStartup(MAKEWORD(2,2), &wsaData);
	test().Run();
}

