//******************************************************************************
// @file          CWinEventHandle.h
// @copyright     GNU Library General Public License
// @version       $Header$
// @author        Richard Dengler
// @language      C++ ANSI V3
// @description   A Wrapper around pthread_cond_t. Used to emulate win32-events.
//******************************************************************************
#ifndef CWINEVENTHANDLE_H
#define CWINEVENTHANDLE_H
#include <pthread.h>
#include <string>
#include <set>

class CWinEventHandle : public CBaseHandle
{
public:
  CWinEventHandle(bool manualReset = false, bool signaled = false, const wchar_t* name = NULL);
  virtual ~CWinEventHandle();
  bool close();
  inline void incRefCount() { m_RefCount++; }
  inline int decRefCount() { m_RefCount--; return m_RefCount; }
  bool signaled() const { return m_Signaled; }
  std::wstring name() const { return m_Name; }
  void reset();
  void signal();
  bool pulse();
  bool wait(unsigned numMs);
  bool wait();
  void subscribe(CWinEventHandle* subscriber);
  void unSubscribe(CWinEventHandle* subscriber);
private:
  pthread_mutex_t m_Mutex;
  pthread_cond_t m_Cond;
  bool m_ManualReset;
  bool m_Signaled;
  int m_Count;
  int m_RefCount;
  std::wstring m_Name;
  std::set<CWinEventHandle*> m_Subscriber; // Used in WaitForMultipleObjects()
};

#endif

