/*******************************************************************************
*******************************************************************************/
#include <iostream>
#include <stdlib.h>
#include "winEmul.h"

using std::cout;

/*******************************************************************************
This elementary test uses one thread to keep things simple.
*******************************************************************************/
int main()
{
  const wchar_t* eventName(L"testEvent");
  HANDLE hEvent = CreateEvent(NULL, true, false, eventName);
  HANDLE hTest = OpenEvent(0, false, eventName);
  if (hTest)
  {
    cout << "- OK, OpenEvent(" << eventName << ") succeeded.\n";
  }
  CloseHandle(hTest);

  // No event signaled yet, wait will fail
  cout << "WaitForMultipleObjects(), 5 sec timeout...\n";
  DWORD ret(WaitForMultipleObjects(1, &hEvent, false, 5000));
  if (ret == WAIT_TIMEOUT)
  {
    cout << "- OK, Timeout!\n";
  }
  else
  {
    cout << "ERROR: Got event" << ret << "\n";
  }

  // Signal the event and try again
  cout << "SetEvent()\n";
  SetEvent(hEvent);
  cout << "WaitForMultipleObjects()...\n";
  ret = WaitForMultipleObjects(1, &hEvent, false, INFINITE);
  cout << "- OK, Got event " << ret << "\n";
  ResetEvent(hEvent);
   
  // Wait for 2 events
  HANDLE hEvent2 = CreateEvent(NULL, false, false, L"");
  HANDLE lpHandles[2] = {hEvent, hEvent2};
  cout << "SetEvent()\n";
  SetEvent(hEvent);
  SetEvent(hEvent2);
   
  cout << "WaitForMultipleObjects(waitAll == true), 2 events\n";
  ret = WaitForMultipleObjects(2, lpHandles, true, 5000);
  if (ret == WAIT_TIMEOUT)
  {
    cout << "ERROR: Timeout!\n";
  }
  else
  {
    cout << "- OK: Got events\n";
  }

  CloseHandle(hEvent);
  CloseHandle(hEvent2);

  return 0;
}

