//******************************************************************************
// @file          winEmul.h
// @copyright     GNU Library General Public License
// @version       $Header$
// @author        Richard Dengler
// @language      C++ ANSI V3
// @description   Defines/types/declarations, mainly from windows header files.
//******************************************************************************
#ifndef WINEMUL_H
#define WINEMUL_H

#define WINAPI
#define WINBASEAPI
#define CONST const

#define STATUS_WAIT_0   ((DWORD)0x00000000L)
#define STATUS_TIMEOUT  ((DWORD)0x00000102L)

#define WAIT_TIMEOUT    STATUS_TIMEOUT
#define WAIT_OBJECT_0   ((STATUS_WAIT_0 ) + 0 )
#define INFINITE        0xFFFFFFFF    // Infinite timeout

typedef unsigned long DWORD;
typedef int BOOL;
typedef struct  SECURITY_ATTRIBUTES
{
    BOOL bInheritHandle;
};
typedef SECURITY_ATTRIBUTES* LPSECURITY_ATTRIBUTES;
typedef wchar_t WCHAR; // Note: sizeof(wchar_t) == 4!
typedef CONST WCHAR* LPCWSTR;

/*******************************************************************************
Opaque, polymorphal HANDLE. Base class. Used internally.
*******************************************************************************/
class CBaseHandle
{
public:
  CBaseHandle() {}
  virtual ~CBaseHandle() {}
  virtual bool wait(unsigned numMs) { return false; }
  virtual bool close() { return false; }
};

typedef CBaseHandle* HANDLE;

WINBASEAPI DWORD WINAPI WaitForSingleObject(HANDLE hHandle, DWORD dwMilliseconds);
WINBASEAPI DWORD WINAPI WaitForMultipleObjects(
    DWORD nCount, CONST HANDLE *lpHandles, BOOL bWaitAll, DWORD dwMilliseconds);
WINBASEAPI BOOL WINAPI SetEvent(HANDLE hEvent);
WINBASEAPI BOOL WINAPI ResetEvent(HANDLE hEvent);
WINBASEAPI BOOL WINAPI PulseEvent(HANDLE hEvent);  // Used in CRsEvent.cpp

WINBASEAPI HANDLE WINAPI CreateEvent(
    LPSECURITY_ATTRIBUTES lpEventAttributes, BOOL bManualReset, BOOL bInitialState, LPCWSTR lpName);

WINBASEAPI HANDLE WINAPI OpenEvent(DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName);
WINBASEAPI BOOL WINAPI CloseHandle(HANDLE hObject);

WINBASEAPI DWORD WINAPI GetTickCount();

#endif

