#ifndef _SQLPoly_main_h_
#define _SQLPoly_main_h_

#include <Core/Core.h>
using namespace Upp;

namespace VirtualSofts
{
    namespace SQL
    {
        typedef int cResultSet;
        class DBConnector
        {
        protected:
            bool m_Connected;
            String m_errorState;
        
        public:
            virtual ~DBConnector()
            {
                Disconnect();
            }
        //------------------------------------------
        // Accs  la base
        //------------------------------------------
            virtual bool Connect(String db);
            virtual bool Disconnect();
        
        //------------------------------------------
        // Accesseurs
        //------------------------------------------
            inline bool IsConnected() const { return m_Connected; }
        
        //------------------------------------------
        // Excution de requtes
        //------------------------------------------
            virtual int SQLExecDML(const String &request);
            virtual cResultSet SQLExecQuery(const String &request);
        
        //------------------------------------------
        // Gestion des Erreurs
        //------------------------------------------
            String GetLastError() const {return m_errorState;}
        
        };

        class MySQLConnector: public DBConnector
        {
        //...
        
        public:
        //------------------------------------------
        // Accs  la base
        //------------------------------------------
            virtual bool Connect(String db);
            virtual bool Disconnect();
        
        //------------------------------------------
        // Excution de requtes
        //------------------------------------------
            virtual int SQLExecDML(const String &request);
            virtual cResultSet SQLExecQuery(const String &request);
        
        };
    }
}

#endif
