#include "DBConnector.h"

#include <Toolkit/Tools.h>

using namespace VirtualSofts::SQL;
using namespace VirtualSofts::Tools;

//------------------------------------------
// cResultSet::cResultSet() Resul
//------------------------------------------
cResultSet::cResultSet()
{
	m_CurrentRow = 0;
	m_nbRows = 0;
	m_nbCols = 0;
	m_Ready = false;
}

void cResultSet::AddLine(KeyValueLine &kvl)
{
	m_nbCols = (int)kvl.size();
	m_ResultSet.push_back(kvl);
	m_nbRows++;
}
bool cResultSet::NextRow()
{
	if (!m_Ready)
	{
		if (m_nbRows > 0)
		{
			m_Ready = true;
			return true;
		}
		else return false; // Aucune donnée à lire
	}
	// On verifie si le prochain est bon
	if ( (m_CurrentRow+1) < m_ResultSet.size() )
	{
		// Ok, on l'incrémente
		m_CurrentRow++;
		return true;
	}
	return false;
}

String cResultSet::GetStrValue(String colName,int row)
{
	if (row == -1) row = m_CurrentRow;

	KeyValueLine kl = m_ResultSet[row];
	KeyValueLine::iterator itRes = kl.find(colName);
	if (itRes == kl.end() )
		throw cRSGetValException();

	return (itRes->second);
}
int cResultSet::GetIntValue(String colName,int row)
{
	if (row == -1) row = m_CurrentRow;

	KeyValueLine kl = m_ResultSet[row];
	KeyValueLine::iterator itRes = kl.find(colName);
	if (itRes == kl.end() )
		throw cRSGetValException();

	return (atoi(itRes->second.Begin()));
}
	
double cResultSet::GetDblValue(String colName,int row)
{
	if (row == -1) row = m_CurrentRow;

	KeyValueLine kl = m_ResultSet[row];
	KeyValueLine::iterator itRes = kl.find(colName);
	if (itRes == kl.end() )
		throw cRSGetValException();

	return (atof(itRes->second.Begin()));
}

void cResultSet::Out(StringStream &s)
{
	ResultSet::iterator itRS;
	for (itRS = m_ResultSet.begin();itRS != m_ResultSet.end(); itRS++)
	{
		KeyValueLine kvl = *itRS;
		KeyValueLine::iterator itKVL;
		for (itKVL = kvl.begin(); itKVL != kvl.end(); itKVL++)
		{
			if (itKVL != kvl.begin() )
				s<<" | ";
			s<<"KEY = "<<itKVL->first<<", VALUE = "<<itKVL->second;
		}
		//s<<endl;
	}
}
