#ifndef _DBConnector_DBConnector_h_
#define _DBConnector_DBConnector_h_

#pragma warning (disable : 4786)

#include <Core/Core.h>
#include <map>
#include <vector>

using namespace std;
using namespace Upp;


namespace VirtualSofts
{
	namespace SQL
	{
		//Exceptions 
		class cExecException : public exception {};
		class cRSGetValException : public exception {};
		

		// Structures 
		typedef map<String,String>		KeyValueLine;
		typedef vector<KeyValueLine>	ResultSet;

		class cResultSet
		{
			ResultSet		m_ResultSet;
			unsigned int	m_CurrentRow;
			int				m_nbRows,
							m_nbCols;

			bool			m_Ready;

		public:
	
			cResultSet();

			void Clear(){m_Ready = false;m_ResultSet.clear();}
			void AddLine(KeyValueLine &kvl);

			bool NextRow();

			String GetStrValue(String colName,int row=-1);
			int GetIntValue(String colName,int row=-1);
			double GetDblValue(String colName,int row=-1);

			int GetNbRows(){return m_nbRows;}
			int GetNbCols(){return m_nbCols;}
			
			void Out(StringStream &s);

		};

		class DBConnector
		{
		protected:
			bool			m_Connected;
			String			m_errorState;

		public:
			virtual ~DBConnector()
			{
				Disconnect();
			}
			//------------------------------------------
			// Accès à la base
			//------------------------------------------
			virtual bool Connect(String db);
			virtual bool Disconnect();

			//------------------------------------------
			// Accesseurs
			//------------------------------------------
			inline bool IsConnected() const { return m_Connected; }

			//------------------------------------------
			// Exécution de requêtes
			//------------------------------------------
			virtual int SQLExecDML(const String &request);
			virtual cResultSet SQLExecQuery(const String &request);

			//------------------------------------------
			// Gestion des Erreurs
			//------------------------------------------
			String GetLastError() const {return m_errorState;}

		};
	}
}

#endif
