#include <CtrlLib/CtrlLib.h>
#include <GLCtrl/GLCtrl.h>

using namespace Upp;

#define LAYOUTFILE <GLControlTest/layout.lay>
#include <CtrlCore/lay.h>

class GLTest : public GLCtrl
{
	virtual void GLPaint()
	{
		glClearColor(1.0, 1.0, 0.0, 1.0);
		glClear(GL_COLOR_BUFFER_BIT);
	}
};

class GLControlTest : public WithTestLayout<ParentCtrl>
{
	typedef GLControlTest CLASSNAME;

private:
	Splitter _splitter;
	GLTest _glTest;
	ImageCtrl _imgCtrl;
	MenuBar _menuBar;
	
	void Test()
	{
	}
	
	void MainMenu(Bar &bar)
	{
		bar.Add("Test", THISBACK(Test));
	}
	
public:
	GLControlTest()
	{
		AddFrame(_menuBar);
		_menuBar.Set(THISBACK(MainMenu));
		
		_imgCtrl.AddFrame(InsetFrame());
		_glTest.AddFrame(InsetFrame());
		
		_splitter.Horz(_imgCtrl, _glTest);
		*this << _splitter;
	}
};

class MainWindow : public TopWindow
{
	typedef MainWindow CLASSNAME;
	
private:
	GLControlTest _glCtrol;

public:
	MainWindow()
	{
		SetRect(0, 0, 500, 400);
		
		Add(_glCtrol.SizePos());
	}
};

GUI_APP_MAIN
{
	MainWindow app;
	app.Sizeable();
	app.MaximizeBox();
	app.MinimizeBox();
	app.Run();
}

