#include <CtrlLib/CtrlLib.h>
#include <GLCtrl/GLCtrl.h>

using namespace Upp;

class GlTest : public GLCtrl
{
protected:
	virtual void GLPaint()
	{
		glClearColor(1.0f, 0.0f, 0.0f, 1.0f);
		glClear(GL_COLOR_BUFFER_BIT);
	}
};

class RectTest : public StaticRect
{
	virtual void Paint(Draw& draw)
	{
		draw.DrawRect(GetSize(), Blue());
	}
};

#define LAYOUTFILE <GLCtrlBug/GLCtrlBug.lay>
#include <CtrlCore/lay.h>

class GLCtrlBug : public WithGLCtrlBugLayout<TopWindow> 
{
private:
	bool _hidden;
	
public:
	typedef GLCtrlBug CLASSNAME;
	GLCtrlBug();
	void test();
};

GLCtrlBug::GLCtrlBug()
{
	CtrlLayout(*this, "Window title");
	_button <<= THISBACK(test);
	_hidden = false;
}

void GLCtrlBug::test()
{
	if (_hidden)
	{
		Add(_rectCtrl);
		Add(_glCtrl);
	}
	else
	{
		RemoveChild(&_rectCtrl);
		RemoveChild(&_glCtrl);
	}
	
	_hidden = !_hidden;
}

GUI_APP_MAIN
{
	GLCtrlBug().Run();
}

