#ifndef _FireBird_FireBird_h_
#define _FireBird_FireBird_h_

//#include <CtrlLib/CtrlLib.h>
#include <Sql/Sql.h>
#include <Decimal/Decimal.h>
#include "ibpp/ibpp.h"

NAMESPACE_UPP

// FireBird -> Value types
// Bytea_v values are stored as bytea data, but recived as string type 
const int BYTEA_V = 34;

const char *FireBirdReadString(const char *s, String& stmt);

bool FireBirdPerformScript(const String& text,
#ifdef NOAPPSQL
	StatementExecutor& se,
#else
	StatementExecutor& se = SQLStatementExecutor(),
#endif
	Gate2<int, int> progress_canceled = false
);


String FireBirdTextType(int n);

class FireBirdSession : public SqlSession {
	
	friend class FireBirdConnection;
	
public:
	virtual bool                  IsOpen() const                   { return conn->Connected(); }
	virtual RunScript             GetRunScript() const             { return &FireBirdPerformScript; }

	virtual Vector<String>        EnumUsers();
	virtual Vector<String>        EnumDatabases();
	virtual Vector<String>        EnumTables();
	virtual Vector<String>        EnumViews();
	virtual Vector<String>        EnumGenerators();
	virtual Vector<SqlColumnInfo> EnumColumns(String table);
	virtual Vector<String>        EnumPrimaryKey(String database, String table);
	virtual String                EnumRowID(String database, String table);
	virtual Vector<String>        EnumReservedWords();	
	
protected:
	virtual SqlConnection *CreateConnection();

private:

	IBPP::Database        conn;
	IBPP::Statement		  statement;
	IBPP::Transaction	  transaction;
	IBPP::Service		  service;

	void                  ExecTrans(const char * statement);
	Vector<String>        EnumData(char type, const char *schema = NULL);
	String                ErrorMessage();
	String                ErrorCode();

public:
	bool                  Open(const char *connect);
	void                  Close();

	String                GetUser() { return conn->Username(); }
	operator IBPP::Database ()      { return conn; }

	virtual void          Begin();
	virtual void          Commit();
	virtual void          Rollback();
	
	FireBirdSession()  { 
						  conn = NULL; statement=NULL; transaction=NULL; service=NULL; Dialect(FIREBIRD); 
					   }
	~FireBirdSession() { Close(); }
	IBPP::Database  	GetFBConn() { return conn; }
};

class FbSequence : public ValueGen {
	SqlId       ssq;
	SqlId&      seq;
	SqlSession *session;

public:
	virtual Value  Get();

	Value operator++()                                                  { return Get(); }

	void Set(SqlId id, SqlSession& s)                                   { ssq = id; session = &s; }

#ifndef NOAPPSQL
	void Set(SqlId id)                                                  { ssq = id; session = NULL; }
	FbSequence(const char *name) : ssq(name), seq(ssq)                  { session = NULL; }
	FbSequence(SqlId& seq) : seq(seq)                                   { session = NULL; }
#endif
	FbSequence(const char *name, SqlSession& s) : ssq(name), seq(ssq)   { session = &s; }
	FbSequence(SqlId& seq, SqlSession& s) : seq(seq)                    { session = &s; }
	FbSequence() : seq(ssq)                                             { session = NULL; }
};

END_UPP_NAMESPACE

#endif
