#include "Draw.h"

RasterEncoder::RasterEncoder()
{
	size = Size(0, 0);
	dots = Size(0, 0);
	hotspot = Point(0, 0);
}

void RasterEncoder::SetLine(RGBA *_line)
{
	line = _line;
	h.Clear();
}

void RasterEncoder::WriteLine()
{
	WriteLine(line);
}

void RasterEncoder::WriteLine(const RGBA *s)
{
	memcpy(line, s, size.cx * sizeof(s));
	WriteLine();
}

void RasterEncoder::Create(Size sz)
{
	size = sz;
	h.Alloc(sz.cx);
	line = h;
	Start(sz);
}

void RasterEncoder::CreatePalette(Raster& raster, bool cv_all)
{
	int n = GetPaletteCount();
	if(n) {
		int nn = abs(n);
		if(raster.GetPaletteCount() == nn) {
			memcpy(GetPalette(), raster.GetPalette(), nn * sizeof(RGBA));
			CreatePaletteCv(GetPalette(), nn, GetPaletteCv());
		}
		else {
			if(n > 0 && !cv_all)
				::CreatePalette(raster, GetPalette(), nn, GetPaletteCv());
			else {
				::CreatePalette(raster, GetPalette(), nn);
				CreatePaletteCv(GetPalette(), nn, GetPaletteCv());
			}
		}
	}
}

void RasterEncoder::Create(Size sz, Raster& pal_raster, bool cv_all)
{
	CreatePalette(pal_raster, cv_all);
	Create(sz);
}

void RasterEncoder::Create(int cx, int cy, Raster& pal_raster, bool cv_all)
{
	CreatePalette(pal_raster, cv_all);
	Create(cx, cy);
}

int RasterEncoder::GetPaletteCount()
{
	return 0;
}

RGBA *RasterEncoder::GetPalette()
{
	if(!palette)
		palette.Alloc(256);
	return palette;
}

PaletteCv& RasterEncoder::GetPaletteCv()
{
	if(!palette_cv)
		palette_cv.Create<PaletteCv>();
	return *palette_cv;
}

RasterEncoder::~RasterEncoder() {}

void ImageEncoder::Start(Size sz)
{
	ii = 0;
	ib.Create(sz);
	if(sz.cy)
		SetLine(ib[0]);
}

void ImageEncoder::WriteLine()
{
	if(++ii < GetHeight())
		SetLine(ib[ii]);
}

void StreamRasterEncoder::Save(Stream& s, Raster& raster)
{
	SetStream(s);
	Size sz = raster.GetSize();
	Create(sz, raster, false);
	SetDots(raster.GetInfo().dots);
	SetHotSpot(raster.GetInfo().hotspot);
	for(int i = 0; i < sz.cy; i++)
		WriteLine(raster[i]);
}

bool StreamRasterEncoder::SaveFile(const char *fn, Raster& raster)
{
	FileOut out(fn);
	Save(out, raster);
	return !out.IsError();
}

String StreamRasterEncoder::SaveString(Raster& raster)
{
	StringStream ss;
	Save(ss, raster);
	return ss;
}

void StreamRasterEncoder::Save(Stream& s, const Image& img)
{
	ImageRaster r(img);
	Save(s, r);
}

bool StreamRasterEncoder::SaveFile(const char *fn, const Image& img)
{
	ImageRaster r(img);
	return SaveFile(fn, r);
}

String StreamRasterEncoder::SaveString(const Image& img)
{
	ImageRaster r(img);
	return SaveString(r);
}
