#ifndef _FireBirdUpp_FireBird_h_
#define _FireBirdUpp_FireBird_h_

#include <Sql/Sql.h>

#include "ibase.h"

#define TRANS_NORMAL 0 /* Normal transaction */
#define TRANS_FETCH 1 /* Select fetch transaction */

NAMESPACE_UPP

#ifdef PLATFORM_WIN32
#define DLLFILENAME "fbclient.dll"
#elif defined(PLATFORM_POSIX)
#define DLLFILENAME "libfbclient.so.2"
#endif
#define DLIMODULE   FBCLIENT
#define DLIHEADER   <plugin/firebird/FireBird.dli>
#include <Core/dli_header.h>

class FireBirdSession : public SqlSession
{
private:
	isc_db_handle *DB; /* Database handle (pointer, initilized in constructor) */
	isc_tr_handle trans; /* Transaction handle */
	ISC_STATUS_ARRAY status; /* Status array */
	String servername; /* Server name */
	String dbname; /* Database name */
	String username; /* User name */
	String password; /* Password */
	int SQL_DIALECT; /* Firebird database dialect */
	int lastquerytype; /* Last query type */
	int trans_type; /* If true, select stmt started a trans */
	
public:
	FireBirdSession();
	~FireBirdSession();
	
	bool Open(const char *connect);
	void Close();
	virtual bool IsOpen() const { return DB; }
	int GetSqlDialect() {return SQL_DIALECT; }
	int SetSqlDialect(int value) {SQL_DIALECT = value; }
	String GetUser() { return username; }
	
	/* Transaction functions */
	virtual void Begin();
	virtual void Commit();
	virtual void Rollback();
	virtual int GetLastQueryType() {return lastquerytype; };
	virtual void SetLastQueryType(int type) {lastquerytype = type; };
	virtual int GetTransType() {return trans_type; };
	virtual void SetTransType(int type) {trans_type = type; }
	isc_tr_handle getTrans() { return trans; }
	Vector<String> EnumTables(String database);

protected:
	virtual SqlConnection *CreateConnection();

public:
	T_FBCLIENT fbclient;

};

END_UPP_NAMESPACE

#endif
