#define INT(x)                     COLUMN("integer", int, x, 0, 0)
#define INT_ARRAY(x, items)        COLUMN_ARRAY("integer", int, x, 0, 0, items)
#define INT_(x)                    COLUMN_("integer", int, x, 0, 0)
#define INT_ARRAY_(x, items)       COLUMN_ARRAY_("integer", int, x, 0, 0, items)

#define INT64(x)                   COLUMN("int64", int64, x, 0, 0)
#define INT64_ARRAY(x, items)      COLUMN_ARRAY("int64", int64, x, 0, 0, items)
#define INT64_(x)                  COLUMN_("int64", int64, x, 0, 0)
#define INT64_ARRAY_(x, items)     COLUMN_ARRAY_("int64", int64, x, 0, 0, items)

#define DOUBLE(x)                  COLUMN("double precision", double, x, 0, 0)
#define DOUBLE_ARRAY(x, items)     COLUMN_ARRAY("double precision", double, x, 0, 0, items)
#define DOUBLE_(x)                 COLUMN_("double precision", double, x, 0, 0)
#define DOUBLE_ARRAY_(x, items)    COLUMN_ARRAY_("double precision", double, x, 0, 0, items)

#define STRING(x, n)               COLUMN("varchar(" #n ")", String, x, 0, 0)
#define STRING_ARRAY(x, n, items)  COLUMN_ARRAY("varchar(" #n ")", String, x, 0, 0, items)
#define STRING_(x, n)              COLUMN_("varchar(" #n ")", String, x, 0, 0)
#define STRING_ARRAY_(x, n, items) COLUMN_ARRAY_("varchar(" #n ")", String, x, 0, 0, items)

#define DATE(x)                    COLUMN("date", Date, x, 0, 0)
#define DATE_ARRAY(x, items)       COLUMN_ARRAY("date", Date, x, 0, 0, items)
#define DATE_(x)                   COLUMN_("date", Date, x, 0, 0)
#define DATE_ARRAY_(x, items)      COLUMN_ARRAY_("date", Date, x, 0, 0, items)

#define TIME(x)                    COLUMN("timestamp", Time, x, 0, 0)
#define TIME_ARRAY(x, items)       COLUMN_ARRAY("timestamp", Time, x, 0, 0, items)
#define TIME_(x)                   COLUMN_("timestamp", Time, x, 0, 0)
#define TIME_ARRAY_(x, items)      COLUMN_ARRAY_("timestamp", Time, x, 0, 0, items)

#define BOOL(x)                    COLUMN("char(1)", bool, x, 0, 0)
#define BOOL_ARRAY(x, items)       COLUMN_ARRAY("char(1)", bool, x, 0, 0, items)
#define BOOL_(x)                   COLUMN_("char(1)", bool, x, 0, 0)
#define BOOL_ARRAY_(x, items)      COLUMN_ARRAY_("char(1)", bool, x, 0, 0, items)

#define BLOB(x)                    COLUMN("blob", String, x, 0, 0)
#define BLOB_(x)                   COLUMN_("blob", String, x, 0, 0)

#define SEQUENCE(x)                SCHEMA("create sequence " #x " start with 1;",\
                                          "drop sequence " #x ";") \
                                   UPGRADE("create sequence " #x " start with 1;")
#define SEQUENCE_(x)               DOID(x) SEQUENCE(x)

#define PRIMARY_KEY                INLINE_ATTRIBUTE("primary key")
#define NOT_NULL                   INLINE_ATTRIBUTE("not null")
#define UNIQUE                     INLINE_ATTRIBUTE("unique")
#define SQLDEFAULT(v)              INLINE_ATTRIBUTE("default " #v)

#define INDEX                      ATTRIBUTE("create index IDX_@x on @t(@c);", \
                                             "drop index IDX_@x;")
#ifndef REFERENCES
#define REFERENCES(x)              ATTRIBUTE("alter table @t add constraint FK_@x foreign key "\
                                             "(@c) references " #x ";",\
                                             "alter table @t drop constraint FK_@x;")
#endif
#ifndef REFERENCES_CASCADE
#define REFERENCES_CASCADE(x)      ATTRIBUTE("alter table @t add constraint FK_@x foreign key "\
                                             "(@c) references " #x " on delete cascade;",\
                                             "alter table @t drop constraint FK_@x;")
#endif
#ifndef REFERENCES_
#define REFERENCES_(n, x)          ATTRIBUTE("alter table @t add constraint FK_@x$" #n " foreign key "\
                                             "(@c) references " #x ";",\
                                             "alter table @t drop constraint FK_@x$" #n ";")
#endif
#ifndef REFERENCES_CASCADE_
#define REFERENCES_CASCADE_(n, x)  ATTRIBUTE("alter table @t add constraint FK_@x$" #n " foreign key "\
                                             "(@c) references " #x " on delete cascade;",\
                                             "alter table @t drop constraint FK_@x$" #n ";")
#endif

#define DUAL_PRIMARY_KEY(k1, k2)   ATTRIBUTE("alter table @t add constraint DK_@t primary key "\
                                             "(" #k1 ", " #k2 ");",\
                                             "alter table @t drop constraint DK_@t;")

#define DUAL_UNIQUE(k1, k2)        ATTRIBUTE("alter table @t add constraint DQ_@t unique "\
                                             "(" #k1 ", " #k2 ");",\
                                             "alter table @t drop constraint DQ_@t;")

#define SQLCHECK(name, chk)        ATTRIBUTE("alter table @t add constraint CHK_@t$" #name " check "\
                                             "(" chk ");",\
                                             "alter table @t drop constraint CHK_@t$" #name ";")

#define PRIMARY_KEY_LIST(name, keys) \
ATTRIBUTE("alter table @t add constraint PKL_@t$" #name " primary key (" keys ");", \
          "alter table @t drop constraint PKL_@t$" #name  ";")

#define REFERENCES_LIST(name, fks, tab, keys) \
ATTRIBUTE("alter table @t add constraint FKL_@t$" #name " foreign key " \
          "(" fks ") references " #tab "(" keys ");", \
          "alter table @t drop constraint FKL_@t$" #name ";")

#define INDEX_LIST(name, keys) \
ATTRIBUTE("create index IDXL_@t$" #name " on @t(" keys ");", \
          "drop index IDXL_@t$" #name ";");

#define UNIQUE_LIST(name, list) \
ATTRIBUTE("alter table @t add constraint UQ_@t$" #name " unique (" list ");", \
          "alter table @t drop constraint UQ_@t$" #name ";")

#include <Sql/sch_model.h>

#undef INT
#undef INT_ARRAY
#undef INT_
#undef INT_ARRAY_

#undef DOUBLE
#undef DOUBLE_ARRAY
#undef DOUBLE_
#undef DOUBLE_ARRAY_

#undef STRING
#undef STRING_ARRAY
#undef STRING_
#undef STRING_ARRAY_

#undef BLOB
#undef BLOB_

#undef PRIMARY_KEY
#undef AUTO_INCREMENT
#undef NOT_NULL

#undef INDEX
#undef UNIQUE

#undef TIMESTAMP
#undef COMMENT

