/*
C++ EGGTRAY ICON EXAMPLE BY BEER necrorising@videotron.ca
Copyright (C) 2005  name of author

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <gtkmm.h>
#include "eggtrayicon.h"
#include <gtk/gtk.h>

class eggwnd : public Gtk::Window
{  
public:
        eggwnd();
        ~eggwnd();

private:
        void on_show1_activate();
        void on_quit2_activate();
        void on_systray_click(GdkEventButton* event);
        static void _on_systray_click(GtkWidget *widget, GdkEventButton *event, gpointer data) {
        	((eggwnd*)data)->on_systray_click(event); 
        }
		bool on_delete_event(GdkEventAny* event);
		EggTrayIcon *tray_icon;
        Gtk::Menu *menuitem4_menu;
	    GtkWidget *icon;
	    GtkWidget *box;
};

eggwnd::eggwnd(
) : Gtk::Window(Gtk::WINDOW_TOPLEVEL)
{  
		// BEGIN GLADE STUFF
   Gtk::Window *eggwnd = this;
   Gtk::Image *image1 = Gtk::manage(new class Gtk::Image(Gtk::StockID("gtk-goto-top"), Gtk::IconSize(1)));
   Gtk::ImageMenuItem *show1 = NULL;
   Gtk::MenuItem *separator1 = NULL;
   Gtk::Image *image2 = Gtk::manage(new class Gtk::Image(Gtk::StockID("gtk-quit"), Gtk::IconSize(1)));
   Gtk::ImageMenuItem *quit2 = NULL;
   menuitem4_menu = Gtk::manage(new class Gtk::Menu());
   Gtk::MenuItem *menuitem4 = NULL;
   Gtk::MenuBar *menubar1 = Gtk::manage(new class Gtk::MenuBar());
   Gtk::Label *label1 = Gtk::manage(new class Gtk::Label("System Tray Icon Demo"));
   Gtk::VBox *vbox1 = Gtk::manage(new class Gtk::VBox(false, 0));
  
   menuitem4_menu->items().push_back(Gtk::Menu_Helpers::ImageMenuElem("Show", *image1));
   show1 = (Gtk::ImageMenuItem *)&menuitem4_menu->items().back();
   menuitem4_menu->items().push_back(Gtk::Menu_Helpers::SeparatorElem());
   separator1 = (Gtk::MenuItem *)&menuitem4_menu->items().back();
   menuitem4_menu->items().push_back(Gtk::Menu_Helpers::ImageMenuElem("Quit", *image2));
   quit2 = (Gtk::ImageMenuItem *)&menuitem4_menu->items().back();
   menubar1->items().push_back(Gtk::Menu_Helpers::MenuElem("_File", *menuitem4_menu));
   menuitem4 = (Gtk::MenuItem *)&menubar1->items().back();
   image1->set_alignment(0.5,0.5);
   image1->set_padding(0,0);
   image2->set_alignment(0.5,0.5);
   image2->set_padding(0,0);
   label1->set_alignment(0.5,0.5);
   label1->set_padding(0,0);
   label1->set_justify(Gtk::JUSTIFY_CENTER);
   label1->set_line_wrap(false);
   label1->set_use_markup(false);
   label1->set_selectable(false);
   vbox1->pack_start(*menubar1, Gtk::PACK_SHRINK, 0);
   vbox1->pack_start(*label1);
   eggwnd->set_size_request(301,150);
   eggwnd->set_title("Egg Tray Window");
   eggwnd->set_modal(false);
   eggwnd->property_window_position().set_value(Gtk::WIN_POS_CENTER);
   eggwnd->set_resizable(false);
   eggwnd->property_destroy_with_parent().set_value(false);
   eggwnd->add(*vbox1);
   image1->show();
   show1->show();
   separator1->show();
   image2->show();
   quit2->show();
   menuitem4->show();
   menubar1->show();
   label1->show();
   vbox1->show();
   eggwnd->show();
   show1->signal_activate().connect(SigC::slot(*this, &eggwnd::on_show1_activate));
   quit2->signal_activate().connect(SigC::slot(*this, &eggwnd::on_quit2_activate));
   // END GLADE STUFF
   
   // DROP TO C TO CREATE GTK+ WIDGETS FOR USE WITH eggtrayicon.c SYSTRAY STUFF, C++ DROPDOWNS WON'T DO
   box = gtk_event_box_new ();
   icon = gtk_image_new ();
   tray_icon = egg_tray_icon_new ("System Tray Example");
   gtk_container_add (GTK_CONTAINER (box), icon);
   gtk_container_add (GTK_CONTAINER (tray_icon), box);
   gtk_widget_show_all (GTK_WIDGET (tray_icon));
   // ADD BUTTON PRESS ON SYSTRAY  - MUST CONNECT TO A STATIC FUNCTION
   g_signal_connect (G_OBJECT(box), "button-press-event", G_CALLBACK(&eggwnd::_on_systray_click), this);
   // LOAD IMAGE INTO SYSTRAY WIDGET
   GdkPixbuf *pixbuf;
   pixbuf = gtk_image_get_pixbuf (GTK_IMAGE (icon));
   if (pixbuf) g_object_unref (G_OBJECT (pixbuf));  
   pixbuf = gdk_pixbuf_new_from_file ("icon.png", NULL);
   gtk_image_set_from_pixbuf (GTK_IMAGE (icon), pixbuf);	
   
}

eggwnd::~eggwnd()
{  
	GdkPixbuf *pixbuf = gtk_image_get_pixbuf (GTK_IMAGE (icon));
	if (pixbuf) g_object_unref (G_OBJECT (pixbuf));
	gtk_widget_destroy (GTK_WIDGET (icon));
	gtk_widget_destroy (GTK_WIDGET (box));
	gtk_widget_destroy (GTK_WIDGET (tray_icon));
}

void eggwnd::on_show1_activate()
{  
	GtkWindow* win = this->gobj();
	gtk_widget_show(GTK_WIDGET(win));
}

void eggwnd::on_quit2_activate()
{  
	gtk_main_quit();
}

bool eggwnd::on_delete_event(GdkEventAny* event)
{
	// CLOSE BUTTON PRESSED
	GtkWindow* win = this->gobj();
	gtk_widget_hide(GTK_WIDGET(win));
	return true;
}

void eggwnd::on_systray_click(GdkEventButton* event)
{
	  if((event->type == GDK_BUTTON_PRESS) && (event->button == 3))
	  {
	    menuitem4_menu->popup(event->button, event->time);
	    return;
	  }
	  
	  if((event->type == GDK_2BUTTON_PRESS) && (event->button == 1))
	  {
		GtkWindow* win = this->gobj();
		gtk_widget_show(GTK_WIDGET(win));
		return;
	  }
}

int main(int argc, char **argv)
{  
   
   Gtk::Main m(&argc, &argv);

	eggwnd *eggwnd = new class eggwnd();
	// REASON, IF YOU gtk_widget_hide(GTK_WIDGET(win)); when the user presses the close button
	// INSTEAD OF REDUCING TO THE SYSTRAY, IF GTKmm .run() is invoked it will terminate the app
	// SO USE C gtk_main() instead.
	//   m.run(*eggwnd);
	gtk_main();
	delete eggwnd;
   return 0;
}