//**********************************************************************************************
//* WebMail Library
//* ---------------
//* A collection of internet e-mail protocol (POP, SMTP, IMAP) 
//* encapsulation classes for Ultimate++
//* 


#ifndef _WebMail_EMail_h_
#define _WebMail_EMail_h_

class EMail : Moveable<EMail>
{
public:
	EMail& 			operator<<(String text)		{ mail = text; return *this; 	}
	EMail& 			operator=(String text)		{ return *this << text; 		}
//	Email&			operator=(class EMail& src)	{ Copy(src); return *this; 	} 

	String	 		Subject() 					{ return Get(Header(), "Subject: "); 		}
	String	 		ReplyTo() 					{ return Get(Header(), "Reply-To: ");		}
	String	 		From() 						{ return Get(Header(), "From: ");			}
	String			To()						{ return Get(Header(), "To: ");				}
	String			Cc()						{ return Get(Header(), "Cc: ");				}
	String			Date() 						{ return Get(Header(), "Date: ");			}
	String	 		Type() 						{ return Get(Header(), "Content-Type: ");	}
	String	 		Body(); 					
	String	 		Header(); 				

	String			Raw()	 	 				{ return mail; }
	String			Guid()						{ return guid; }	
	
private:
	void			Copy(const EMail& src)		{ mail = src.mail;	guid = src.guid; }
	String			Get(String in, String s);
	String			GetNext(String& in, String s);
	String			GetPrev(String& in, String s);

	String 			mail;
	String 			guid;

public:
	EMail(String text)							{ mail = text; }
	EMail(String text, String uid)				{ mail = text; guid = uid; 	}
	EMail(const EMail& src)						{ Copy(src);}
	EMail()										{};

};

#endif
