//**********************************************************************************************
//* WebMail Library
//* ---------------
//* A collection of internet e-mail protocol (POP, SMTP, IMAP) 
//* encapsulation classes for Ultimate++
//* 


#ifndef _WebMail_MailSocket_h_
#define _WebMail_MailSocket_h_

class MailSocket {
public:
	MailSocket&					User(String user)			{ user0 = user;		return *this; }
	MailSocket&					Pass(String pass)			{ pass0 = pass;		return *this; }	
	MailSocket&					Host(String host)			{ host0 = host;		return *this; }
	MailSocket&					Port(int port)				{ port0 = port;		return *this; }
	
	MailSocket&					Transcript(bool b = true)	{ transcript = (b ? &transcripttext : 0); return *this; }
	
	String						GetError() const			{ return error; }
	String						GetTranscript() const		{ return transcripttext; }

	virtual void				Connect(String host, int port, String user, String pass);
	virtual void				Disconnect() = 0;

	Socket&						GetSocket()					{ return socket; }	
	
protected:
	virtual void				Send(String s, int timeout = 60);
	virtual String				Recv(String s, bool multiline = false, int timeout = 60);	
	dword						SetTimeout(int t)			{ return t >= 0 ? GetTickCount() + 1000 * t : 0xffffffff; }	
	void						SetTranscript(String s)		{ if(transcript)  *transcript << s; }
	
protected:
	String						host0;
	String						user0;
	String						pass0;
	int							port0;
	String						error;
	
private:
	String*						transcript;
	String						transcripttext;

	Socket						socket;

public:
	MailSocket() { transcript = 0; }
};



#endif
