//**********************************************************************************************
//* WebMail Library
//* ---------------
//* A collection of internet e-mail protocol (POP, SMTP, IMAP) 
//* encapsulation classes for Ultimate++
//* 


#ifndef _WebMail_POP3Mail_h_
#define _WebMail_POP3Mail_h_

class POP3Mail : public MailSocket {
public:
	enum { DISCONNECTED, AUTHORIZATION, TRANSACTION, UPDATE };
	
	POP3Mail&					APOP(bool b = true)				{ useapop = b; return *this; 	}
		
	EMail						GetMail(int index); 
	String						GetMailGuid(int index);
	void						GetMailStats(int& count, double& totalsize);
	String						GetMailHeader(int index, int length = 0);
	double						GetMailSize(int index);
	void						GetMailList(VectorMap<int, double>& list);
	void						GetMailGuids(VectorMap<int, String>& guids);
	void						DeleteMail(int index);
	void						Undo();
	void						Noop();
	void						Quit();
	
	bool						ReadInbox(Vector<EMail>& mailbox, int length = -1);

	virtual void				Connect(String host, int port, String user, String pass, bool apop = false);
	virtual void				Disconnect();
	
	bool						IsConnected()	const { return state != DISCONNECTED; 	}
	bool						IsAuthorizing() const { return state == AUTHORIZATION; 	}
	bool						IsTransacting()	const { return state == TRANSACTION;	}
	bool						IsUpdating()	const { return state == UPDATE;			}
		
	int							State() const	{ return state; }
	
private:
	String						SendRecvOK(String s, bool multiline = false, int timeout = 60);
	int							state;
	bool						useapop;
	
public:
	POP3Mail();
};

#endif
