/*
    U++ Command Line Argument Processor 0.2.1
    Author: Chris (captainc)
    Date: 9/29/08
    Description:
    This package parses arguments and assigns values to them based on argument value.
    Users define their arguments, conditions, and allowable combinations of arguments; 
    the package will ensure that the arguments are assigned the correct values and occur in the 
    correct combinations. Usage information is automatically generated by the argument lists and 
    ready for output to command line (or other stream).
    
    This U++ package was inspired by TCLAP the Templatized Command Line Parser (tclap.sourceforge.net).
    TCLAP is not friendly with U++, so it was decided to create somewhat similar functionality 
    using U++ types.
*/

#ifndef UPP_CMDLINEARGPROCESSOR_ARGPROCESSOR_HPP
#define UPP_CMDLINEARGPROCESSOR_ARGPROCESSOR_HPP

#include <Core/Core.h>
#include <CmdLineArgProcessor/TArg.hpp>
#include <CmdLineArgProcessor/ArgSet.hpp>

using namespace Upp;

class ArgProcessor{
	protected:
		String _program_title, _version;
		Vector< Ptr<TArg> > _arg_list;		
		String _short_delim, _long_delim, _error_str;
		Vector< Ptr<ArgSet> > _arg_sets;
		Stream * _out_stream;
		bool _error, _print_usage;
		
		int GetArgIdx(String id, bool long_flag=false);
		bool IsHelpFlag(String flag, bool long_flag);
		bool IsVersionFlag(String flag, bool long_flag=false);
		
	public:		
		ArgProcessor(String program_title, String version) : 
			_program_title(program_title), _version(version), _short_delim("-"), _long_delim("--"), \
			_out_stream(&(Cout())), _error(false), _error_str(""), _print_usage(false) {};
		
		void AddArg(TArg& arg);
		void AddArg(Ptr<TArg> parg);
		void AddArgSet(ArgSet& arg_set);
		
		ArgProcessor& operator<<(TArg& arg)
		{
			AddArg(arg);
			return *this;
		};
		
		ArgProcessor& operator<<(ArgSet& arg_set){
			AddArgSet(arg_set);
			return *this;
		};
		
		bool HasMatch();
		bool Matches(Ptr<ArgSet> arg_set);
		bool HasExtraInvalidArgs(Ptr<ArgSet> arg_set);

		void ProcessCmdLine(const Vector<String> & cmdline);
		void SetArgDelim(String short_delim, String long_delim);
				
		String UsageInformation();		
		void PrintUsageInformation();	
		String VersionInformation();
		void PrintVersionInformation();		
		
		String GetError() { return _error_str; }
		bool IsError() { return _error; };
		void PrintUsageOnError(bool print_usage=true){ _print_usage=print_usage; };
		void PrintToStream(Stream & ss=Cout());
		
};

/// TODO: overload AddArg for every type ? (could be useful)
/// void AddArg(Arg<int>)
/// void AddArg(Arg<bool>) ...

#endif
