#ifndef UPP_CMDLINEARGPROCESSOR_ARGSET_HPP
#define UPP_CMDLINEARGPROCESSOR_ARGSET_HPP

#include <Core/Core.h>
#include <CmdLineArgProcessor/TArg.hpp>

using namespace Upp;

/**
An ArgSet is a set of arguments that go together; it represents combinations of arguments.
*/
class ArgSet : public Pte<ArgSet>
{
	friend class ArgProcessor;
	protected:
		Vector< Ptr<TArg> > _args;	
		bool _is_match;
	
	public:
	
		ArgSet():_is_match(false){};
	
		ArgSet(const ArgSet& arg_set)
		{
			_args <<= arg_set._args;
			_is_match = arg_set._is_match;
		};
	
		bool IsMatch(){return _is_match;};
		
		bool Has(Ptr<TArg> parg)
		{
			for(int i=0; i<_args.GetCount(); i++)
			{
				if(_args[i]==parg)
				{
					return true;
				}
			}
			return false;
		};
		
		ArgSet& operator<<(TArg& arg)
		{
			AddArg(arg);
			return *this;
		};
		
		void AddArg(TArg& arg)
		{
			bool dupe=false;
			for(int i=0; i<_args.GetCount(); i++){
				if(_args[i] == &arg){
					dupe=true;
					break;
				}
			}
			if(!dupe){
				_args.Add(&arg);
			}
		};
		
		ArgSet& operator<<(ArgSet& arg_set)
		{
			AddArgSet(arg_set);
			return *this;
		};
		
		void AddArgSet(ArgSet& arg_set)
		{
			for(int i=0; i<arg_set._args.GetCount(); i++)
			{
				_args.Add( arg_set._args[i] );
			}
		};
		
		String GetArgSetStr(){
			String res("");
			for(int i=0;i<_args.GetCount();i++){
				res.Cat( Format("\t%s\n", _args[i]->GetTitle()) );
			}
			return res;
		};

};

#endif

