#include <Core/Core.h>
#include <CmdLineArgProcessor/ArgProcessor.hpp>

using namespace Upp;

void PrintLinesInFile(String filepath, int num_lines, Stream& output);

CONSOLE_APP_MAIN
{
	const Vector<String>& cmdline = CommandLine();
	
	ArgProcessor ap("File Name Printer", "0.1");
	
	Arg<int> num_lines_arg			("Number of Lines", "Number of lines to print from each file.");
									//< the above constructor will create -n and --number flags automatically from the argument's title.
	Arg<String> file_output_arg		("o","output-file","Output File", "Write output to file.");
	Arg<bool> print_output_arg		("p", "print-output", "Print Output to Console", "Print output of files found to console..");	
	Arg<String> file_input_arg 		("File Input", "Single input file to read from.", true);
	MultiArg<String> dir_input_arg	("Directory", "Directory where files are located. (Specify as many times as necessary).", true);
									//< the above constructor will create -d and --directory flags automatically from the argument's title.	
	
	// Build composable sets/groupings of arguments.
	ArgSet common_args, file_input_argset, directory_input_argset;
	
	// Add arguments to a common set.
	common_args << num_lines_arg << file_output_arg << print_output_arg;
	
	// Add specific argument and all the common arguments.
	file_input_argset << file_input_arg << common_args;
	
	// Add another specific argument and all the common arguments.
	directory_input_argset << dir_input_arg << common_args;	
	
	// Or we could have used the following methods:
	// directory_input_argset.AddArg(TArg& arg)
	// directory_input_argset.AddArgSet(ArgSet& arg_set)
	
	// Add the allowed argument sets to the argument processor.
	ap << file_input_argset << directory_input_argset;
		
	// Or we could have used built-in methods and wrote:
	// ap.AddArgSet(file_input_argset);
	// ap.AddArgSet(directory_input_arget);
	
	// Parse the command line; assign values from its arguments.
	ap.ProcessCmdLine(cmdline);
	
	int num_lines = num_lines_arg.IsSet() ? num_lines_arg.Val() : 5; //implicit conversion from Value to int.
	
	// check if there was an error with the expected command line input.
	if(!ap.IsError())
	{
		//Check which set of arguments matched the user's input
		if(file_input_argset.IsMatch())
		{
			if(print_output_arg.IsSet())
			{				
				PrintLinesInFile(file_input_arg.Val().ToString(), num_lines, Cout());
			}
			if(file_output_arg.IsSet())
			{
				FileOut fout(file_output_arg.Val().ToString());
				PrintLinesInFile(file_input_arg.Val().ToString(), num_lines, fout);
				fout.Close();
			}
			
		}
		else if(directory_input_argset.IsMatch())
		{			
			for(int i=0; i<dir_input_arg.GetCount(); i++)
			{
				Cout() << "Dir: " << dir_input_arg[i].ToString()+"\\*.txt" << "\n";
				FindFile ff;				
				if(ff.Search(dir_input_arg[i].ToString()+"\\*.txt"))
				{
					Cout() << "Directory ArgSet File: " << ff.GetName() << "\n";
					do
					{					
						if(ff.IsFile())
						{
							if(print_output_arg.IsSet())
							{
								PrintLinesInFile(dir_input_arg[i].ToString()+"\\"+ff.GetName(), num_lines, Cout());
							}
							if(file_output_arg.IsSet())
							{
								FileAppend fout(file_output_arg.Val().ToString());
								PrintLinesInFile(dir_input_arg[i].ToString(), num_lines, fout);
								fout.Close();
							}
						}
					}while(ff.Next());
				}
			}			
		}
	}
	else
	{
		ap.PrintUsageInformation();
	}
}

void PrintLinesInFile(String filepath, int num_lines, Stream& output)
{
	//Cout() << "PrintLinesInFile File: " << filepath << "\n";
	if(FileExists(filepath))
	{
		FileIn file(filepath);
		for(int i=0; i<num_lines; i++)
		{
			if(file.IsEof()){ break; }
			output << file.GetLine();
		}
	}
}

