#include <Core/Core.h>
#include <CmdLineArgProcessor/ArgProcessor.hpp>

using namespace Upp;

CONSOLE_APP_MAIN
{
	const Vector<String>& cmdline = CommandLine();
	
	ArgProcessor ap("Command Line Argument Processor Test", "0.1");
	
	Arg<int> num_lines_arg			("Number of Lines", "Number of lines to print from each file.");
									//< the above constructor will create -n and --number flags automatically from the argument's title.
	Arg<String> file_output_arg		("o","output-file","Output File", "Write output to file.");
	Arg<bool> print_output_arg		("p", "print-output", "Print Output to Console", "Print output of files found to console..");	
	Arg<String> file_input_arg 		("File Input", "Single input file to read from.", true);
	MultiArg<String> dir_input_arg	("Directory", "Directory where files are located. (Specify as many times as necessary).", true);
									//< the above constructor will create -d and --directory flags automatically from the argument's title.	
	
	// Build composable sets/groupings of arguments.
	ArgSet common_args, file_input_argset, directory_input_argset;
	
	// Add arguments to a common set. (Use operator << for composing arguments/argument sets.
	common_args << num_lines_arg << file_output_arg << print_output_arg;
	
	// Add specific argument and all the common arguments.
	file_input_argset << file_input_arg << common_args;
	
	// Add another specific argument and all the common arguments.
	directory_input_argset << dir_input_arg << common_args;	
	
	// Or we could have used the following ArgSet class methods:
	// directory_input_argset.AddArg(TArg& arg)
	// directory_input_argset.AddArgSet(ArgSet& arg_set)
	
	// Add the allowed argument sets to the argument processor.
	ap << file_input_argset << directory_input_argset;
		
	// Or we could have used built-in methods and wrote:
	// ap.AddArgSet(file_input_argset);
	// ap.AddArgSet(directory_input_arget);
	
	// Parse the command line; assign values from its arguments.
	ap.ProcessCmdLine(cmdline);
	
	// check if there was an error with the expected command line input.
	if(!ap.IsError())
	{
		// Check which set of arguments matched the user's input and which arguments were specified.
		if(file_input_argset.IsMatch())
		{
			Cout() << "File input argset matched, File input arg: " << file_input_arg.Val() << "\n";
		}
		else if(directory_input_argset.IsMatch())
		{
			Cout() << "Directory list input argset matched.\n";
			for(int i=0; i<dir_input_arg.GetCount(); i++)
			{
				Cout() << "\tDirectory: " << dir_input_arg[i].ToString() << "\n";				
			}		
		}
		if(print_output_arg.IsSet())
		{				
			Cout() << "Print output argument specified.\n";
		}
		if(file_output_arg.IsSet())
		{
			Cout() << "File output argument specifed: " << file_output_arg.Val() << "\n";
		}
		if(num_lines_arg.IsSet())
		{
			int num_lines = num_lines_arg.Val(); // implicit conversion from Value to int.
			Cout() << "Number of lines argument specified: " << num_lines << " lines.\n";
		}
	}
	else
	{
		Cout() << ap.GetError() << "\n";
		ap.PrintUsageInformation();
		// This could have been automated by setting ap.PrintUsageOnError()	before calling ProcessCmdLine()
	}
}

