#include <Core/Core.h>
#include <CmdLineArgProcessor/TArg.hpp>
#include <CmdLineArgProcessor/ArgProcessor.hpp>

using namespace Upp;

void ArgProcessor::AddArg(TArg& arg)
{
	bool dupe=false;
	for(int i=0; i<_arg_list.GetCount(); i++)
	{
		if(_arg_list[i] == &arg)
		{
			dupe=true;
			break;
		}
	}
	if(!dupe)
	{
		_arg_list.Add(&arg);
	}
}

void ArgProcessor::AddArg(Ptr<TArg> parg)
{
	AddArg(*parg);
}

void ArgProcessor::AddArgSet(ArgSet& arg_set)
{
	for(int i=0; i<arg_set._args.GetCount(); i++)
	{
		AddArg(arg_set._args[i]);
	}
	_arg_sets.Add(&arg_set);
}

int ArgProcessor::GetArgIdx(String id, bool long_flag)
{
	//Cout() << Format("Getting ArgIdx, Matching id: %s (long: %s) \n _arg_list count:%d \n", id, AsString(long_flag), _arg_list.GetCount());
	for(int i=0; i<_arg_list.GetCount(); i++){
		//Cout() << Format("ArgIdx: %s, ArgTitle: %s, Flags: %s %s\n", IntStr(i), _arg_list[i]->GetTitle(), _arg_list[i]->GetShortFlag(), _arg_list[i]->GetLongFlag());
		if( (long_flag && _arg_list[i]->GetLongFlag().IsEqual(id) ) || _arg_list[i]->GetShortFlag().IsEqual(id) )
		{ return i; }
	}
	//Cout() << "Did not find ArgIdx\n";
	return -1;
}

bool ArgProcessor::IsHelpFlag(String flag, bool long_flag)
{
	return (long_flag && flag.IsEqual("help")) || flag.IsEqual("h");	
}

bool ArgProcessor::IsVersionFlag(String flag, bool long_flag)
{
	return (long_flag && flag.IsEqual("version")) || flag.IsEqual("v");	
}

void ArgProcessor::ProcessCmdLine(const Vector<String> & cmdline)
{
		//Cout() << Format("Values on cmd line: %s\n", AsString(cmdline.GetCount()));
	// Parse cmdline and assign values to arguments.
	try
	{	
		for(int i = 0; i < cmdline.GetCount(); i++)
		{
			if(cmdline[i].StartsWith(_long_delim) || cmdline[i].StartsWith(_short_delim))
			{
				//Cout() << Format("CmdLine Iter: %s\n", AsString(i));					
				int pos = cmdline[i].StartsWith(_long_delim) ? \
						cmdline[i].Find(_long_delim)+(_long_delim.GetCount()-1) : \
						cmdline[i].Find(_short_delim)+(_short_delim.GetCount()-1);
				String arg_flag = ToLower(cmdline[i].Mid(pos+1));
				bool is_long_flag = pos>(_short_delim.GetCount()-1);
				if(IsHelpFlag(arg_flag, is_long_flag))
				{
					PrintUsageInformation();
					return;
				}
				else if(IsVersionFlag(arg_flag, is_long_flag))
				{
					PrintVersionInformation();
					return;
				}
				else
				{
					int arg_pos=GetArgIdx(arg_flag, is_long_flag);
					if(arg_pos>=0)
					{
						if(_arg_list[arg_pos]->RequiresValue())
						{
							i++;
							if( i < cmdline.GetCount() )
							{							
								_arg_list[arg_pos]->Val(cmdline[i]);
							}
							else
							{
								String used_flag = is_long_flag ? \
									_long_delim+_arg_list[arg_pos]->GetLongFlag() : \
									_short_delim+_arg_list[arg_pos]->GetShortFlag();
								throw ArgExc("Expected value for argument: '" + \
										_arg_list[arg_pos]->GetTitle() + "', flag: '" + used_flag + "'.");
							}
						}
						else // assume it is a switch option (they require no values)
						{
							//TODO: i'd like to refactor the use of blank string in Val.
							_arg_list[arg_pos]->Val("");
						}
					}
					else
					{
						throw ArgExc("Unknown flag used: '" + cmdline[i] + "'");
					}
				}
			}
			else
			{
				throw ArgExc("Invalid argument switch: '" + cmdline[i] + "'");
			}			
		}		
		//Validate sets/xors
		if(!HasMatch())
		{
			throw ArgExc("Invalid argument specification.");
		}
		
	}
	catch(ArgExc &err)
	{
		_error=true;
		_error_str = "Error: " + err;		
		if(_print_usage)
		{
			(*_out_stream) << _error_str + " Reference program usage information...\n";	
			PrintUsageInformation(); 
		}
	}
}

bool ArgProcessor::HasMatch()
{
	for(int j=0; j<_arg_sets.GetCount(); j++)
	{
		if(Matches(_arg_sets[j]))
		{
			//Cout() << "Argument match found\n";
			_arg_sets[j]->_is_match = true;
			if(!HasExtraInvalidArgs(_arg_sets[j]))
			{
				return true;
			}
		}
		//Cout() << "Argument match NOT found\n";
	}	
	return false;
}

bool ArgProcessor::Matches(Ptr<ArgSet> arg_set)
{
	for(int i=0; i<arg_set->_args.GetCount(); i++)
	{
		for(int j=0; j<_arg_list.GetCount(); j++)
		{
			if(arg_set->_args[i] == _arg_list[j])
			{
				return (arg_set->_args[i]->IsRequired() && !arg_set->_args[i]->IsSet() ? false : true);
			}
		}		
	}
	return true;
}

bool ArgProcessor::HasExtraInvalidArgs(Ptr<ArgSet> arg_set)
{
	for(int i=0; i<_arg_list.GetCount(); i++)
	{
		if(arg_set->Has(_arg_list[i]))
		{
			if(_arg_list[i]->IsSet())
			{
				return true;
			}
		}
	}
	return false;
}

String ArgProcessor::UsageInformation()
{
	String usage_info("");
	usage_info << Format("%s\nVersion %s\nUsage:\n", _program_title, _version);	
	for(int i=0;i<_arg_sets.GetCount();i++)
	{
		usage_info << Format("%d. %s ", i+1, GetFileName(GetExeFilePath())); //GetExeTitle()
		String details("Argument Details:\n");
		for(int j=0; j<_arg_sets[i]->_args.GetCount(); j++)
		{	
			Ptr<TArg> cur = _arg_sets[i]->_args[j];
			details << Format("%s%s    %s%s%s\t%s\n", _short_delim, cur->GetShortFlag(), _long_delim, cur->GetLongFlag(), \
					 (cur->GetLongFlag().GetCount() < 8 ? String("\t") : String("")), cur->GetDescription()); 
					 // the ...'GetCount() < 8'... is a dumb output formatting helper
			if(cur->IsRequired())
			{
				usage_info << Format("%s%s <%s> ", _short_delim, cur->GetShortFlag(), cur->GetTitle());
			}
			else
			{
				usage_info << Format("[%s%s <%s>] ", _short_delim, cur->GetShortFlag(), cur->GetTitle());
			}
		}
		usage_info << Format("\n%s\n", details);
	}	
	usage_info << "Other Options:\n" \
			   << Format("%s%s    %s%s \t\t%s\n", _short_delim, "h", _long_delim, "help", "Displays help information.") \
			   << Format("%s%s    %s%s \t%s\n", _short_delim, "v", _long_delim, "version", "Displays program version information.");	
	return usage_info;
}

void ArgProcessor::PrintUsageInformation()
{	
	if(_out_stream->IsOpen()){
		(*_out_stream) << UsageInformation();
	}
}

String ArgProcessor::VersionInformation()
{
	return Format("%s Version %s", _program_title, _version);
}

void ArgProcessor::PrintVersionInformation()
{
	if(_out_stream->IsOpen()){
		(*_out_stream) << VersionInformation() << "\n";
	}
}

void ArgProcessor::SetArgDelim(String short_delim, String long_delim)
{
	if(short_delim.GetCount()>0)
	{
		_short_delim = short_delim;
	}
	if(long_delim.GetCount()>0)
	{
		_long_delim = long_delim;
	}
}
		
void ArgProcessor::PrintToStream(Stream & ss){ _out_stream = &ss; }

/* 
::: SCRAP :::
Matches() --> First method:
	for(int i=0; i<_arg_list.GetCount(); i++)
	{
		if(_arg_list[i]->IsRequired() && !arg_set->Has(_arg_list[i]))
		{
			return false;
		}
	} */
/*
void ArgProcessor::ArgSetLoopTest()
{
	for(int i=0;i<_arg_sets.GetCount();i++)
	{
		Cout() << Format("ArgSet List Entry %d:\n%s", i, _arg_sets[i]->GetArgSetStr());
	}
}

if(arg.GetShortFlag().GetCount()<=0 || arg.GetLongFlag().GetCount()<=0)
		{
			arg.SetFlagsFromTitle();
			//GenerateValidFlags(&arg);
		}
bool ArgProcessor::FlagInUse(String flag, bool long_flag)
{
	for(int i=0; i<_arg_list.GetCount(); i++){
		if( (long_flag && _arg_list[i]->GetLongFlag().IsEqual(flag) ) || _arg_list[i]->GetShortFlag().IsEqual(flag) )
		{ return true; }
	}
	return false;
}

void ArgProcessor::GenerateValidFlags(Ptr<TArg> parg)
{	
	String short_flag, long_flag;
	int i=1;
	do
	{
		short_flag = parg->GetTitle().Left(i++);
	}
	while(FlagInUse(short_flag) && i<parg->GetTitle().GetCount() );
}
//Cout() << Format("Setting Value to %s\n", cmdline[i]);
*/

