
%define		name    upp-svn
%define		version svn
%define		release 1

%define		title     Ultimate++
%define 	longtitle C++ cross-platform rapid application development suite

Summary:        %longtitle
Name:           %name
Version:        %version
Release:        %release
License:        BSD-like, GPL-2.1, LGPL
Group:          Development/C++
URL:            http://www.ultimatepp.org
Source0:        upp-src-%{version}.tar.gz
Source1:	theide-48.png

Patch0:		upp-src-svn.fix_png_name_in_desktop_file
Patch1:		upp-src-svn.fix_anonymous_enum

# Common Buildrequires
Buildrequires:	gcc gcc-c++ gtk2-devel pango-devel atk-devel cairo-devel

# Mandriva specific Buildrequires
%if "%?mdvver" != ""
Buildrequires:	X11-devel freetype2-devel expat-devel

# OpenSuse specific Buildrequires
%else
%if "%?suse_version" != ""
Buildrequires:	patch make xorg-x11-devel freetype2-devel libexpat-devel

# Fedora specific Buildrequires
%else
Buildrequires:	xorg-x11-server-devel freetype-devel expat-devel
%endif
%endif

# -----
Requires:	gcc gcc-c++ gtk2-devel pango-devel atk-devel cairo-devel
Requires:       valgrind

# Mandriva specific Requires
%if "%?mdvver" != ""
Requires:  X11-devel freetype2-devel expat-devel

# OpenSuse specific Requires
%else
%if "%?suse_version" != ""
Requires:	xorg-x11-devel freetype2-devel libexpat-devel

# Fedora specific Requires
%else
Requires:	xorg-x11-server-devel freetype-devel expat-devel
%endif
%endif

# -------
Buildroot:	%{_tmppath}/%{name}-%{version}-%{release}-buildroot

#-----------
%description
The U++ integrated development environment, TheIDE, introduces modular concepts to C++
programming. It provides:

	- TheIDE, a visual designers for U++ libraries
	- Topic++, for documenting code and creating rich text resources
	- Assist++, a powerful C++ code analyzer providing code completion,
	  navigation and transformation
	- BLITZ-build technology to speedup C++ rebuilds up to 4 times

#----
%prep

%setup -q -c
%patch0
%patch1

# ----
%build

make -j3 -e HOSTTYPE=LINUX -e LOCALBASE=%{_prefix} -e LIBPATH=$(pkg-config --libs-only-L x11 freetype2 gtk+-2.0 glib-2.0 cairo pango atk) -e CINC=" -Iuppsrc $(pkg-config --cflags x11 freetype2 gtk+-2.0 glib-2.0 cairo pango atk)"

#-------
%install
rm -rf %{buildroot}

install -d %{buildroot}/%{_bindir}
install -d %{buildroot}/%{_desktopdir}
install -d %{buildroot}/%{_datadir}/pixmaps
install -d %{buildroot}/%{_datadir}/%{name}

install out/ide/GCC-Gcc-Gui-LINUX-Main-Shared/ide %{buildroot}/%{_bindir}/theide-svn

cp -p uppsrc/ide/theide.desktop %{buildroot}/%{_desktopdir}/theide-svn.desktop

# theide.png is corrupted, need a good png
cp -p %{_sourcedir}/theide-48.png %{buildroot}/%{_datadir}/pixmaps/theide.png

cp -a bazaar %{buildroot}/%{_datadir}/%{name}/
# cp -a Common %{buildroot}/%{_datadir}/%{name}/
cp -a uppsrc %{buildroot}/%{_datadir}/%{name}/
cp -a examples %{buildroot}/%{_datadir}/%{name}/
cp -a reference %{buildroot}/%{_datadir}/%{name}/
cp -a tutorial %{buildroot}/%{_datadir}/%{name}/

# Need to create GCC.bm manually because it doesn't exist
# cp -p uppsrc/ide/GCC.bm %{buildroot}/%{_datadir}/%{name}/

INCLUDEDIR=$( pkg-config --cflags x11 freetype2 gtk+-2.0 glib-2.0 cairo pango atk | awk ' { gsub ( / /, "" ) ; gsub ( /-I/, ";" ) ; sub ( /;/, "" ) ; print $0 }' )
LIBDIR=$( pkg-config --libs-only-L x11 freetype2 gtk+-2.0 glib-2.0 cairo pango atk | awk ' { gsub ( / /, "" ) ; gsub ( /-I/, ";" ) ; sub ( /;/, "" ) ; print $0 }' )

cat > %{buildroot}/%{_datadir}/%{name}/GCC.bm << EOF
BUILDER		= "GCC";
COMPILER	= "g++";
DEBUG_INFO	= "2";
DEBUG_BLITZ	= "1";
DEBUG_LINKMODE	= "1";
DEBUG_OPTIONS	= "-O0";
RELEASE_BLITZ		= "0";
RELEASE_LINKMODE	= "1";
RELEASE_OPTIONS		= "-O3 -ffunction-sections";
RELEASE_SIZE_OPTIONS	= "-Os -finline-limit=20";
DEBUGGER	= "gdb";
PATH		= "";
INCLUDE		= "$INCLUDEDIR";
LIB		= "$LIBDIR";
REMOTE_HOST	= "";
REMOTE_OS	= "";
REMOTE_TRANSFER	= "";
REMOTE_MAP	= "";
EOF


#-----
%clean
rm -fr %{buildroot}

#-----
%files
%defattr(-,root,root,-)
# %doc COPYING README INSTALL
%doc uppsrc/ide/Copying
%{_bindir}/theide-svn
%{_desktopdir}/theide-svn.desktop
%{_datadir}/pixmaps/theide.png
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/*

#---------
%changelog
* Fri Aug 15 2008 Amrein-Marie Christophe <camreinmarie@free.fr> 2008.1-1
- First package
