#include "ArrayColors.h"


struct Column1Display : Display {
	virtual void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const 
	{
		w.DrawRect(r, Blend(SColorMark, SColorPaper, 220));
		w.DrawText(r.left, r.top, q.ToString());
	}
};

struct Column2Display : Display {
	virtual void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const 
	{
		w.DrawRect(r, SColorInfo);
		w.DrawText(r.left, r.top, q.ToString());
	}
};

ArrayColors::ArrayColors()
{
	CtrlLayout(*this, "ArrayCtrl example");
	Sizeable().Zoomable();
	list1.AddColumn("Number");
	list1.AddColumn("Roman");

	list1.ColumnWidths("20 20");
	list2.ColumnWidths("20,20");
	
	// Set Row colors of List 1.
	list1.EvenRowColor();
	list1.OddRowColor ();

	// Set Column colors of List 2.	
	list2.AddColumn("Number").SetDisplay(Single<Column1Display>());
	list2.AddColumn("Roman").SetDisplay(Single<Column2Display>());

	for(int i = 0; i < 50; i++) {
		list1.Add(i, FormatIntRoman(i)); 	
		list2.Add(i, FormatIntRoman(i));	
	}

	split.Horz(list1, list2);
	Add(split.SizePos());

}

GUI_APP_MAIN
{
	ArrayColors().Run();
}

