#ifndef _Kran_Kran_h
#define _Kran_Kran_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <Kran/Kran.lay>
#include <CtrlCore/lay.h>
#include "../COMMON/RS232Thread.h"

class Kran : public WithKranLayout<TopWindow>
{ typedef Kran CLASSNAME;
public:
	Kran();
	~Kran();
	
private:
	void OnStart();
	void OnStop();
	
	void Work();
	
	void LoadAndInit();
	void SaveAndShutdown();
	void UpdateStateUI();
	void UpdateConnectionUI();
	
	void UpdateStatsQueue();
	
	struct Triad
	{
		BYTE  n;
		bool  ext;
		float f[6];
	};
	void OnReceiveData(DWORD, RS232Data *, bool *, void *);
	void OnPacketReceived(bool, int, const void *);
	void OnWriteTriad(const Triad &);
	void OnUpdateStats(const Kran::Triad &triad);
	
	enum State {STATE_STOPPED, STATE_STOPPING, STATE_ONLINE};
	
	State          state;
	RS232Thread    rs232;
	DCB            dcb;
	
	struct Config
	{
		int    com;
		String comString;
		
		void Serialize(Stream& s)
		{
			s % com % comString;
		}
	};
	Config config;
	
	String outFileName;
};

class ExcNoMessage         : public Exc {};
class ExcMessageCorrupted  : public Exc {};

#endif

