topic "Manual / RS232Thread / Tutorial 3";
[2 $$0,0#00000000000000000000000000000000:Default]
[l288;i1120;a17;O9;~~~.1408;2 $$1,0#10431211400427159095818037425705:param]
[a83;*R6 $$2,5#31310162474203024125188417583966:caption]
[H4;b83;*4 $$3,5#07864147445237544204411237157677:title]
[i288;O9;C2 $$4,6#40027414424643823182269349404212:item]
[b42;a42;2 $$5,5#45413000475342174754091244180557:text]
[l288;b17;a17;2 $$6,6#27521748481378242620020725143825:desc]
[l321;C@5;1 $$7,7#20902679421464641399138805415013:code]
[b2503;2 $$8,0#65142375456100023862071332075487:separator]
[*@(0.0.255)2 $$9,0#83433469410354161042741608181528:base]
[C2 $$10,0#37138531426314131251341829483380:class]
[l288;a17;*1 $$11,11#70004532496200323422659154056402:requirement]
[i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam]
[b167;C2 $$13,13#92430459443460461911108080531343:item1]
[i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2]
[*@2$(0.128.128)2 $$15,15#34511555403152284025741354420178:NewsDate]
[l321;*C$7;2 $$16,16#03451589433145915344929335295360:result]
[l321;b83;a83;*C$7;2 $$17,17#07531550463529505371228428965313:result`-line]
[l160;*C+117 $$18,5#88603949442205825958800053222425:package`-title]
[2 $$19,0#53580023442335529039900623488521:gap]
[C2 $$20,20#70211524482531209251820423858195:class`-nested]
[b50;2 $$21,21#03324558446220344731010354752573:Par]
[i448;a25;kKO9;2 $$22,0#37138531426314131252341829483380:class]
[{_}%EN-US 
[s2; Manual / [^topic`:`/`/Kran`/srcdoc`/RS232Thread`$en`-us^ RS232Thread] 
/ Tutorial 3&]
[s0; OK, we start practicing with plain sending and receiving bytes. 
No protocols discussed, no asynchronous difficulties involved.&]
[s0; &]
[s0;a25;kKO9; 1. I just want to send some bytes to remote device.&]
[ {{10000f17;FNg8;GNl8/17r8/17t8/15b8/15@(254.255.232)R(229) [s22;l208;r208;a0;t208;%- [C@(99.0.197) void main()]&]
[s0;l208;r208;t208;%- [C@(99.0.197) `{]&]
[s0;l208;r208;t208;%- [C@(146.104.211) -|][C@(28.170.200) RS232Thread 
rs232;]&]
[s0;l208;r208;t208;%- [C@(28.170.200) -|DCB         dcb;]&]
[s0;l208;r208;t208;%- [C@(28.170.200) -|String      comString `= `"baud`=38400 
to`=on parity`=N data`=8 stop`=1`";]&]
[s0;l208;r208;t208;C@(28.170.200)%- &]
[s0;l208;r208;t208;%- [C@(28.170.200) -|if (!rs232.Open(8))]&]
[s0;l208;r208;t208;%- [C@(28.170.200) -|-|return;]&]
[s0;l208;r208;t208;%- [C@(28.170.200) -|rs232.String2DCB(comString, 
`&dcb); //1.1]&]
[s0;l208;r208;t208;C@(99.0.197)%- &]
[s0;l208;r208;t208;%- [C@(99.0.197) -|RS232Data requestData;]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|requestData.Cat(0x15); //1.2]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|rs232.SetDCB(dcb); //1.3]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|rs232.SendData(requestData); //1.4]&]
[s0;l208;r208;t208;%- [C@(99.0.197) `}]]}}&]
[s0;l256; 1.1 sets up DCB. It was discussed in [^topic`:`/`/Kran`/srcdoc`/Tutorial2`$en`-us^ p
revious Tutorial].&]
[s0;l256; 1.2 creates message to send. RS232Data is a simple String. 
We start with empty string and add 0x15 byte to it. Our message 
for now includes only one byte.&]
[s0;l256; 1.3 Setting connection properties with DCB prepared.&]
[s0;l256; 1.4 Sending our message to port. Synchronous call.&]
[s0; &]
[s0; 2. I``ve sent request message and I want to receive answer message.&]
[s0; Let``s imagine we have remote device which is waiting for request 
byte 0x15 and answers with three bytes of data.&]
[ {{10000f17;FNg8;GNl8/17r8/17t8/15b8/15@(254.255.232)R(229) [s22;l208;r208;a0;t208;%- [C@(99.0.197) void main()]&]
[s0;l208;r208;t208;%- [C@(99.0.197) `{]&]
[s0;l208;r208;t208;%- [C@(146.104.211) -|][C@(28.170.200) RS232Thread 
rs232;]&]
[s0;l208;r208;t208;%- [C@(28.170.200) -|DCB         dcb;]&]
[s0;l208;r208;t208;%- [C@(28.170.200) -|String      comString `= `"baud`=38400 
to`=on parity`=N data`=8 stop`=1`";]&]
[s0;l208;r208;t208;C@(28.170.200)%- &]
[s0;l208;r208;t208;%- [C@(28.170.200) -|if (!rs232.Open(8))]&]
[s0;l208;r208;t208;%- [C@(28.170.200) -|-|return;]&]
[s0;l208;r208;t208;%- [C@(28.170.200) -|rs232.String2DCB(comString, 
`&dcb);]&]
[s0;l208;r208;t208;%- &]
[s0;l208;r208;t208;%- [C@(99.0.197) -|][C@(28.170.200) RS232Data requestData;]&]
[s0;l208;r208;t208;%- [C@(28.170.200) -|requestData.Cat(0x15);]&]
[s0;l208;r208;t208;%- [C@(28.170.200) -|]&]
[s0;l208;r208;t208;%- [C@(28.170.200) -|rs232.SetDCB(dcb);]&]
[s0;l208;r208;t208;%- [C@(28.170.200) -|rs232.SendData(requestData);]&]
[s0;l208;r208;t208;C@(99.0.197)%- &]
[s0;l208;r208;t208;%- [C@(99.0.197) -|RS232Data answerData;]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|if (rs232.ReceiveData(3, `&answerData, 
150)) //1.1]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|`{]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|-|//OK, we just did it!]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|`}]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|else]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|`{]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|-|//Error, we didn``t receive what 
we want]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|`}]&]
[s0;l208;r208;t208;%- [C@(99.0.197) `}]]}}&]
[s0; &]
[s0; The main line here is 1.1. It means: read 3 bytes of data, add 
them to answerData with timeout of 150 milliseconds. Note that 
ReceiveData() is synchronous call. This means that function doesn``t 
return until enough bytes where received or [^topic`:`/`/Kran`/srcdoc`/Tutorial2`$en`-us^ t
imeout reached].&]
[s0; &]
[s0;a25;kKO9; Most of time information received should be parsed. 
For example these three received bytes may be some structure:&]
[ {{10000f17;FNg8;GNl8/17r8/17t8/15b8/15@(254.255.232)R(229) [s0;l208;r208;t208;%- [C@(99.0.197) #pragma pack(push,1)]&]
[s0;l208;r208;t208;%- [C@(99.0.197) struct IOData]&]
[s0;l208;r208;t208;%- [C@(99.0.197) `{]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|BYTE d1;]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|WORD d2;]&]
[s0;l208;r208;t208;%- [C@(99.0.197) `};]&]
[s0;l208;r208;t208;%- [C@(99.0.197) #pragma pack(pop)]]}}&]
[s0; &]
[s0; Note the pragmas are switching off alignment, so the structure 
internal alignment match the answer packet one.&]
[s0; On receiving enough bytes you may simply copy bytes and have 
your IOData filled with information:&]
[ {{10000f17;FNg8;GNl8/17r8/17t8/15b8/15@(254.255.232)R(229) [s0;l208;r208;t208;%- [C@(99.0.197) //...]&]
[s0;l208;r208;t208;%- [C@(99.0.197) IOData ioData;]&]
[s0;l208;r208;t208;%- [C@(99.0.197) if (rs232.ReceiveData(3, `&answerData, 
150))]&]
[s0;l208;r208;t208;%- [C@(99.0.197) `{]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|memcpy(`&ioData, (const char `*)answerData, 
3);]&]
[s0;l208;r208;t208;%- [C@(99.0.197) -|//do some processing]&]
[s0;l208;r208;t208;%- [C@(99.0.197) `}]]}}&]
[s0; &]
[s0; &]
[s0; &]
[s0; ]