topic "Manual / RS232Thread / Tutorial 1";
[2 $$0,0#00000000000000000000000000000000:Default]
[l288;i1120;a17;O9;~~~.1408;2 $$1,0#10431211400427159095818037425705:param]
[a83;*R6 $$2,5#31310162474203024125188417583966:caption]
[H4;b83;*4 $$3,5#07864147445237544204411237157677:title]
[i288;O9;C2 $$4,6#40027414424643823182269349404212:item]
[b42;a42;2 $$5,5#45413000475342174754091244180557:text]
[l288;b17;a17;2 $$6,6#27521748481378242620020725143825:desc]
[l321;C@5;1 $$7,7#20902679421464641399138805415013:code]
[b2503;2 $$8,0#65142375456100023862071332075487:separator]
[*@(0.0.255)2 $$9,0#83433469410354161042741608181528:base]
[C2 $$10,0#37138531426314131251341829483380:class]
[l288;a17;*1 $$11,11#70004532496200323422659154056402:requirement]
[i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam]
[b167;C2 $$13,13#92430459443460461911108080531343:item1]
[i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2]
[*@2$(0.128.128)2 $$15,15#34511555403152284025741354420178:NewsDate]
[l321;*C$7;2 $$16,16#03451589433145915344929335295360:result]
[l321;b83;a83;*C$7;2 $$17,17#07531550463529505371228428965313:result`-line]
[l160;*C+117 $$18,5#88603949442205825958800053222425:package`-title]
[2 $$19,0#53580023442335529039900623488521:gap]
[C2 $$20,20#70211524482531209251820423858195:class`-nested]
[b50;2 $$21,21#03324558446220344731010354752573:Par]
[i448;a25;kKO9;2 $$22,0#37138531426314131252341829483380:class]
[{_} 
[s2;%% Manual / [^topic`:`/`/Kran`/srcdoc`/RS232Thread`$en`-us^ RS232Thread] 
/ Tutorial 1&]
[s0;a25;kKO9; &]
[s0;a25;kKO9; The simplest task is creating RS232Thread object and 
initializing it.&]
[ {{10000f17;FNg8;GNl8/17r8/17t8/15b8/15@(254.255.232)R(229) [s22;l208;r208;a0;t208; [C@(99.0.197) void main()]&]
[s0;l208;r208;t208; [C@(99.0.197) `{]&]
[s0;l208;r208;t208; [C@(99.0.197) -|RS232Thread rs232; //1.1]&]
[s0;l208;r208;t208; [C@(99.0.197) -|if (!rs232.Open(8)) //1.2]&]
[s0;l208;r208;t208; [C@(99.0.197) -|-|return;]&]
[s0;l208;r208;t208; [C@(99.0.197) -|]&]
[s0;l208;r208;t208; [C@(99.0.197) -|rs232.RequestFinish(); //1.3]&]
[s0;l208;r208;t208; [C@(99.0.197) -|rs232.WaitFinished(); //1.4]&]
[s0;l208;r208;t208; [C@(99.0.197) `}]]}}&]
[s0; &]
[s0;l256; 1.1 Creates rs232 object. Note that destructor here is 
invoked implicitly, so port is closed automatically on program 
exit.&]
[s0;l256; &]
[s0;l256; 1.2 Tries to open COM8 device. Simplest part to use.&]
[s0;l256; &]
[s0;l256; 1.3 Signals RS232Thread that it should shutdown any i/o 
after completing it``s current task from queue. You must call 
it every time you shutdown your application if you use any asynchronous 
calls to RS232Thread object.&]
[s0;l256; &]
[s0;l256; 1.4 Waits for last task to finish and returns.  Note that 
this function may force application to hang`-up in a period of 
serial port timeout which will be discussed below.&]
[s0; &]
[s0; It``s a simplest way of shutting down. In real`-world application 
it is not necessary to make simple synchronous wait in a main 
thread. If you use big timeouts and want your program to be completely 
asynchronous even on shutting down, consider using rs232.IsFinished() 
member function.&]
[s0; &]
[s0; [*/ Why should we pay much attention to proper shutting down?]&]
[s0; Completing task queue is important because we want to avoid 
any garbage in line between PC and device attached to  COM`-port. 
Imagine we send request to the device and close the program immediately. 
The device answers and this answer will be placed by operating 
system into it``s internal i/o buffer. Next time you start program 
and open port, then send request to the device. You have a chance 
of first reading this old garbage answer, not the current answer 
(if OS driver doesn``t clear buffer on re`-opening device). OK, 
you may clear it manually on start, but there is a bigger problem 
with it...&]
[s0; &]
[s0; The bigger problem is appeared when your attached device has 
rather long answer time. Imagine you close program which has 
just requested something from device. After that you start program 
once more `- while your device is still answering your old request. 
And what do we have? Yes, garbage. Undeletable and unsearchable 
with debug. This garbage leads to total desyncronyzation between 
your program and device.&]
[s0; &]
[s0; The [* only ]way to ensure successful work with remote devices 
is to wait for the answers after sending request. Even if your 
program is trying to shutdown.&]
[s0; Rule is simple:&]
[s0;= [*c+92 proper shutdown makes life easy]&]
[s0; &]
[s0; Of course, there is a timeout `- this guarantees your program 
won``t hang up forever if device is off or physical link to device 
is broken.&]
[s0; &]
[s0; &]
[s0; ]