topic "Manual / RS232Thread / Tutorial 4";
[2 $$0,0#00000000000000000000000000000000:Default]
[l288;i1120;a17;O9;~~~.1408;2 $$1,0#10431211400427159095818037425705:param]
[a83;*R6 $$2,5#31310162474203024125188417583966:caption]
[H4;b83;*4 $$3,5#07864147445237544204411237157677:title]
[i288;O9;C2 $$4,6#40027414424643823182269349404212:item]
[b42;a42;2 $$5,5#45413000475342174754091244180557:text]
[l288;b17;a17;2 $$6,6#27521748481378242620020725143825:desc]
[l321;C@5;1 $$7,7#20902679421464641399138805415013:code]
[b2503;2 $$8,0#65142375456100023862071332075487:separator]
[*@(0.0.255)2 $$9,0#83433469410354161042741608181528:base]
[C2 $$10,0#37138531426314131251341829483380:class]
[l288;a17;*1 $$11,11#70004532496200323422659154056402:requirement]
[i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam]
[b167;C2 $$13,13#92430459443460461911108080531343:item1]
[i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2]
[*@2$(0.128.128)2 $$15,15#34511555403152284025741354420178:NewsDate]
[l321;*C$7;2 $$16,16#03451589433145915344929335295360:result]
[l321;b83;a83;*C$7;2 $$17,17#07531550463529505371228428965313:result`-line]
[l160;*C+117 $$18,5#88603949442205825958800053222425:package`-title]
[2 $$19,0#53580023442335529039900623488521:gap]
[C2 $$20,20#70211524482531209251820423858195:class`-nested]
[b50;2 $$21,21#03324558446220344731010354752573:Par]
[i448;a25;kKO9;2 $$22,0#37138531426314131252341829483380:class]
[{_}%EN-US 
[s2; Manual / [^topic`:`/`/Kran`/srcdoc`/RS232Thread`$en`-us^ RS232Thread] 
/ Tutorial 4&]
[s0; &]
[s0; Now we``ve learned simple i/o operations. They would work perfectly 
in ideal world where we``d had loseless connection line and flawless 
synchronization. The real world has it``s specifics:&]
[s0;l160;i150;O1; Signal cross talk (you send 0x15 but 0x1F is received)&]
[s0;l160;i150;O1; Physical connection problems (cord was temporary 
and partially unplugged)&]
[s0;l160;i150;O1; Some old garbage in the input buffer&]
[s0;l160;i150;O1; Long`-line signal echo&]
[s0;l160;i150;O1; ...&]
[s0; Sometimes you have all these effects working together. The truth 
is that real world RS232 connection is like bad postman: you get 
your mail dirty and sometimes damaged. And you have to clear 
it, recover, or deny and ask mailing again.&]
[s0; &]
[s0; Through the years programmers developed a number of techniques 
to help solving any connection problems. The messages which devices 
exchange with are usually called packets. To make packet more 
stable they usually use sign of packet start (also usually referenced 
as start or packet marker). It is one or more bytes which are 
rarely or never met in packet body. The packet length is usually 
well known. With these start bytes you almost always know where 
packet is and where the garbage is.&]
[s0; &]
[s0; The second technique is called CRC. This technique guarantees 
that no bytes from the packet were damaged during transmission. 
The idea is simple: you create 1, 2 or 4`-byte integer variable. 
In the beginning it equals 0 or some other number. For each packet 
byte you add some number to your variable. This number depends 
on i`-th packet byte. This variable is transmitted right after 
the packet. When the packet is received, other side device makes 
the same calculation for received bytes and compares them with 
transmitted CRC value. If CRC received is unequal to the one 
calculated from transmitted bytes, packet is considered damaged 
and Master makes the same request again. The usual practice is 
sending a limited number of repeated requests. If all attempts 
failed, Master``s software notifies user about critical connection 
error.&]
[s0; &]
[s0; For simple cases 1`-byte start sign and plain CRC8 is enough. 
But advanced industrial protocols require both complex start 
sign and complex CRC calculations for each packet. This is a 
payment for real world data exchange.&]
[s0; &]
[s0; You must consider using more advanced technique when working 
as Master with real world i/o:&]
[s0; 0. Send request to Slave.&]
[s0; 1. Receive minimum number of bytes your packet resides (if packet 
may have different length).&]
[s0; -|1.1 On timeout, clear the buffer and start (1) again.&]
[s0; -|1.2 On successful receive, goto 2.&]
[s0; 2. Find start sign. Delete all the garbage from buffer before 
start sign.&]
[s0; 3. Analyze packet type and calculate it``s length&]
[s0; 4. Receive remaining bytes &]
[s0; -|4.1 On timeout, clear buffer and start (1) again&]
[s0; -|4.2 On success, goto (5)&]
[s0; 5. Calculate CRC from received bytes. Compare it to the CRC 
received.&]
[s0; -|5.1 CRC is wrong. Did we try re`-requesting enough times?&]
[s0; -|-|5.1.1 Yes. Switch to critical error condition&]
[s0; -|-|5.1.2 No, trying again. Start with (0).&]
[s0; -|5.2 CRC is equal to the one received. Request/Answer where 
a success.&]
[s0; &]
[s0; This algorithm along with good chosen timeout give you almost 
absolutely stable i/o process which will work throughout the 
years without fails and desynchronization.&]
[s0; &]
[s0; &]
[s0; &]
[s0; ]