topic "Manual / RS232Thread / Tutorial 2";
[2 $$0,0#00000000000000000000000000000000:Default]
[l288;i1120;a17;O9;~~~.1408;2 $$1,0#10431211400427159095818037425705:param]
[a83;*R6 $$2,5#31310162474203024125188417583966:caption]
[H4;b83;*4 $$3,5#07864147445237544204411237157677:title]
[i288;O9;C2 $$4,6#40027414424643823182269349404212:item]
[b42;a42;2 $$5,5#45413000475342174754091244180557:text]
[l288;b17;a17;2 $$6,6#27521748481378242620020725143825:desc]
[l321;C@5;1 $$7,7#20902679421464641399138805415013:code]
[b2503;2 $$8,0#65142375456100023862071332075487:separator]
[*@(0.0.255)2 $$9,0#83433469410354161042741608181528:base]
[C2 $$10,0#37138531426314131251341829483380:class]
[l288;a17;*1 $$11,11#70004532496200323422659154056402:requirement]
[i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam]
[b167;C2 $$13,13#92430459443460461911108080531343:item1]
[i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2]
[*@2$(0.128.128)2 $$15,15#34511555403152284025741354420178:NewsDate]
[l321;*C$7;2 $$16,16#03451589433145915344929335295360:result]
[l321;b83;a83;*C$7;2 $$17,17#07531550463529505371228428965313:result`-line]
[l160;*C+117 $$18,5#88603949442205825958800053222425:package`-title]
[2 $$19,0#53580023442335529039900623488521:gap]
[C2 $$20,20#70211524482531209251820423858195:class`-nested]
[b50;2 $$21,21#03324558446220344731010354752573:Par]
[i448;a25;kKO9;2 $$22,0#37138531426314131252341829483380:class]
[{_} 
[s2;%% Manual / [^topic`:`/`/Kran`/srcdoc`/RS232Thread`$en`-us^ RS232Thread] 
/ Tutorial 2&]
[s0;i448;a25;kKO9; [*/ Connection parameters]&]
[s0;a25;kKO9; Before we start sending something to COM`-port we should 
set up connection properties. RS232 port has a number of major 
properties. If you forget any of them, i/o will have no success:&]
[s0;l160;i150;a25;kKO2; Baud rate. Connection speed in symbols per 
second. Typical values are: 9600, 14400, 19200, 38400, 57600 and 
115200.&]
[s0;l160;i150;a25;kKO2; Parity. Values: None, Odd, Even.&]
[s0;l160;i150;a25;kKO2; Data bits. Values: 8, 7, 6.&]
[s0;l160;i150;a25;kKO2; Stop bits. Values: 1, 1.5, 2.&]
[s0;a25;kKO9; &]
[s0;a25;kKO9; Both computer and remote device switch ther own RS232 
ports to physical states according to properties above. For i/o 
to work properly, both PC and device should have their ports 
switched to equal states. Most of time you read device`` manual 
to know connection parameter values of the device and set up 
them for your PC port to match device port.&]
[s0;a25;kKO9; &]
[s0;a25;kKO9; Windows has it``s specific structure called DCB which 
holds complete set of RS232 port connection properties. RS232Thread 
uses it too. But to make things easier, class has routine to 
create DCB values from configuration string. Look at this simple 
code:&]
[ {{10000f17;FNg8;GNl8/17r8/17t8/15b8/15@(254.255.232)R(229) [s22;l208;r208;a0;t208; [C@(99.0.197) void main()]&]
[s0;l208;r208;t208; [C@(99.0.197) `{]&]
[s0;l208;r208;t208; [C@(99.0.197) -|DCB dcb;]&]
[s0;l208;r208;t208; [C@(99.0.197) -|String comString `= `"baud`=38400 
to`=on parity`=N data`=8 stop`=1`";]&]
[s0;l208;r208;t208;C@(99.0.197) &]
[s0;l208;r208;t208; [C@(99.0.197) -|rs232.String2DCB(comString, `&dcb);]&]
[s0;l208;r208;t208; [C@(99.0.197) `}]]}}&]
[s0; &]
[s0;l256; It creates DCB structure for baudrate`=38400, no parity 
and one stop bit. This is the recommended way of setting these 
properties. One thing it sets besides of discussed things is 
`"to`-on`" part. The thing it does is switching on timeouts for 
the port.&]
[s0; &]
[s0; You must always remember to set timeouts on and think of them 
while developing i/o processing code.&]
[s0; &]
[s0; [*/ Timeouts]&]
[s0; Timeout is amount of time which is, when finished, makes caller 
think that remote operation is failed.&]
[s0; &]
[s0; Write timeout is period of time for bytes to be sent into RS232 
port. Author never met the situation when this timeout made sense. 
Theoretically, it might happen when RS232 chip is physically 
damaged.&]
[s0; &]
[s0; Contrary, read timeout is a practical thing you use each time 
you send request to remote device. This is amount of time you 
spend waiting for device answer to arrive. All the timeouts discussion 
below is about read timeouts.&]
[s0; &]
[s0; The most important thing about timeouts is:&]
[s0;= [*c they must always be switched on]&]
[s0;= [*c they must be non`-zero]&]
[s0; &]
[s0; Without them you create possibility of deadlock. Remote device 
is a tricky thing which may be switched off, or be disconnected, 
or one of million possibilities when you have no answer on your 
request.&]
[s0; Most of automation devices answer within (n`*10, n`*100) milliseconds 
and you must consider it when thinking what timeout you should 
set.&]
[s0; &]
[s0; You must also consider time for RS232 line to send/receive bytes 
on your current connection speed, as well as you should keep 
in mind potential time for these bytes to be processed by RS232 
driver. This means that your timeout must always be [* greater 
]than `"pure`" remote device timeout. All this internal PC processing 
takes about 15 milliseconds on Pentium II class machines.&]
[s0; &]
[s0; Non`-zero and activated timeouts are required for normal operation 
of RS232Thread class. Defining timeouts in RS232Thread class 
is very simple which is shown in the next Tutorial.&]
[s0; &]
[s0; OK. There is the last thing before we may start moving to practice 
in our tutorial:&]
[s0; &]
[s0; [*/ Master and slave devices]&]
[s0; RS232 line has it``s limitations. While one device sends data, 
other should receive. Situation when both devices try to send 
their bytes through port simultaneously, transforms all these 
bytes into garbage. &]
[s0; &]
[s0; Through the years people thought of solving this problem. And 
it led to a practice to divide all RS232 devices into Masters 
and Slaves. This has nothing to do with physical ports or their 
connection properties. It is purely an agreement between programmers 
using some protocol and devices. &]
[s0; &]
[s0; Master is always an active device. It sends data and awaits 
for Slave to answer.&]
[s0; Slave is a passive device. It NEVER starts sending anything 
if it is not asked to by Master.&]
[s0; Typical i/o operations are divided into 2 steps:&]
[s0;l160;i150;O3; Master sends request&]
[s0;l160;i150;O3; Slave answers&]
[s0; And each RS232 protocol (protocol is nothing more than simple 
agreement too) has two types of messages: request message and 
answer message. Answer message is typically an ordinary information 
message or an error message.&]
[s0; &]
[s0; In most of cases PC is a Master and remote device as a Slave. 
This guarantees that remote device will never mess your request 
message. In some cases the protocol is more complex and suggests 
a number of events when Master becomes Slave and Slave becomes 
Master. ANY protocol has only one Master simultaneously.&]
[s0; &]
[s0; &]
[s0; ]