#include <CtrlLib/CtrlLib.h>

using namespace Upp;

struct CDispVal : Moveable<CDispVal>
{
	String 	m_sName;
	PaintRect m_cPR;
	
	CDispVal() {}
	CDispVal(String sName, const Display& Display, Value val) :
		m_sName(sName), m_cPR(Display, val) {  }
	
	PaintRect& GetPaintRect() { return m_cPR; }
};


class StdFittedTextDisplayCls : public Display {
public:
	int GetTLLines(const wchar *s) const
	{
		int h=1;
		while(*s) {
			if(*s == '\n')
				h++;
			s++;
		}
		return h;
	}
	
	virtual void Paint(Draw& w, const Rect& r, const Value& q,
		               Color ink, Color paper, dword style) const
	{
		WString txt = (WString)q;
		Size tsz = GetTLTextSize(txt, StdFont());
		int lines = GetTLLines(txt);

		Size sz = GetFitSize(tsz, r.Size());
		Point p = r.CenterPos(sz);

		w.DrawRect(r, paper);

		int iSize = (double)sz.cy / lines / StdFont().Info().GetHeight() * StdFont().Info().GetFontHeight();

		DrawTLText(w, p.x, p.y, r.Width(), txt, StdFont().Height(iSize), ink);
	}
	
	virtual Size RatioSize(const Value& q, int cx, int cy) const
	{
		Size sz = GetTLTextSize((WString)q, StdFont());
		return GetFitSize( sz, cx, cy);
	}
	
	virtual Size GetStdSize(const Value& q) const
	{
		return GetTLTextSize((WString)q, StdFont());;
	}
};


class MineFittedImageDisplayCls : public Display {
public:
	virtual void Paint(Draw& w, const Rect& r, const Value& q,
		               Color ink, Color paper, dword style) const
	{
		w.DrawRect(r, paper);
		Image m = q;
		if(!IsNull(m)) {
			Size sz = GetFitSize(m.GetSize(), r.Size());
			Point p = r.CenterPos(sz);
			w.DrawImage(p.x, p.y, sz.cx, sz.cy, m);
		}
	}
	virtual Size GetStdSize(const Value& q) const
	{
		return Image(q).GetSize();
	}
};

typedef Vector<CDispVal> TDispVect;

class DispMain : public TopWindow
{
protected:
	DisplayCtrl m_cDisplay;
	TDispVect 	m_vDisp;
	int 		m_iAct;

public:
	typedef DispMain CLASSNAME;

	DispMain()
	{
		m_vDisp.Add( CDispVal("StdFittedTextDisplayCls", Single<StdFittedTextDisplayCls>(), "StdFittedTextDisplayCls" ));
		m_vDisp.Add( CDispVal("StdFittedTextDisplayCls - 3 lines", Single<StdFittedTextDisplayCls>(), "1) line\n2) line...\n.." ));
		m_vDisp.Add( CDispVal("MineFittedImageDisplayCls", Single<MineFittedImageDisplayCls>(), CtrlImg::Get(1) ));
		
		m_vDisp.Add( CDispVal("StdDisplay", StdDisplay(), "StdDisplay" ));
		m_vDisp.Add( CDispVal("StdCenterDisplay", StdCenterDisplay(), "StdCenterDisplay" ));
		m_vDisp.Add( CDispVal("StdRightDisplay", StdRightDisplay(), "StdRightDisplay" ));
		m_vDisp.Add( CDispVal("SizeTextDisplay", SizeTextDisplay(), "SizeTextDisplay" ));
		            
		m_vDisp.Add( CDispVal("ColorDisplay", ColorDisplay(), Green()) );
		m_vDisp.Add( CDispVal("ImageDisplay", ImageDisplay(), CtrlImg::Get(1) ));
		m_vDisp.Add( CDispVal("FittedImageDisplay", FittedImageDisplay(), CtrlImg::Get(1) ));
		m_vDisp.Add( CDispVal("CenteredImageDisplay", CenteredImageDisplay(), CtrlImg::Get(1) ));
		m_vDisp.Add( CDispVal("CenteredHighlightImageDisplay", CenteredHighlightImageDisplay(), CtrlImg::Get(1) ));
	
		DrawingDraw iw(200, 200);
		iw.DrawRect(iw.GetSize(), White());
		iw.DrawEllipse(10, 10, 180, 100, Cyan());
		iw.DrawImage(100, 100, CtrlImg::exclamation());
		iw.DrawRect(20, 100, 30, 30, Blue);
		Drawing dw = iw;

		m_vDisp.Add( CDispVal("DrawingDisplay", DrawingDisplay(), dw) );
				
		SetRect(0,0,200,200);
		Sizeable();
		
		m_iAct = -1;
		
		Background(PaintRect(StdCenterDisplay(), "Right click to change Display"));
	}

	void Select(int i)
	{
		m_iAct = i;
		Background(m_vDisp[i].GetPaintRect());
	}
	
	void CreateMenu(Bar& bar)
	{
		for(int i=0; i< m_vDisp.GetCount(); i++)
		{
			bar.Add(m_vDisp[i].m_sName, THISBACK1( Select, i) ).Radio(m_iAct == i);
		}
	}
	
	virtual void RightDown(Point p, dword keyflags)
	{
		MenuBar menu;
		CreateMenu(menu);
		menu.Execute();
	}
}; 

GUI_APP_MAIN
{
	DispMain().Run();
}
