topic "UCLAP Example Argument Definitions";
[2 $$0,0#00000000000000000000000000000000:Default]
[l288;i1120;a17;O9;~~~.1408;2 $$1,0#10431211400427159095818037425705:param]
[a83;*R6 $$2,5#31310162474203024125188417583966:caption]
[b83;a17;*/2 $$3,5#07864147445237544204411237157677:title]
[i288;O9;C2 $$4,6#40027414424643823182269349404212:item]
[l42;b25;a8;2 $$5,5#45413000475342174754091244180557:text]
[l288;b17;a17;2 $$6,6#27521748481378242620020725143825:desc]
[l42;b17;a17;t246;C@5;1 $$7,7#20902679421464641399138805415013:code]
[b2503;2 $$8,0#65142375456100023862071332075487:separator]
[*@(0.0.255)2 $$9,0#83433469410354161042741608181528:base]
[t4167;C2 $$10,0#37138531426314131251341829483380:class]
[l288;a17;*1 $$11,11#70004532496200323422659154056402:requirement]
[i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam]
[b167;C2 $$13,13#92430459443460461911108080531343:item1]
[i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2]
[*@2$(0.128.128)2 $$15,15#34511555403152284025741354420178:NewsDate]
[l321;*C$7;2 $$16,16#03451589433145915344929335295360:result]
[l321;b83;a83;*C$7;2 $$17,17#07531550463529505371228428965313:result`-line]
[l160;t4167;*C+117 $$18,5#88603949442205825958800053222425:package`-title]
[2 $$19,0#53580023442335529039900623488521:gap]
[t4167;C2 $$20,20#70211524482531209251820423858195:class`-nested]
[b50;2 $$21,21#03324558446220344731010354752573:Par]
[l42;b42;a42;2 $$22,22#52634335403051822273016904505455:text`-spaced]
[l42;b4;a4;O0;2 $$23,23#48755833838532114550230331832354:text`-spaced`-bulleted]
[{_}%EN-US 
[s3; [3 UCLAP Example Argument Definitions (and what they mean)]&]
[s5; First, note that the expected command line always looks like 
this:&]
[s5; [C@5 MyProgramExecutable `[OPTIONS`] `[ARGUMENTS`]]&]
[s5; Where:&]
[s5; -|OPTIONS is an unordered list of command line options specified 
by delimiters and flags&]
[s5; -|ARGUMENTS is an ordered list of arguments that come after the 
OPTIONS&]
[s22; [*/3 Argument Examples:]&]
[s7; Option<String> mystring (`"StringInput`", `"Just a string.`");&]
[s5; The Option [C mystring ]is expecting an argument of type String.&]
[s5; Because they are not specified explicitly, the short and long 
flags are automatically generated from the title. The short flag 
is `"s`" and the long flag is `"stringinput`". &]
[s5; If the default delimiters are kept, the expected command line 
arguments will look like:&]
[s5; -|[C `-s `"my string input`"]&]
[s5; or&]
[s5; -|[C `-`-stringinput `"my string input`"]&]
[s5; This option is not required.&]
[s7; &]
[s7; Option<int> a`_number (`"i`", `"int`", `"Integer`", `"An integer.`", 
true);&]
[s5; The Option [C a`_number] is expecting an integer, and it will 
attempt to convert the String from the command line into an integer.&]
[s5; The flags are explicitly specified where the short flag is `"i`" 
and the long flag is `"int`". &]
[s5; This option is required; any argument set with this Option will 
fail to match if the user does not specify this argument on the 
command line.&]
[s5; The expected text on the command line is `"`-i <number>`" or 
`"`-`-int <number>`" (if the default delimiters of dash and double`-dash 
are kept).&]
[s7; &]
[s7; Option<bool> numbers`_option (`"Numbers`", `"If this switch 
is specified, the program will expect a list of integers as arguments.`", 
true);&]
[s5; The Option [C numbers`_option ]is not expecting any value. It 
should be specified alone. &]
[s5; Its flags will automatically be generated based on the title 
`"Numbers`". So the short flag will be `"n`" and the long flag 
will be `"numbers`". If the default delilmiters are kept, this 
should be specified on the command line like `"`-n`" and `"`-`-numbers`". 
&]
[s5; This argument is required and the arg set it is added to will 
not match unless it is specified.&]
[s5; &]
[s7; MultiOption<bool> verbosity (`"V`", `"verbose`", `"Verbosity`", 
`"Define how verbose the output should be.`", false, 1, 3);&]
[s5; If the default delimiters are kept, the Option [C verbosity ]is 
specified using `"`-V`" or `"`-`-verbose`" on the command line. 
&]
[s5; It is not a required option.&]
[s5; It can only be specified 1 to 3 times. If it is specified more 
than 3 times, the argument set that this argument is added to 
will not match. &]
[s5; &]
[s7; Arg<int> arg`_int (`"Integer`", `"An Integer`", true);&]
[s5; The Argument arg`_int is expecting an integer value and will 
try to convert the value from the command line into an integer. 
If it cannot convert the value specified on the command line 
into an integer, then any arument set that this argument belongs 
to will fail to match.&]
[s5; This argument is requried. It can only be specified once.&]
[s5; &]
[s7; MultiArg<String> many`_strings (`"String`", `"A list of strings`");&]
[s5; This Argument is expecting any number of sequential strings. 
All strings in sequence will be added to the argument`'s Vector 
of values. &]
[s5; It is not required (the constructor argument is not specified)&]
[s5; By default MultiArg accepts 1 to any number of sequential values.&]
[s5; &]
[s7; MultiArg<double> a`_few`_doubles (`"Number`", `"A list of numbers.`", 
true, 1, 5);&]
[s5; This Argument is expecting 1 to 5 sequential doubles. &]
[s5; If more than 5 double are specified, any argument set that this 
argument is added to will fail to match.&]
[s5; It is required (so if no doubles are specified, then it will 
cause a failed match).&]
[s5; &]
[s5; [/ Note: Arg<bool> and MultiArg<bool> doesn`'t make any sense, 
so we don`'t use it!]&]
[s5;/ &]
[s22; [*/3 Adding Arguments to Argument Sets:]&]
[s7; ArgProcessor ap (`"Numbers or Strings`", `"1.0`");&]
[s7; Option<bool> numbers`_option (`"Numbers`", `"If this switch 
is specified, the program will expect a list of integers as arguments.`", 
true);&]
[s7; MultiArg<int> many`_ints (`"Integer`", `"A list of numbers (integers)`");&]
[s7; Option<bool> strings`_option (`"Strings`", `"If this switch 
is specified, the program will expect a list of strings as arguments.`", 
true);&]
[s7; MultiArg<String> many`_strings (`"String`", `"A list of strings`");&]
[s7; ArgSet set`_for`_strings, set`_for`_numbers, default;&]
[s7; set`_for`_strings << strings`_option << many`_strings;&]
[s7; set`_for`_numbers << numbers`_option << many`_ints;&]
[s7; default << many`_strings;&]
[s7; ap << set`_for`_strings << set`_for`_numbers << default;&]
[s5; &]
[s5; If the user just specifies `"`-s`" or `"`-`-strings`", then 
the program will only expect a list of strings. &]
[s5; If the user specifies `"`-n`" or `"`-`-numbers`", then the program 
will only expect a list of integers.&]
[s5; If the user does not explicitly specify `"`-s`" or `"`-n`", 
then the program will assume that the input is a list of strings 
and argument set [C default] will match.&]
[s5; The ArgProcessor knows how to tell the difference between the 
two sets because the numbers`_option is required. &]
[s5; &]
[s5; &]
[s0; ]