topic "UCLAP Usage Tutorial";
[2 $$0,0#00000000000000000000000000000000:Default]
[l288;i1120;a17;O9;~~~.1408;2 $$1,0#10431211400427159095818037425705:param]
[a83;*R6 $$2,5#31310162474203024125188417583966:caption]
[b83;a17;*/2 $$3,5#07864147445237544204411237157677:title]
[i288;O9;C2 $$4,6#40027414424643823182269349404212:item]
[l42;b25;a8;2 $$5,5#45413000475342174754091244180557:text]
[l288;b17;a17;2 $$6,6#27521748481378242620020725143825:desc]
[l321;t246;C@5;1 $$7,7#20902679421464641399138805415013:code]
[b2503;2 $$8,0#65142375456100023862071332075487:separator]
[*@(0.0.255)2 $$9,0#83433469410354161042741608181528:base]
[t4167;C2 $$10,0#37138531426314131251341829483380:class]
[l288;a17;*1 $$11,11#70004532496200323422659154056402:requirement]
[i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam]
[b167;C2 $$13,13#92430459443460461911108080531343:item1]
[i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2]
[*@2$(0.128.128)2 $$15,15#34511555403152284025741354420178:NewsDate]
[l321;*C$7;2 $$16,16#03451589433145915344929335295360:result]
[l321;b83;a83;*C$7;2 $$17,17#07531550463529505371228428965313:result`-line]
[l160;t4167;*C+117 $$18,5#88603949442205825958800053222425:package`-title]
[2 $$19,0#53580023442335529039900623488521:gap]
[t4167;C2 $$20,20#70211524482531209251820423858195:class`-nested]
[b50;2 $$21,21#03324558446220344731010354752573:Par]
[l42;b42;a42;2 $$22,22#52634335403051822273016904505455:text`-spaced]
[l42;b4;a4;O0;2 $$23,23#48755833838532114550230331832354:text`-spaced`-bulleted]
[{_}%EN-US 
[s0; [+117 U`+`+ Command Line Argument Processor]&]
[s0; [*3 Usage Tutorial]&]
[s3; General Code Seqence&]
[s5; Steps:&]
[s5; 1. Define an instance of the ArgProcessor class and give it 
the name/title and version of your program.&]
[s5; 2. Define options and arguments and their constraints.&]
[s22; Note: The argument processor deals only with pointers, so you 
must construct the argument before adding it to the ArgSet; the 
arguments and argument sets are not copied over like they are 
when you add them to a Vector or other container. &]
[s22; Other things to consider when creating an option or argument 
include&]
[s23;    Is the argument required? (does it have to be specified on 
the command line?)&]
[s23;    What is its multiplicity? (how many times can you specify 
it?)&]
[s0; -|`-> applies to MultiArg and MultiOption&]
[s23;   If it is an Option, does its flag conflict with `"h`", `"help`", 
`"v`", or `"version`" pre`-defined flags?&]
[s0; -|`-> arguments are case`-sensitive, so `"H`" and `"V`" are free 
to specify.&]
[s0; &]
[s5; 3. Define the argument sets. Each argument set (ArgSet) should 
represent a unique combination of arguments.&]
[s5; If there is a common set of arguments that you want always to 
be available, create an ArgSet for them, and add that ArgSet 
to all of the other argument sets that you create. &]
[s5; 4. Add all argument sets to the argument processor instance.&]
[s5; 5. Process the command line (Call the ProcessCmdLine function 
and pass it the command line Vector).&]
[s5; Miscellaneous steps (but probably what you want to happen):&]
[s5; 6. Check to see if the specified command line matched any of 
your argument sets.&]
[s5; 7. If so, check to see which one.&]
[s5; 8. Extract data from the arguments that are a part of the matching 
argument set.&]
[s5; 9. If there was no match or the argument processor has an error, 
respond to the user letting them know that they called the program 
incorrectly.&]
[s3; Defining Arguments&]
[s22; The main class to instantiate is the [C ArgProcessor ]class. You 
need one instance of this class to pass the command line arguments 
to. You instantiate it with the program`'s title and version.&]
[s7; ArgProcessor ap(`"My Program`", `"0.1`");&]
[s22; Arguments are defined using 4 classes, Option[C ,] [C MultiOption, 
Arg, and MultiArg]. They are templated and you define the type 
of input you expect them to accept. &]
[s7; Option<int> integer`_arg(`"n`", `"number`", `"Number`", `"Number 
for input.`");&]
[s7; Option<bool> switch`_arg(`"s`", `"switch`", `"Switch Argument`", 
`"This is a switch argument.`");&]
[s7; MultiArg<String> string`_arg(`"Filename`", `"Filename of input 
file (required).`", true)&]
[s3; Options vs Base Arguments&]
[s5; An option is one specified by a delimiter (usually dash `"`-`" 
or double`-dash `"`-`-`"). A base argument is any argument specified 
without delimiters just on the command line. Example: the [* tail] 
program output the last few lines of a file.&]
[s6; [R tail `-n 3 myfile]&]
[s5; `-n is an option (delmited argument) whose value is 3.&]
[s5; myfile is a normal argument.&]
[s3; Argument Types and U`+`+ Value Type&]
[s5; UCLAP relies on U`+`+`'s [^topic`:`/`/Core`/srcdoc`/CoreTutorial`$en`-us^ Value] 
type. The arguments received are parsed into Value types and 
it detects if there is bad input if the argument values are not 
able to be properly converted into that Value type.&]
[s5; For example, [C Arg<int>] will convert all values from strings 
to integers.&]
[s3; Special Case: The Switch Argument&]
[s5; Options with boolean types are considered switches and do not 
take a value as input. You define this type like: [C Option<bool>] 
or [C MultiOption<bool>].&]
[s5; Example Usage:&]
[s7; Option<bool> switch`_arg(`"s`", `"switch`", `"Switch Argument`", 
`"This is a switch argument.`");&]
[s5; On the command line, it would expect `"`-s`" with no value afterwards.&]
[s3; Multiplicity: Specifying Arguments Multiple Times&]
[s5; The MutiOption and MultiArg types are used to be able to specify 
the argument multiple times. &]
[s5; Example:&]
[s7; MultiOption<String> multi`_opt(`"m`", `"multiple`", `"StringInput`", 
`"This argument can be specified numerous times`", false);&]
[s5; This allows you to specify `'[C `-m <string>]`' on the command 
line multiple times. &]
[s5; For example:&]
[s0; [R -|MyProgram `-m `"first string`" `-m `"second string`"]&]
[s5; It inherits from the Vector class so the values can be referenced 
just like a Vector:&]
[s7; if(multi`_opt.IsSet())&]
[s7; `{&]
[s7; -|for(int i`=0; i<multi`_opt.GetCount(); i`+`+)&]
[s7; -|`{&]
[s7; -|-|Cout() << `"MultiOption value: `" << multi`_opt`[i`] << `"`\n`";&]
[s7; -|`}&]
[s7; `}&]
[s5; When using a [* MultiOption ]with type bool, the argument becomes 
a switch, and the values of the arguments are all set to true; 
when another switch is found, it adds a true value to the Vector 
for that MultiOption. The real value comes from the number of 
times that argument was specified. For example, you may have 
a verbosity setting, and the number of times `"`-`-verbose`" 
or `"`-V`" is specified on the command line, the more verbose 
the output is. &]
[s3; Default Switches: Help/Usage, and Version Information&]
[s5; By default, the short/long options `"h`"/`"help`" and `"v`"/`"version`" 
will, respectfully, print usage information and version information 
to the command line (Cout). You can change the output stream 
using ArgProcessor`'s [C^topic`:`/`/CmdLineArgProcessor`/src`/ArgProcessor`$en`-us`#`:`:ArgProcessor`:`:PrintToStream`(`:`:Stream`&`)^ P
rintToStream] class method.&]
[s3; Option Flag Delimiters&]
[s5; By default, the option flags are a dash character (`"`-`") for 
short form and double`-dash string (`"`-`-`") for long form. 
Thus, you can specify `"`-h`" or `"`-`-help`" on the command 
line to show usage information. These characters are cusomizable 
through the use of the ArgProcessor`'s [C^topic`:`/`/CmdLineArgProcessor`/src`/ArgProcessor`$en`-us`#`:`:ArgProcessor`:`:SetArgDelim`(`:`:String`,`:`:String`)^ S
etArgDelim] class method. &]
[s5; Note: The one limitation right now is that you cannot use the 
same delimiter for both short and long options. &]
[s0; &]
[s0; ]