#ifndef UPP_CMDLINEARGPROCESSOR_ARGSET_HPP
#define UPP_CMDLINEARGPROCESSOR_ARGSET_HPP

#include <Core/Core.h>
#include <CmdLineArgProcessor/TArgument.hpp>

using namespace Upp;

/**
An ArgSet is a set of arguments that go together; it represents combinations of arguments.
*/
class ArgSet : public Pte<ArgSet>
{
	friend class ArgProcessor;	// <-- So it can loop through argument lists to assign values and print usage information.
	protected:
		Vector< Ptr<TOption> > _options;
		Vector< Ptr<TArg> > _base_args;
		bool _is_match;
		
		bool HasBaseArg(TArg & tbarg)
		{
			for(int i=0; i<_base_args.GetCount(); i++)
			{
				if(_base_args[i]==&tbarg)
				{
					return true;
				}
			}
			return false;
		};
		
		bool HasOption(TOption & topt)
		{
			for(int i=0; i<_options.GetCount(); i++)
			{
				if(_options[i]==&topt)
				{
					return true;
				}
			}
			return false;
		};
		
		void AddOption(TOption& topt)
		{
			if(!this->HasOption(topt))
			{
				_options.Add(&topt);
			}
		};
		
		void AddBaseArg(TArg& arg)
		{
			if(!this->HasBaseArg(arg))
			{
				_base_args.Add(&arg);
			}
		};
	
	public:
	
		ArgSet():_is_match(false){};
	
		ArgSet(const ArgSet& arg_set)
		{
			_options = arg_set._options; // this picks, it could deep copy with <<= here
			_base_args = arg_set._base_args;
			_is_match = arg_set._is_match;
		};
	
		bool IsMatch(){return _is_match;};
		
		void Add(TArg& arg)				{ AddBaseArg(arg); };
		void Add(TOption& arg)			{ AddOption(arg); };
		ArgSet& operator<<(TArg& arg)	{ Add(arg); return *this; };
		ArgSet& operator<<(TOption& arg){ Add(arg); return *this; };
		
		// from AddArgSet to Add
		void Add(ArgSet& arg_set)
		{
			for(int i=0; i<arg_set._options.GetCount(); i++)
			{
				AddOption(*(arg_set._options[i]));
			}
			for(int i=0; i<arg_set._base_args.GetCount(); i++)
			{
				AddBaseArg(*(arg_set._base_args[i]));
			}
		};
		
		ArgSet& operator<<(ArgSet& arg_set)
		{
			Add(arg_set);
			return *this;
		};
		
		String GetArgSetStr()
		{
			String res("DELIMITED:\n");
			for(int i=0;i<_options.GetCount();i++){
				res.Cat( Format("\t%s\n", _options[i]->GetTitle()) );
			}
			res << " BASE:\n";
			for(int i=0;i<_base_args.GetCount();i++){
				res.Cat( Format("\t%s\n", _base_args[i]->GetTitle()) );
			}
			return res;
		};
		
};

#endif

