#include <time.h>
#include "Dice.h"


CMyParser::CMyParser(String sParse)
{
	m_bValid = false;
	
	if(sParse.IsEmpty())
		return;
	
	CParser p(sParse);
	try {
		m_sVal = AsString(Exp(p));
		m_bValid = true;
	} catch(CParser::Error e)
	{
		PromptOK("ERROR: " + e );
	}
}
	
double CMyParser::Term(CParser& p)
{
	if(p.Id("abs"))
	{
		p.PassChar('(');
		double x = Exp(p);
		p.PassChar(')');
		return fabs(x);
	}

	if(p.Char('('))
	{
		double x = Exp(p);
		p.PassChar(')');
		return x;
	}
	
	return p.ReadDouble();
}
	
double CMyParser::Mul(CParser& p)
{
	double x = Term(p);
	for(;;)
		if(p.Char('*'))
			x = x * Term(p);
		else
			if(p.Char('/')) {
				double y = Term(p);
				if(y == 0)
				p.ThrowError("Divide by zero");
				x = x / y;
			}
			else
				if(p.Char('D')) {
					int y  = Term(p);
					int ret = 0;
					for(int i=0; i<x ; i++)
					{
						ret += (double)(rand() % y + 1 );
					}
					x = ret;
				}
				else
					return x;
}

double CMyParser::Exp(CParser& p)
{
	double x = Mul(p);
	for(;;)
		if(p.Char('+'))
			x = x + Mul(p);
		else
			if(p.Char('-'))
				x = x - Mul(p);
			else
				return x;
}	


CDice::CDice()
{
	srand((unsigned)time( NULL ));
	
	s_Title = "Dice";
	
	SetRect(0, 0, 100, 100);
	Sizeable();
	BackPaint();
	
	this << m_cButDice.SizePos();
	
	m_cButDice <<= THISBACK(Roll);
	
	m_sRule = "1D6";
	Roll();
	ActiveFocus(m_cButDice);
}

void CDice::Roll()
{
	String buf = CMyParser(m_sRule);
	m_cButDice.SetLabel(buf);
	
	Layout();
	
	Title(s_Title + " - " + m_sRule);
}

void CDice::Layout()
{
	Rect rct = m_cButDice.GetRect();
	Size sz = GetTextSize(m_cButDice.GetDesc(), Arial(rct.GetHeight()));

	if (sz.cx > rct.GetWidth())
		sz.cy =  (double)rct.GetWidth()/(double)sz.cx * rct.GetHeight();

	m_cButDice.SetFont(Arial(sz.cy));
}



void CDice::ChildMouseEvent(Ctrl *child, int event, Point p, int zdelta, dword keyflags)
{
//	if (HasChildDeep(child))
	if(&m_cButDice == child)
	{
		if(event == RIGHTDOWN) MenuBar::Execute(THISBACK(SetMenuBar));
	}
	TopWindow::ChildMouseEvent(child, event, p, zdelta, keyflags);
}

void CDice::SetMenuBar(Bar& bar)
{
	const char* sVal[] = {"1D6", "1D9", NULL };
	int count = sizeof(sVal)/sizeof(char*);
	
	bool bOther = true;
	
	for(int i = 0; i<count; i++)
	{
		if (sVal[i])
		{
			bOther &=  !m_sRule.IsEqual(sVal[i]);
			bar.Add(sVal[i], THISBACK1(Click2, sVal[i])).Radio(m_sRule.IsEqual(sVal[i]));
		}
		else
			bar.Separator();
	}
	
	if (bOther)
		bar.Add(m_sRule, THISBACK(OtherClick)).Radio(true);
	else 
		bar.Add("Other", THISBACK(OtherClick)).Radio(false);
}

void CDice::OtherClick()
{
	WithRule<TopWindow> dlg;
	CtrlLayoutOKCancel(dlg, "Rule");
	
	dlg.rule <<= m_sRule;
	
	do
	{
		if(dlg.Run() != IDOK)
			return;
	} while (!CMyParser(~dlg.rule).IsValid());

	
	m_sRule = ~dlg.rule;
	Roll();
}

GUI_APP_MAIN
{

	CDice().Run();
}

