#ifndef _Dice_Dice_h
#define _Dice_Dice_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <Dice/Dice.lay>
#include <CtrlCore/lay.h>


class CMyParser
{
protected:
	String m_sVal;
	bool m_bValid;
public:
	CMyParser(String sParse);
	
	double Term(CParser& p);
	double Mul(CParser& p);
	double Exp(CParser& p);
	
	operator String () { return m_sVal;}
	String GetValue() { return m_sVal;}
	bool IsValid() { return m_bValid; }
};

class CDice : public TopWindow {
protected:
	Button m_cButDice;
	String m_sRule;
	String s_Title;

public:
	typedef CDice CLASSNAME;
	
	CDice();
	
	void Roll();
	void Layout();

	void OtherClick();
	void Click2(String sVal) { m_sRule = sVal; Roll(); }
	
	void ChildMouseEvent(Ctrl *child, int event, Point p, int zdelta, dword keyflags);

	void SetMenuBar(Bar& bar);
};

#endif

