#ifndef _SysInfo_SysInfo_h
#define _SysInfo_SysInfo_h

using namespace Upp;

/////////////////////////////////////////////////////////////////////
// Different functions

// Append a file after other
bool FileCat(const char *file, const char *appendFile);

// Convert a long int a String
String FormatLong(long a); 

// Search a file fith name with wildcards in a dir and subdirectories with certain text inside
Array<String> SearchFile(String dir, String condFile, String text = "");

// As LoadFile but it works in Linux for files automatically generated by the OS
#ifdef PLATFORM_POSIX 
String LoadFile_Safe(String fileName);
#endif
#if defined(PLATFORM_WIN32) 
#define LoadFile_Safe LoadFile		// Not necessary in Windows
#endif

// Gets the program that will open by default the files with extension ext
String GetExtExecutable(const String ext);

// Open the file with the adecuated program defined in the OS by default
bool LaunchFile(const String file);

// Functions to launch command line programs
// readCallBack is a function to manage the program output
// Returns the command exit code
int LaunchCommand(const char *cmd, void (*readCallBack)(String &));
// ret gets all the program output
// Returns the command exit code
int LaunchCommand(const char *cmd, String &ret);
// It returns the program output
String LaunchCommand(const char *cmd);

// A ProcessEvents than can be used in non gui programs
inline void DoEvents()
{ 
#ifdef CTRLLIB_H
		Ctrl::ProcessEvents();
#endif
}

// A String based class to parse into
class StringParse :  public String {
public:
	void GoInit()	{pos = 0; lastSeparator='\0';};
	StringParse():String("") {GoInit();};
	StringParse(String s): String(s) {GoInit();};
	bool GoBefore(const String text)
	{
		int newpos = Find(text, pos);
		if (newpos < 0)
			return false;	// If it does not find it, it does not move
		pos = newpos;
		return true;
	};	
	bool GoAfter(const String text)
	{
		if(!GoBefore(text))
			return false;
		pos += strlen(text);
		return true;
	};
	bool GoAfter(const String text, const String text2)
	{
		if(!GoAfter(text))
			return false;
		if(!GoAfter(text2))
			return false;
		return true;
	};
	bool GoAfter(const String text, const String text2, const String text3)
	{
		if(!GoAfter(text))
			return false;
		if(!GoAfter(text2))
			return false;
		if(!GoAfter(text3))
			return false;
		return true;
	};
	bool GoAfter_Init(const String text) {GoInit();	return GoAfter(text);};
	bool GoAfter_Init(const String text, const String text2) {GoInit();	return GoAfter(text, text2);};
	bool GoAfter_Init(const String text, const String text2, const String text3) {GoInit();	return GoAfter(text, text2, text3);};		
	
	void GoBeginLine()
	{
		for (; pos >= 0; --pos) {
			if ((ToString()[pos-1] == '\r') || (ToString()[pos-1] == '\n'))
				return;
		} 
	}
	bool IsBeginLine()
	{
		if (pos == 0)
			return true;
		if ((ToString()[pos-1] == '\r') || (ToString()[pos-1] == '\n'))
			return true;
		return false;
	}
	// Gets text between "" or just a word until an space
	// It considers special characters with \ if between ""
	// If not between "" it gets the word when it finds one of the separator characters
	String GetText(String separators = "")	
	{
		String ret = "";
		if (pos > GetCount())
			return ret;
		int newpos = pos;
		
		while ((IsSpace(ToString()[newpos]) && (ToString()[newpos] != '\"') && 
			   (ToString()[newpos] != '\0')))
			newpos++;
		if (ToString()[newpos] == '\0')
			return "";
	
		if (ToString()[newpos] == '\"') {	// Between ""
			newpos++;
			while (ToString()[newpos] != '\"' && ToString()[newpos] != '\0') {
				if (ToString()[newpos] == '\\') {
					newpos++;
					if (ToString()[newpos] == '\0')
						return "";
				} 
				ret.Cat(ToString()[newpos]);
				newpos++;
			}
			lastSeparator = '"';
		} else if (separators == "") {		// Simple word
			while (!IsSpace(ToString()[newpos]) && ToString()[newpos] != '\0') {
				if (ToString()[newpos] == '\"') {
					newpos--;	// This " belongs to the next
					break;
				}
				ret.Cat(ToString()[newpos]);
				newpos++;
			}
			lastSeparator = ToString()[newpos];
		} else {							// Simple word, special separator
			while (ToString()[newpos] != '\0') {// Only conider included spaces (!IsSpace(ToString()[newpos]) && ToString()[newpos] != '\0') {
				if (ToString()[newpos] == '\"') {
					newpos--;	// This " belongs to the next
					break;
				}				
				if (separators.Find(ToString()[newpos]) >= 0) {
					lastSeparator = ToString()[newpos];
					break;
				}
				ret.Cat(ToString()[newpos]);
				newpos++;
			} 
			lastSeparator = ToString()[newpos];
		}
		pos = ++newpos;		// After the separator: ", space or separator
		return ret;
	}
	String GetLine()
	{
		return GetText("\r\n");
	}
	double GetDouble(String separators = "")  	{return atof(GetText(separators));};
	int GetInt(String separators = "")			{return atoi(GetText(separators));};
	long GetLong(String separators = "")		{return atol(GetText(separators));};
	uint64 GetUInt64(String separators = "")	
#if defined(PLATFORM_WIN32) 
	{return _atoi64(GetText(separators));};
#endif
#ifdef PLATFORM_POSIX
	{return atoll(GetText(separators));};
#endif
	
	String Right() {return String::Right(GetLength()-pos);}
	int GetLastSeparator() {return lastSeparator;}
	void MoveRel(int val)
	{
		pos += val;
		if (pos < 0)
			pos = 0;
		else if (pos >= GetCount())
			pos = GetCount() - 1;
	}
private:
	int pos;
	int lastSeparator;
};

/////////////////////////////////////////////////////////////////////
// Special Folders
// Get the path to special folders
String GetDesktopFolder();
String GetProgramsFolder();
String GetAppDataFolder();
String GetMusicFolder();
String GetPicturesFolder();
String GetVideoFolder();
String GetPersonalFolder();
String GetTemplatesFolder();
String GetDownloadFolder();
String GetRootFolder();
String GetTempFolder();
String GetOsFolder();
String GetSystemFolder();

/////////////////////////////////////////////////////////////////////
// Processor Info
void GetSystemInfo(String &manufacturer, String &productName, String &version, int &numberOfProcessors);
void GetBiosInfo(String &biosVersion, Date &biosReleaseDate);
bool GetProcessorInfo(int number, String &vendor, String &identifier, String &architecture, int &speed);		
// Gets the real CPU speed in MHz
int GetCpuSpeed();

/////////////////////////////////////////////////////////////////////
// Memory Info
bool GetMemoryInfo(int &memoryLoad, uint64 &totalPhys, uint64 &freePhys, uint64 &totalPageFile, uint64 &freePageFile, uint64 &totalVirtual, uint64 &freeVirtual);

/////////////////////////////////////////////////////////////////////
// Windows list
// They get arrays with handles to all the opened windows with additional info as 
// pid: Handle to the process that manages the window
// name: Window name
// fileName: Window process program file name
// title: Window title (caption)
void GetWindowsList(Array<long> &wid, Array<long> &pid, Array<String> &name, Array<String> &fileName, Array<String> &title);
Array<long> GetWindowsList();

/////////////////////////////////////////////////////////////////////
// Process list
// They get arrays with handles to all the opened processes and process names 
bool GetProcessList(Array<long> &pid, Array<String> &pNames);
Array<long> GetProcessList();
String GetProcessName(long pid);
// Gets the program file name of a process
String GetProcessFileName(long processID);

// Gets the process id of a program with a window with certain title
long GetProcessIdFromWindowCaption(String windowCaption, bool exactMatch = false);

long GetProcessIdFromWindowId(long wid);
long GetWindowIdFromProcessId(long pid);

// Ends a process by any means
bool ProcessTerminate(long pid, int timeout = 500);

// Gets the process priority as a number from 0 (minimum) to 10 (maximum)
int GetProcessPriority(long pid);
bool SetProcessPriority(long pid, int priority);

// True if a process with handle pid exists
bool ProcessExists(long pid);

/////////////////////////////////////////////////////////////////////
// Os Info
bool GetOsInfo(String &kernel, String &kerVersion, String &kerArchitecture, String &distro, String &distVersion, String &desktop, String &deskVersion);
String GetDesktopManagerNew();

/////////////////////////////////////////////////////////////////////
// Drives list
// Get the dirve path list
Array<String> GetDriveList();
// Get drives info
// Return false if drive is not mounted or it is not accesible
bool GetDriveSpace(String drive, uint64 &freeBytesUser, uint64 &totalBytesUser, uint64 &totalFreeBytes);
bool GetDriveInformation(String drive, String &type, String &volume, /*uint64 &serial, */int &maxName, String &fileSystem);

/////////////////////////////////////////////////////////////////////
// Others
// Gets process id
long GetProcessId();

// I tries to "logoff", "reboot" or "shutdown"
bool Shutdown(String action);

// It converts an amount of bytes to compact size
String BytesToKMGT(uint64 bytes);

// It gets compiler info
void GetCompilerInfo(String &name, int &version, String &date);

// It gets info about the battery status
bool GetBatteryStatus(bool &discharging, int &percentage, int &remainingMin);
// Get if there is battery
bool GetBatteryInfo(bool &present/*, int &designCapacity, int &lastFullCapacity, String &vendor, String &type, String &model, String &serial*/);	

#endif


// Known bugs
// GetWindowsList does not get the window title in Kde
// Shutdown in Linux only works with option "logoff", probably because of user permissions
