#include "FontScript.h"

String RangeStr(int start, int end, FontInfo& fi)
{
	String s;
	s << "\n\t\t";
	for (int j = start; j<= end; j++)
	{
		s << (fi.HasChar(j) ? '#' : '_') << FormatIntHex(j, 5) << ' ';
		if (j > start && (j - start) % 20 == 0)
			s << "\n\t\t";
	}
	s << '\n';
	return s;
}

FontScript::FontScript()
{
	CtrlLayout(*this, "Window title");
	MaximizeBox().Zoomable().Sizeable().Maximize();
	
	StringBuffer s(4000);
	s.Clear();
	for (int i = 0; i <= Font::GetFaceCount(); i++)
	{
		Font f = Font(i, 12);
		s << f.GetFaceName() << '\n';
		
		FontInfo fi = f.Info();
		
		{
			const int start = 0x0000;
			const int end = 0x007F;
			s << "\tBasic Latin: ";
			if (!fi.HasCharRange(0x0000, 0x001F) && fi.HasCharRange(0x0020, 0x007E) && !fi.HasChar(0x007F))
				s << "Default\n";
			else if (fi.CharRangeEmpty(0x0000, 0x007F))
			    s << "None\n";     
			else
				s << RangeStr(start, end, fi);
		}
		
		{
			const int start = 0x0080;
			const int end = 0x00FF;
			s << "\tLatin-1 Supplement: ";
			if (!fi.HasCharRange(0x0080, 0x009F) && fi.HasCharRange(0x00A0, 0x00FF))
				s << "Default\n";
			else if (fi.CharRangeEmpty(0x0080, 0x009F))
			    s << "None\n";     
			else
				s << RangeStr(start, end, fi);
		}
		
		{
			const int start = 0x0100;
			const int end = 0x017F;
			s << "\tLatin Extended-A: ";
			if (fi.HasCharRange(start, end))
				s << "Default\n";
			else if (fi.CharRangeEmpty(start, end))
			    s << "None\n";     
			else
				s << RangeStr(start, end, fi);
		}
		
		{
			const int start = 0x0180;
			const int end = 0x024F;
			s << "\tLatin Extended-B: ";
			if (fi.HasCharRange(start, end))
				s << "Default\n";
			else if (fi.CharRangeEmpty(start, end))
			    s << "None\n";     
			else
				s << RangeStr(start, end, fi);
		}
		
		{
			const int start = 0x0250;
			const int end = 0x02AF;
			s << "\tIPA Extensions: ";
			if (fi.HasCharRange(start, end))
				s << "Default\n";
			else if (fi.CharRangeEmpty(start, end))
			    s << "None\n";     
			else
				s << RangeStr(start, end, fi);
		}
		
		{
			const int start = 0x02B0;
			const int end = 0x02FF;
			s << "\tSpacing Modifier Letters: ";
			if (fi.HasCharRange(start, end))
				s << "Default\n";
			else if (fi.CharRangeEmpty(start, end))
			    s << "None\n";     
			else
				s << RangeStr(start, end, fi);
		}
		
		{
			const int start = 0x0300;
			const int end = 0x036F;
			s << "\tCombining Diacritical Marks: ";
			if (fi.HasCharRange(start, end))
				s << "Default\n";
			else if (fi.CharRangeEmpty(start, end))
			    s << "None\n";     
			else
				s << RangeStr(start, end, fi);
		}
		
		{
			const int start = 0x0370;
			const int end = 0x03FF;
			s << "\tGreek & Coptic: ";
			if (fi.HasCharRange(0x0370, 0x0377) && !fi.HasCharRange(0x0378, 0x0379) && fi.HasCharRange(0x037A, 0x037E) 
					&& !fi.HasCharRange(0x037F, 0x0383) && fi.HasCharRange(0x0384, 0x038A) && !fi.HasChar(0x038B)
					&& fi.HasChar(0x038C) && !fi.HasChar(0x038D) && fi.HasCharRange(0x038E, 0x03A1) && !fi.HasChar(0x03A2)
					&& fi.HasCharRange(0x03A3, 0x03FF))
				s << "Default\n";
			else if (fi.CharRangeEmpty(start, end))
			    s << "None\n";     
			else
				s << RangeStr(start, end, fi);
		}
		
		{
			const int start = 0x0400;
			const int end = 0x04FF;
			s << "\tCyrillic: ";
			if (fi.HasCharRange(start, end))
				s << "Default\n";
			else if (fi.CharRangeEmpty(start, end))
			    s << "None\n";     
			else
				s << RangeStr(start, end, fi);
		}
		
		{
			const int start = 0x0500;
			const int end = 0x0523;
			s << "\tCyrillic Supplement: ";
			if (fi.HasCharRange(start, end))
				s << "Default\n";
			else if (fi.CharRangeEmpty(start, end))
			    s << "None\n";     
			else
				s << RangeStr(start, end, fi);
		}
		
		{
			const int start = 0x0531;
			const int end = 0x058A;
			s << "\tArmenian: ";
			if (fi.HasCharRange(start, 0x0556) && fi.HasCharRange(0x0559, 0x0559) && fi.HasCharRange(0x0561, 0x0587) && fi.HasCharRange(0x0589, 0x058A))
				s << "Default\n";
			else if (fi.CharRangeEmpty(start, end))
			    s << "None\n";     
			else
				s << RangeStr(start, end, fi);
		}
		
		{
			const int start = 0x0591;
			const int end = 0x05F4;
			s << "\tHebrew: ";
			if (fi.HasCharRange(start, 0x05C7) && fi.HasCharRange(0x05D0, 0x05EA) && fi.HasCharRange(0x05F0, 0x05F4))
				s << "Default\n";
			else if (fi.CharRangeEmpty(start, end))
			    s << "None\n";     
			else
				s << RangeStr(start, end, fi);
		}
		
		{
			const int start = 0x0600;
			const int end = 0x06FF;
			s << "\tArabic: ";
			if (fi.HasCharRange(0x0621, 0x065E) && fi.HasCharRange(0x0670, 0x06FF) && fi.HasCharRange(0x0600, 0x0603) && fi.HasCharRange(0x0606, 0x061B) && fi.HasCharRange(0x061E, 0x061F))
				s << "Default\n";
			else if (fi.CharRangeEmpty(start, end))
			    s << "None\n";     
			else
				s << RangeStr(start, end, fi);
		}
		
		s << "\n";
	}
	lst.Set(s);
}

GUI_APP_MAIN
{
	FontScript().Run();
}

